#!/usr/local/bin/perl
# email.pl
# Email a received message in WAV format to some address

$no_acl_check++;
require './vgetty-lib.pl';
&foreign_check("sendmail") || die "Sendmail module not installed";
&foreign_require("sendmail", "sendmail-lib.pl");
&foreign_require("sendmail", "boxes-lib.pl");

# Get the WAV format message and construct the email
open(OUT, "rmdtopvf $ARGV[0] 2>/dev/null | pvftowav 2>/dev/null |");
while(read(OUT, $buf, 1024)) {
	$wav .= $buf;
	}
close(OUT);
$now = localtime(time());
$host = &get_system_hostname();
$body = "Voicemail message received at $now by $host";
$mail = { 'headers' => [ [ 'From', "webmin\@$host" ],
		         [ 'To', $config{'email_to'} ],
		         [ 'Subject', 'Voicemail message' ] ],
	  'attach' => [ { 'headers' => [ [ 'Content-Type', 'text/plain' ] ],
			  'data' => $body },
		        { 'headers' => [ [ 'Content-Transfer-Encoding',
					 'base64' ],
					 [ 'Content-Type',
					   'audio/wav; name="voicemail.wav"' ]],
			  'data' => $wav } ]
	};

# Send the email
&sendmail::send_mail($mail);

