#!/usr/local/bin/perl
# delete_mod.cgi
# Delete selected modules from webmin, without asking

require './webmin-lib.pl';
&ReadParse();
&error_setup($text{'delete_err'});
@mods = split(/\0/, $in{'mod'});
@mods || &error($text{'delete_enone'});

# check if any other module depends on those to be deleted
foreach $minfo (&get_all_module_infos()) {
	if (&check_os_support($minfo) && &indexof($minfo->{'dir'}, @mods) < 0) {
		foreach $d (split(/\s+/, $minfo->{'depends'})) {
			$depends{$d} = $minfo->{'desc'};
			}
		}
	}
foreach $m (@mods) {
	%minfo = &get_module_info($m);
	%minfo = &get_theme_info($m) if (!%minfo);
	if (!-l "$root_directory/$m" && $depends{$m}) {
		&error(&text('delete_edep', "<tt>$minfo{'desc'}</tt>",
			     "<tt>$depends{$m}</tt>"));
		}
	}

# ask the user if he is sure
if (!$in{'confirm'}) {
	&header($text{'delete_title'}, "");
	print "<hr>\n";
	print "<p><form action=delete_mod.cgi>\n";
	foreach $m (@mods) {
		local %minfo = &get_module_info($m);
		if (%minfo) {
			$module++;
			}
		else {
			$theme++;
			%minfo = &get_theme_info($m);
			}
		print "<input type=hidden name=mod value=$m>\n";
		$total += &disk_usage_kb("$root_directory/$m")
			if (!-l "$root_directory/$m");
		$descs .= " , " if ($descs);
		$descs .= "<b>$minfo{'desc'}</b>";
		}
	print "<center>",&text($theme ? 'delete_rusure2' :
			       $total ? 'delete_rusure' : 'delete_rusure3',
			       int($total), $descs),"<p>",
	      "<input type=submit name=confirm value='$text{'delete'}'><br>\n";
	print "<input type=checkbox name=acls value=1> $text{'delete_acls'}\n"
		if ($module);
	print "</form></center><hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}

# delete the selected modules or themes
foreach $m (split(/\0/, $in{'mod'})) {
	next if (!$m || !-d "$root_directory/$m");
	push(@mdesc, &delete_webmin_module($m, $in{'acls'}));
	}
&flush_webmin_caches();

&header($text{'delete_title'}, "");
print "<hr>\n";
print $text{'delete_msg'},"<p>\n";
print "<ul>\n";
for($i=0; $i<@mdesc; $i++) {
	print $mdesc[$i],"<p>\n";
	}
print "</ul><p>\n";
print "<hr>\n";
&footer("", $text{'index_return'});

