#ifndef INCL_APPWINDOW_H
#define INCL_APPWINDOW_H

/*-----------------------------------------------------------------------
 * Xclasses header file
 * 
 * Copyright (C) 1998 Jrgen Schmitz
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *-----------------------------------------------------------------------
 */

#include <Xclasses/types.h>
#include <Xclasses/Xwindows.h>
#include <Xclasses/Xcolors.h>
#include <Xclasses/group.h>
#include <Xclasses/menu.h>
#include <Xclasses/gfx_object.h>

#define EV_NOTHING		0
#define EV_GADGET		1
#define EV_WINDOWCLOSE	2
#define EV_TICK			3
#define EV_FINISH		4
#define EV_WAKEUP		5

class appwindow : public Xwindows
{
	friend class pappwindow;

	class pappwindow *p;	

public:

	appwindow(void);
	appwindow(char *);
	virtual ~appwindow(void);

	void InitSize(int x,int y,int w,int h);
	void InitSize(int x,int y,int p);
	void InitSize(int p);
	int Init(int &argc,char *argv[]);
	int Init(int &argc,char *argv[],char *basecolor);
	int Init(void);

	void Adjust(int x,int y,int w,int h, int a=ADJUST_CENTER|ADJUST_MIDDLE);

	int  Create(void);
	void Close(void);
	
	void SetGroup(group *);
	void SetGroup(group &);
	void SetExtraGroup(group *);
	void SetExtraGroup(group &);
	void ExtraRight(void);
	void ExtraBottom(void);	// default
	void SetMenu(menu *);
	void SetMenu(menu &);
	void Callback(void cfunc(appwindow *));
	void Callback(void *c,void cfunc(appwindow *));
	void Callback(callable *c,void (callable::*func)(class appwindow*));
	void Callback(void *c, ...);
	void Callback(void);	// calls Close()

	void Block(int b=0);
	void Unblock(int b=0);
	void BlockExcept(int b=0);
	void UnblockExcept(int b=0);

	void ShowExtra(void);
	void HideExtra(void);

	int HandleEvent(XEvent *event);

	int CloseMe(void);

	static int NextEvent(void);
	static int UpdateEvent(void);
	static int TickEvent(void);

	static int DoubleClick(void);
	static int ID(void);

	static void CloseAll(void);
	static void WakeUp(void);
};

#define CLOSECALLBACK void (callable::*)(class appwindow*)

#endif
