;;; jis2gb.el -- Mule's interface for jis2gb by Kenichi Handa
(defvar jis2gb-program "jis2gb")
(defvar jis2gb-arg-list '("-g"))

(modify-coding-system-alist 'process jis2gb-program 'iso-2022-7bit)

(defun jis2gb-region (from to)
  "Convert Japanese text (JIS) in the region FROM and TO to Chinese (GB).
The conversion is done by outernal program `jis2gb'."
  (interactive "r")
  (apply 'call-process-region from to jis2gb-program t t t jis2gb-arg-list))

(defun jis2gb-buffer ()
  "Convert Japanese text (JIS) in the current buffer to Chinese (GB).
The conversion is done by outernal program `jis2gb'."
  (interactive)
  (jis2gb-region (point-min) (point-max)))
