/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class MyClipper {
    static final int C_LEFT = 0;
    static final int C_RIGHT = 1;
    static final int C_TOP = 2;
    static final int C_BOTTOM = 3;
    Dimension dim = new Dimension();

    MyClipper() {
    }

    public boolean clipPoint(Point point) {
        if (point == null) {
            return false;
        }
        return point.x >= 0 && point.x <= this.dim.width && point.y >= 0 && point.y <= this.dim.height;
    }

    public void setClipRange(Dimension dimension) {
        this.dim = dimension;
    }

    public Rectangle lineclip(Point point, Point point2) {
        Rectangle rectangle = new Rectangle(point.x, point.y, point2.x, point2.y);
        rectangle = this.clipByLine(rectangle, 0, 0);
        rectangle = this.clipByLine(rectangle, this.dim.width, 1);
        rectangle = this.clipByLine(rectangle, 0, 2);
        rectangle = this.clipByLine(rectangle, this.dim.height, 3);
        return rectangle;
    }

    private Rectangle clipByLine(Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        Polygon polygon = new Polygon();
        boolean bl = this.insideArea(n3, n4, n, n2);
        if (this.insideArea(n5, n6, n, n2)) {
            if (bl) {
                polygon.addPoint(n3, n4);
                polygon.addPoint(n5, n6);
            } else {
                Point point = this.getCrossing(n3, n4, n5, n6, n, n2);
                polygon.addPoint(point.x, point.y);
                polygon.addPoint(n5, n6);
            }
        } else if (bl) {
            Point point = this.getCrossing(n3, n4, n5, n6, n, n2);
            polygon.addPoint(point.x, point.y);
            polygon.addPoint(n3, n4);
        }
        Rectangle rectangle2 = new Rectangle();
        rectangle2.x = polygon.xpoints[0];
        rectangle2.y = polygon.ypoints[0];
        rectangle2.width = polygon.xpoints[1];
        rectangle2.height = polygon.ypoints[1];
        return rectangle2;
    }

    private boolean insideArea(int n, int n2, int n3, int n4) {
        switch (n4) {
            case 0: {
                if (n < n3) break;
                return true;
            }
            case 1: {
                if (n > n3) break;
                return true;
            }
            case 2: {
                if (n2 < n3) break;
                return true;
            }
            case 3: {
                if (n2 > n3) break;
                return true;
            }
        }
        return false;
    }

    private Point getCrossing(int n, int n2, int n3, int n4, int n5, int n6) {
        Point point = new Point(0, 0);
        switch (n6) {
            case 0: 
            case 1: {
                point.x = n5;
                point.y = ((n2 - n4) * n5 + (n * n4 - n3 * n2)) / (n - n3);
                break;
            }
            case 2: 
            case 3: {
                point.x = ((n - n3) * n5 - (n * n4 - n3 * n2)) / (n2 - n4);
                point.y = n5;
                break;
            }
        }
        return point;
    }
}

