/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;

public class SkyCanvas
extends Canvas
implements Runnable {
    static int maxCircleLevel = 10;
    Vector pointVect = new Vector();
    SkyPainter sptr;
    SETISupport boss;
    Random dice = new Random(0L);
    final Dimension mySize = new Dimension(964, 482);
    ScrollPane parentSp;
    Image skyImage;
    int tracx;
    int tracy;
    Image offscreen = null;
    Dimension offscreensize;
    Graphics offgraphics;
    Thread relaxer;
    Font font;
    boolean progDisplayFlag = false;
    boolean gpDisplayFlag = false;
    boolean clDisplayFlag = true;
    String msgString;
    int msgcount = 0;
    int animetime = 100;
    boolean alwaysCenterFlag = false;
    int cpaintmode = 0;
    int apaintmode = 0;
    int ablinkmode = 2;
    int bpaintmode = 0;
    Vector starVect = new Vector();
    Vector cstVect = new Vector();
    Vector gridVect = new Vector();
    Vector bringVect = new Vector();
    Point morigin;
    double originra;
    double originde;
    boolean mouseDownFlag = false;
    Vector vptvect = new Vector();
    boolean autoAngleFlag = true;

    public SkyCanvas(SETISupport sETISupport) {
        try {
            this.skyImage = Toolkit.getDefaultToolkit().createImage((ImageProducer)this.getClass().getResource("SKYMAP.GIF").getContent());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        this.setSize(this.mySize);
        Dimension dimension = this.getSize();
        this.tracx = dimension.width / 2;
        this.tracy = dimension.height / 2;
        this.boss = sETISupport;
        String[] stringArray = this.getToolkit().getFontList();
        this.font = new Font(stringArray[0], 0, 10);
        this.sptr = new SkyPainter(this);
        this.setPaintMode(0);
        this.readTData();
        this.setGrid();
        SymMouse symMouse = new SymMouse();
        this.addMouseListener(symMouse);
        SymMouseMotion symMouseMotion = new SymMouseMotion();
        this.addMouseMotionListener(symMouseMotion);
    }

    public void start() {
        this.relaxer = new Thread(this);
        this.relaxer.start();
        this.relaxer.setPriority(1);
    }

    public void stop() {
        if (this.relaxer != null) {
            this.relaxer.stop();
        }
    }

    public void suspend() {
        if (this.relaxer != null) {
            this.relaxer.suspend();
        }
    }

    public void resume() {
        if (this.relaxer != null) {
            this.relaxer.resume();
        }
    }

    public void run() {
        while (true) {
            this.repaint();
            try {
                Thread.sleep(this.animetime);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void setAnimeTime(int n) {
        this.animetime = n;
    }

    public void setParentSp(ScrollPane scrollPane) {
        this.parentSp = scrollPane;
    }

    public void setMessage(String string) {
        this.msgString = new String(string);
        this.msgcount = 3000 / this.animetime;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.bpaintmode == 0) {
            super.setBounds(n, n2, this.mySize.width, this.mySize.height);
        } else if (this.bpaintmode == 1 || this.bpaintmode == 2 || this.bpaintmode == 3) {
            super.setBounds(n, n2, n3, n4);
        }
    }

    public Dimension getMinimumSize() {
        if (this.bpaintmode == 0) {
            return this.mySize;
        }
        return super.getMinimumSize();
    }

    public Dimension getPreferredSize() {
        if (this.bpaintmode == 0) {
            return this.mySize;
        }
        return super.getMinimumSize();
    }

    public void setPMode(int n) {
        this.cpaintmode = n;
    }

    public void setAPMode(int n) {
        this.apaintmode = n;
    }

    public void setABMode(int n) {
        this.ablinkmode = n;
        if (this.ablinkmode != 2) {
            int n2 = 0;
            while (n2 < this.pointVect.size()) {
                PointData pointData = (PointData)this.pointVect.elementAt(n2);
                pointData.setLevel((int)(this.dice.nextDouble() * (double)maxCircleLevel));
                ++n2;
            }
            this.bringVect.removeAllElements();
        }
    }

    public int getABMode() {
        return this.ablinkmode;
    }

    public void setProgDisplay(boolean bl) {
        this.progDisplayFlag = bl;
    }

    public void setGpDisplay(boolean bl) {
        this.gpDisplayFlag = bl;
    }

    public void setCLDisplay(boolean bl) {
        this.clDisplayFlag = bl;
    }

    public void setCenterFlag(boolean bl) {
        this.alwaysCenterFlag = bl;
        this.setScrollPos();
    }

    public void setPaintMode(int n) {
        this.vptvect.removeAllElements();
        this.bpaintmode = n;
        this.sptr.setPaintMode(n);
        this.sptr.setVra(0.0);
        this.sptr.setVde(0.0);
        if (n == 0) {
            this.setSize(this.mySize);
        }
        this.repaint();
    }

    public void setVangle(int n) {
        this.sptr.setVangle(n);
        this.setScrollPos();
    }

    public void setGridMode(boolean bl) {
        this.sptr.setGridMode(bl);
    }

    public void setTopMode(boolean bl) {
        this.sptr.setTopMode(bl);
    }

    public void setCstMode(int n) {
        this.sptr.setCstMode(n);
    }

    public void setCstNameMode(int n) {
        this.sptr.setCstNameMode(n);
    }

    public boolean getMouseDownFlag() {
        return this.mouseDownFlag;
    }

    public void setStarBr(double d) {
        this.sptr.setStarBr(d);
    }

    public void setSybSize(String string) {
        this.sptr.setSybSize(string);
    }

    public Dimension getSkyMapSize() {
        if (this.bpaintmode == 0) {
            return this.mySize;
        }
        return this.getSize();
    }

    public void setStarTrace(boolean bl) {
        this.sptr.setStarTrace(bl);
    }

    public void setAutoVangle(boolean bl) {
        this.autoAngleFlag = bl;
    }

    public void update(Graphics graphics) {
        Cloneable cloneable;
        this.sptr.setClipRange(this.getSize());
        if (this.vptvect.size() > 0) {
            this.sptr.setTailBr(this.vptvect.size());
            cloneable = (Point)this.vptvect.elementAt(0);
            this.sptr.setVra((double)((Point)cloneable).x / 1000.0);
            this.sptr.setVde((double)((Point)cloneable).y / 1000.0);
            this.vptvect.removeElementAt(0);
        }
        if (this.autoAngleFlag) {
            this.autoAngleAdjust();
        }
        cloneable = this.getSize();
        if (this.offscreen == null || cloneable.width != this.offscreensize.width || cloneable.height != this.offscreensize.height) {
            this.offscreen = this.createImage(cloneable.width, cloneable.height);
            this.offscreensize = cloneable;
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.paintBackground(this.offgraphics);
        this.paintPoints(this.offgraphics);
        this.sptr.checkMovement();
        graphics.drawImage(this.offscreen, 0, 0, null);
        if (this.ablinkmode == 2) {
            Vector<BlinkRing> vector = new Vector<BlinkRing>();
            int n = 0;
            while (n < this.bringVect.size()) {
                BlinkRing blinkRing = (BlinkRing)this.bringVect.elementAt(n);
                blinkRing.expand();
                if (!blinkRing.liveP()) {
                    vector.addElement(blinkRing);
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                this.bringVect.removeElement(vector.elementAt(n2));
                ++n2;
            }
        }
    }

    private void paintBackground(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        switch (this.bpaintmode) {
            case 0: {
                graphics.drawImage(this.skyImage, 0, 0, this);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.sptr.paintStarData(graphics, this.starVect);
                this.sptr.paintGrid(this.offgraphics, this.gridVect);
                this.sptr.paintCst(this.offgraphics, this.cstVect);
                break;
            }
        }
    }

    void paintPoints(Graphics graphics) {
        Object object;
        Vector<PointData> vector = new Vector<PointData>();
        int n = 0;
        while (n < this.pointVect.size()) {
            PointData pointData = (PointData)this.pointVect.elementAt(n);
            pointData.addLevel();
            if (pointData.getVisible()) {
                if (pointData.getSelected()) {
                    vector.addElement(pointData);
                } else {
                    vector.insertElementAt(pointData, 0);
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            object = (PointData)vector.elementAt(n2);
            if (!((PointData)object).getFinished()) {
                this.sptr.paintIngNode((PointData)object, graphics, this.cpaintmode);
                this.sptr.paintTermParticle((PointData)object, graphics);
                if (((PointData)object).getLevel() == maxCircleLevel - 1) {
                    this.bringVect.addElement(new BlinkRing(((PointData)object).getPoint()));
                }
                if (this.progDisplayFlag) {
                    this.sptr.paintProgValue((PointData)object, graphics);
                }
            } else {
                boolean bl = true;
                if (this.ablinkmode == 2) {
                    int n3 = maxCircleLevel;
                    int n4 = 0;
                    while (n4 < this.bringVect.size()) {
                        BlinkRing blinkRing = (BlinkRing)this.bringVect.elementAt(n4);
                        int n5 = blinkRing.getLevel(((PointData)object).getPoint());
                        if (n5 < n3) {
                            n3 = n5;
                        }
                        ++n4;
                    }
                    ((PointData)object).setLevel(n3);
                } else if (this.ablinkmode == 1 && ((PointData)object).getLevel() < maxCircleLevel / 2) {
                    bl = false;
                }
                this.sptr.paintEdNode((PointData)object, graphics, this.apaintmode, this.ablinkmode, bl);
            }
            if (((PointData)object).getSelected()) {
                if (this.clDisplayFlag) {
                    Point point = this.sptr.paintCrossLine(graphics, (PointData)object, this.tracx, this.tracy);
                    this.tracx = point.x;
                    this.tracy = point.y;
                }
                if (this.gpDisplayFlag) {
                    this.sptr.paintGPattern((PointData)object, graphics);
                }
            }
            ++n2;
        }
        if (this.msgcount > 0) {
            object = graphics.getFontMetrics();
            graphics.setColor(Color.red);
            Point point = new Point();
            if (this.bpaintmode == 0) {
                point = this.parentSp.getScrollPosition();
            }
            graphics.drawString(this.msgString, point.x + 10, point.y + ((FontMetrics)object).getHeight() * 2);
            --this.msgcount;
        }
    }

    public void addPoint(double d, double d2, ResultData resultData, boolean bl) {
        int n = (int)(this.dice.nextDouble() * (double)maxCircleLevel);
        PointData pointData = new PointData(n, maxCircleLevel, resultData);
        pointData.setColor(resultData.getColorName());
        this.pointVect.addElement(pointData);
    }

    public void selectPt(PointData pointData) {
        if (pointData == null) {
            return;
        }
        int n = 0;
        while (n < this.pointVect.size()) {
            PointData pointData2 = (PointData)this.pointVect.elementAt(n);
            pointData2.setSelected(false);
            ++n;
        }
        pointData.setSelected(true);
        this.setScrollPos();
    }

    public void setScrollPos() {
        if (this.alwaysCenterFlag) {
            Object object;
            Object object2 = null;
            int n = 0;
            while (n < this.pointVect.size()) {
                object = (PointData)this.pointVect.elementAt(n);
                if (((PointData)object).getSelected()) {
                    object2 = object;
                    break;
                }
                ++n;
            }
            if (object2 == null) {
                return;
            }
            object = ((PointData)object2).getPoint();
            if (object == null) {
                return;
            }
            if (this.bpaintmode == 0) {
                if (this.parentSp == null) {
                    return;
                }
                Dimension dimension = this.parentSp.getViewportSize();
                Point point = this.sptr.mapToCanvasWithClip((DPos)object);
                if (point == null) {
                    return;
                }
                this.parentSp.setScrollPosition(point.x - dimension.width / 2, point.y - dimension.height / 2);
            } else if (this.bpaintmode == 1 || this.bpaintmode == 2 || this.bpaintmode == 3) {
                int n2 = 10;
                double d = this.sptr.getRa();
                double d2 = this.sptr.getDe();
                double d3 = ((DPos)object).getRa();
                double d4 = ((DPos)object).getDe();
                double d5 = (d4 - d2) / (double)n2;
                double d6 = d3 - d;
                if (Math.abs(d6) > Math.PI) {
                    d6 = d6 > 0.0 ? -1.0 * (Math.PI * 2 - Math.abs(d6)) : Math.PI * 2 - Math.abs(d6);
                }
                d6 /= (double)n2;
                this.vptvect.removeAllElements();
                int[] nArray = new int[]{4, 7, 9};
                int n3 = 0;
                while (n3 < nArray.length) {
                    double d7 = d2 + d5 * (double)nArray[n3];
                    double d8 = d + d6 * (double)nArray[n3];
                    if (d8 > Math.PI * 2) {
                        d8 -= Math.PI * 2;
                    } else if (d8 < 0.0) {
                        d8 += Math.PI * 2;
                    }
                    Point point = new Point((int)(d8 * 1000.0), (int)(d7 * 1000.0));
                    this.vptvect.addElement(point);
                    ++n3;
                }
                this.vptvect.addElement(new Point((int)(d3 * 1000.0), (int)(d4 * 1000.0)));
            }
        }
    }

    public void removeAllPoints() {
        this.pointVect.removeAllElements();
    }

    public void readTData() {
        KFileAnalyzer.readPTData(this.starVect, this);
        KFileAnalyzer.readCstData(this.cstVect, this);
    }

    private void setGrid() {
        int n = -90;
        while (n <= 90) {
            int n2 = 0;
            while (n2 <= 330) {
                String string = "";
                if (n2 != 0 || n == 0) {
                    string = String.valueOf(Integer.toString(n2 / 15)) + "hr";
                }
                if (n != 0) {
                    string = n >= 0 ? String.valueOf(string) + "+" : String.valueOf(string) + "-";
                    string = String.valueOf(string) + Integer.toString(n) + "deg";
                }
                StarData starData = new StarData(n2, n, string);
                this.gridVect.addElement(starData);
                n2 += 30;
            }
            n += 30;
        }
    }

    private void autoAngleAdjust() {
        if (!this.autoAngleFlag) {
            return;
        }
        ResultData resultData = this.boss.getSelectedData();
        if (resultData == null) {
            return;
        }
        if (resultData.getFinishedFlag()) {
            return;
        }
        double d = resultData.getProgValue();
        int n = (int)(90.0 * d) + 60;
        this.setVangle(n);
    }

    void GraphPanel_MouseClicked(MouseEvent mouseEvent) {
        PointData pointData;
        this.boss.resetSleepThread();
        int n = 12;
        Point point = mouseEvent.getPoint();
        Rectangle rectangle = new Rectangle(point.x - n, point.y - n, n * 2, n * 2);
        Vector<PointData> vector = new Vector<PointData>();
        int n2 = 0;
        while (n2 < this.pointVect.size()) {
            pointData = (PointData)this.pointVect.elementAt(n2);
            Point point2 = this.sptr.mapToCanvasWithClip(pointData.getPoint());
            if (point2 != null && rectangle.contains(point2.x, point2.y)) {
                vector.addElement(pointData);
            }
            ++n2;
        }
        pointData = null;
        if (vector.size() == 1) {
            pointData = (PointData)vector.elementAt(0);
        } else {
            int n3 = n * 2 * (n * 2);
            int n4 = 0;
            while (n4 < vector.size()) {
                PointData pointData2 = (PointData)vector.elementAt(n4);
                if (!pointData2.getSelected()) {
                    Point point3 = this.sptr.mapToCanvasWithClip(pointData2.getPoint());
                    int n5 = point.x - point3.x;
                    int n6 = point.y - point3.y;
                    int n7 = n5 * n5 + n6 * n6;
                    if (n7 < n3) {
                        n3 = n7;
                        pointData = pointData2;
                    }
                }
                ++n4;
            }
        }
        if (pointData != null) {
            this.boss.selectData(pointData.getOrgData());
        }
    }

    void SkyCanvas_MousePressed(MouseEvent mouseEvent) {
        this.morigin = mouseEvent.getPoint();
        this.originra = this.sptr.getRa();
        this.originde = this.sptr.getDe();
        this.mouseDownFlag = true;
        this.boss.resetSleepThread();
    }

    void SkyCanvas_MouseReleased(MouseEvent mouseEvent) {
        this.mouseDownFlag = false;
    }

    void SkyCanvas_MouseDragged(MouseEvent mouseEvent) {
        if (this.bpaintmode != 1 && this.bpaintmode != 2 && this.bpaintmode != 3) {
            return;
        }
        Point point = mouseEvent.getPoint();
        Dimension dimension = this.getSkyMapSize();
        int n = this.morigin.x - point.x;
        int n2 = this.morigin.y - point.y;
        double d = this.sptr.getVangle() / (double)Math.max(dimension.width / 2, dimension.height);
        double d2 = this.originra - (double)n * d;
        double d3 = this.originde - (double)n2 * d;
        if (d2 > Math.PI * 2) {
            d2 -= Math.PI * 2;
        }
        if (d2 < 0.0) {
            d2 = Math.PI * 2 + d2;
        }
        if (d3 < -1.5707963267948966) {
            d3 = -1.5707963267948966;
        }
        if (d3 > 1.5707963267948966) {
            d3 = 1.5707963267948966;
        }
        this.sptr.setVra(d2);
        this.sptr.setVde(d3);
        this.repaint();
    }

    class SymMouse
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == SkyCanvas.this) {
                SkyCanvas.this.SkyCanvas_MousePressed(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == SkyCanvas.this) {
                SkyCanvas.this.SkyCanvas_MouseReleased(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == SkyCanvas.this) {
                SkyCanvas.this.GraphPanel_MouseClicked(mouseEvent);
            }
        }

        SymMouse() {
        }
    }

    class SymMouseMotion
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object == SkyCanvas.this) {
                SkyCanvas.this.SkyCanvas_MouseDragged(mouseEvent);
            }
        }

        SymMouseMotion() {
        }
    }
}

