#!/bin/sh
# This is a Tcl/Tk script to be interpreted by wish (Tk8.2 or better): \
exec wish8.3 "$0" "$@"

#
#  gpsman --- GPS Manager: a manager for GPS receiver data
#
#  Copyright (c) 2002 Miguel Filgueiras (mig@ncc.up.pt) / Universidade do Porto
#
#    This program is free software; you can redistribute it and/or modify
#      it under the terms of the GNU General Public License as published by
#      the Free Software Foundation; either version 2 of the License, or
#      (at your option) any later version.
#
#      This program is distributed in the hope that it will be useful,
#      but WITHOUT ANY WARRANTY; without even the implied warranty of
#      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#      GNU General Public License for more details.
#
#      You should have received a copy of the GNU General Public License
#      along with this program.
#
## Incorporates contributions by
#  - Brian Baulch (baulchb@onthenet.com.au)
#      Copyright (c) 1999-2000 by Brian Baulch
#      that allow for the support of Lowrance receivers
#  - Alessandro Palmas (alpalmas@tin.it)
#      Copyright (c) 2001 by Alessandro Palmas
#      that implement elevation graph for tracks and routes
##
#
## German language support by Andreas Lange (andreas.lange@rhein-main.de)
#      Copyright (c) 2002 by Andreas Lange
##
#
## Italian language support by Alessandro Palmas (alpalmas@tin.it)
#      Copyright (c) 2002 by Alessandro Palmas
##
#
## French language support by Valere Robin (valere.robin@wanadoo.fr)
#      Copyright (c) 2002 by Valere Robin
##
#
## Dutch language support by Rob Buitenhuis (rob@buitenhs.demon.nl)
#      Copyright (c) 2002 by Rob Buitenhuis
##
#
## Includes a translation of a Perl script by Niki Hammler
#      (http://www.nobaq.net)
#      that converts exported FUGAWI data to DDD GPSman data
##
#
## Some algorithms, formulae and geodetic information taken or adopted from
#  gpstrans - a program to communicate with garmin gps
#      containing parts taken from John F. Waers (jfwaers@csn.net)
#      program MacGPS.
#        Copyright (c) 1995 by Carsten Tschach (tschach@zedat.fu-berlin.de)
#      Uniform Finish grid support:
#        Copyright (c) 1996 Janne Sinkkonen (janne@iki.fi) 
#      Swedish grid support:
#        Copyright (c) 1999 by Anders Lennartsson
#        (anders.lennartsson@sto.foa.se)
#  INVERSE, FORWARD, INVERS3D, FORWRD3D - programs to compute distances and
#      azimuths between two points.
#      Available from ftp://www.ngs.noaa.gov/pub/pcsoft/for_inv.3d/
#  PROJ4.0 - cartographic projection software
#      by Gerald I. Evenden (gie@kai.er.usgs.gov)
#  International Institute for Aerospace Survey and Earth Sciences (ITC),
#      Enschede, http://kartoweb.itc.nl/geometrics
#  Guidance Note Number 7, European Petroleum Survey Group
#      Revised November 1999
#  Kenneth Foote pages, Department of Geography, The University of
#    Colorado at Boulder
#    http://www.colorado.edu/geography/gcraft/notes/datum/edlist.html
#  geotrans - an open source coordinate transformation tool from the
#    USA National Imagery and Mapping Agency (NIMA)
#    http://www.remotesensing.org
#  Computation of area of spherical polygon adapted from sph_poly.c in
#   "Graphics Gems IV", edited by Paul Heckbert, Academic Press, 1994.
#  Formula for ellipsoid radius from
#   "Ellipsoidal Area Computations of Large Terrestrial Objects"
#   by Hrvoje Lukatela
#   http://www.geodyssey.com/papers/ggelare.html
#
# look for this notice in the corresponding files
##
#
## Some formulae and geodetic information kindly provided by
#      Luisa Bastos, Universidade do Porto
#      Gil Goncalves, Universidade de Coimbra
#      Jose Alberto Goncalves, Universidade do Porto
#      Sergio Cunha, Universidade do Porto
#      Peter H. Dana, University of Texas
##
#
## Correction of bugs in the conversion of UTM/UPS coordinates provided by
#      Peter H. Dana, University of Texas
##
#
#  File: gpsman.tcl
#  Last change:  1 February 2002
#

############ configuration parameters
#
# the first 4 variables below MUST be correctly set for GPSMan to work!
#  SERIALPORT, SRCDIR, USERDIR, USEROPTIONS

 # NOTE for non-Unix users: use "/" (not "\") in pathnames

 # path to serial port; make sure all users have read/write permission

switch $tcl_platform(platform) {
    unix {
	# on Unix systems the path may be passed as an argument
	set SERIALPORT [lindex $argv 0]
	# otherwise the default is
	set DEFSPORT /dev/cuaa0
	# path to directory containing user data
	set USERDIR ~/.gpsman-dir
	# name of user preferences file
	set USEROPTIONS gpsman-options
    }
    default {
	# on Apple Macintoshes the serial port cannot be used under Tcl/Tk
	# on MS-Windows it could be as follows
	set SERIALPORT com2:
	# path to directory containing user data
	set USERDIR gpmandir
	# name of user preferences file
	set USEROPTIONS gpmanopt
    }
}

 # path to directory containing program files
set SRCDIR %%PREFIX%%/share/gpsman/gmsrc

## the following values can be set from the options dialog of the interface

 # language: see lang*.tcl files, ALLMONTH array below, main.tcl KNOWNLANGS
    # currently available: engl for English, port for Portuguese, deutsch for
    #   German, it for Italian, fr for French, nl for Dutch

set LANG engl

 # ISO latin1 character composition (accents, cedilla, ...)
set ISOLATIN1 1

 # Delete-key to delete last character
set DELETE 1

 # Configuration of main window in {map, lists} ("single" no longer supported)
set MWINDOWSCONF map

 # GPS receiver trade mark and model (if applicable): give trade mark
 #   (one of: Garmin, Lowrance) followed by model name.
 #   See file recmodels.tcl for list of known models

set GPSREC "Garmin"

 # GPS receiver dependent values (set to Garmin GPS II)

set NAMELENGTH 6
set COMMENTLENGTH 16
set MAXWPOINTS 250
set MAXROUTES 20
set MAXWPINROUTE 30
set MAXTPOINTS 768
set CREATIONDATE 0
set NOLOWERCASE 1

    # sampling interval for Lowrance receivers in seconds
set INTERVAL 3

   # default symbol name (GPSMan convention; see symbols.tcl)
set DEFAULTSYMBOL WP_dot
    #  and symbol display options (GPSMan convention; see symbols.tcl)
set DEFAULTDISPOPT s_name

  # count to show number of track point on map; 0 means no numbers shown
set TRNUMBERINTVL 10

 # data items with same name will be overwritten (ovwrt) or created under
 #  new name (rename):
set EQNAMEDATA ovwrt

 # keep hidden data (not available for editing) when changing item;
 #  one of: never, ask (at every change), always
set KEEPHIDDEN never

 # default values

         # possible distance units: KM NAUTMILE STATMILE
set DISTUNIT KM

         # possible position formats: DMS (hdeg, min, sec), DMM (hdeg, min),
         #                            DDD (hdeg), UTM/UPS (ze, zn, e, n),
         #                            MH (Maidenhead locator, 6 characters)
         #                            BNG (British grid: zone, e, n),
         #                            CMP (Portuguese military grid: e, n),
         #                            GKK (German grid: zone, e, n),
         #                            ITM (Irish grid: zone, e, n)
         #                            SEG (Swedish grid: e, n)
         #  and maybe other grids (see projections.tcl)
set PositionFormat DMS
set Datum "WGS 84"
         # difference in hours to UTC (must be an integer)
set TimeOffset 1

         # possible date formats: YYYYMMDD  (1998.03.20 09:35:23),
         #                        YYYY-MM-DD  (1998-03-20 09:35:23),
         #                        MMDDYYYY  (03/20/1998 09:35:23),
         #                        DDMMMYYYY (20-Mar-1998 09:35:23)
set DateFormat DDMMMYYYY

  # formulae: either more accurate or faster
set ACCFORMULAE 0

  # ask for confirmation of projection parameters
set ASKPROJPARAMS 1

  # provide balloons with help
set BalloonHelp 1

 # geometry

  # map dimensions in pixels
set MAPWIDTH 800 ; set MAPHEIGHT 550
         # length of scale arrow (pixels)
set MAPSCLENGTH 300
         # initial map scale: 1, 2, 4, 8, ... 512*$DISTUNIT/$MAPSCLENGTH pixel
         #  or, if $DISTUNIT==km: 50, 100, 200, 500 m/$MAPSCLENGTH pixel
         #      else: 150, 300, 600, 2400 ft/$MAPSCLENGTH pixel
         # actual distance and unit (from the values above) for the scale arrow
set MAPSCALE "4 km"

  # menus
set MAXMENUITEMS 20

  # dimensions of lists
set LISTWIDTH 9
set LISTHEIGHT 22

  # initial positions
     # lists window
set LPOSX 40 ; set LPOSY 25
     # map window
set MPOSX 5 ; set MPOSY 40
     # receiver window
set RPOSX 10 ; set RPOSY 250
     # errors, messages, warnings
set EPOSX 340 ; set EPOSY 50
     # dialogs
set DPOSX 290 ; set DPOSY 50
     # offset for dialog for making route on map
set DPOSRTMAP -200

  # colours
       # general fore/background
set COLOUR(fg) "#090980"
set COLOUR(bg) "#f7f7e0"
       # error background
set COLOUR(messbg) "#ff8d90"
       # confirmation background
set COLOUR(confbg) "#F0E9C0"
       # selection background
set COLOUR(selbg) "#F0E9C0"
       # input dialog background
set COLOUR(dialbg) gray
       # receiver offline
set COLOUR(offline) "#d83232"
       # receiver online
set COLOUR(online) green
       # selected checkbutton
set COLOUR(check) red
       # balloon help
set COLOUR(ballbg) #fef6e1
set COLOUR(ballfg) #8d7f56

  # colours on map
       # selected map item
set MAPCOLOUR(mapsel) red
       # wayponts on map
set MAPCOLOUR(WP) "#ff6400"
       # routes on map
set MAPCOLOUR(RT) "#48C1BC"
       # route being defined on map
set MAPCOLOUR(mkRT) "#469e36"
       # tracks on map
set MAPCOLOUR(TR) "#EF9A00"
       # track points on map
set MAPCOLOUR(TP) "#CD69C9"
       # map legends
set MAPCOLOUR(mapleg) "#8B0000"
       # lines in map animation
set MAPCOLOUR(anim) darkblue
       # slots in map image grid
set MAPCOLOUR(emptygrid) white
set MAPCOLOUR(selemptygrid) "#ffe080"
set MAPCOLOUR(fullgrid) "#00d8d8"
set MAPCOLOUR(selfullgrid) "#ffd8d8"

 # save state on exit, one of: never, ask (when quitting), always
set SAVESTATE ask
 # delete state files after restoring, one of: never, ask, always
set DELSTATE ask

 # permissions of created files
set PERMS 0640

 # default paper size (one of those whose dimensions are given below)

set PAPERSIZE a4

### the following values can be configured if needs be

  # paper size without margins

set PAGEWIDTH(a4) 184m ; set PAGEHEIGHT(a4) 271m
set PAGEWIDTH(a3) 258m ; set PAGEHEIGHT(a3) 379m
set PAGEWIDTH(a5) 134m ; set PAGEHEIGHT(a5) 195m
set PAGEWIDTH(b4) 250m ; set PAGEHEIGHT(b4) 353m
set PAGEWIDTH(b5) 176m ; set PAGEHEIGHT(b5) 250m

  # possible abbreviations for months in all known languages
  # English abbreviations must not be deleted
set ALLMONTH(1) "Jan Gen jan"
set ALLMONTH(2) "Feb Fev feb"
set ALLMONTH(3) "Mar Mr mrt"
set ALLMONTH(4) "Apr Abr Avr apr"
set ALLMONTH(5) "May Mai Mag mei"
set ALLMONTH(6) "Jun Giu jun"
set ALLMONTH(7) "Jul Lug jul"
set ALLMONTH(8) "Aug Ago Aou aug"
set ALLMONTH(9) "Sep Set sep"
set ALLMONTH(10) "Oct Okt Out Ott okt"
set ALLMONTH(11) "Nov nov"
set ALLMONTH(12) "Dec Dez Dic dec"

###### NO CONFIGURABLE VALUES AFTER THIS LINE ##############################

set InitDir 0 ; set InitOpts 0

if { ! [file exists $USERDIR] } {
    set InitDir 1
    if { [file readable ~/.gpsman] } {
	# pre-5.4 default options file
	source ~/.gpsman
    }
}

if { [file readable $USEROPTIONS] } {
    source $USEROPTIONS
    set USEROPTIONS [file join [pwd] $USEROPTIONS]
} else {
    set USEROPTIONS [file join $USERDIR $USEROPTIONS]
    if { [file readable $USEROPTIONS] } {
	source $USEROPTIONS
    } else {
	set InitOpts 1
	set ISOLATIN1 0
    }
}

# source files read before initialization of preferences file
set SRCFILESBEGIN "lang$LANG symbols gendials util check \
           datumell geod compute posncomp projections recmodels options"

# this file may cause problems in non-western Linux installations
if { $ISOLATIN1 } { lappend SRCFILESBEGIN isolatin1 }

# source files setting receiver parameters
set SRCFILESREC "recdefs"

# source files depending on receiver brand
set SRCFILESFOR(Garmin) "garmin_protocols garmin_symbols garmin_nmea garmin"
set SRCFILESFOR(Lowrance) "lowrance_symbols lowrance_nmea lowrance"

# conditional source files
set SRCFILESCOND [list "ACCFORMULAE acccomp"]
# other generic source files
set SRCFILESEND "wrtdials search lists files gpsinfo \
	maptransf map mapanim realtime know trtort gdata cluster"

source [file join $SRCDIR main.tcl]

GMStart
GMInit

