/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import xnap.gui.util.GUIHelper;
import xnap.util.Preferences;

public class ChatPane
extends JScrollPane
implements PropertyChangeListener {
    protected static Preferences prefs = Preferences.getInstance();
    protected static StyleContext styles = new StyleContext();
    private JTextPane jtp = new JTextPane();

    public static Style getStyle(String string) {
        return styles.getStyle(string);
    }

    public static void setStyle(String string, Color color, Font font) {
        Style style = styles.getStyle("default");
        Style style2 = styles.addStyle(string, style);
        StyleConstants.setForeground(style2, color);
        StyleConstants.setFontFamily(style2, font.getName());
        StyleConstants.setFontSize(style2, font.getSize());
        StyleConstants.setItalic(style2, font.isItalic());
        StyleConstants.setBold(style2, font.isBold());
    }

    public static void updateStyles() {
        Font font = GUIHelper.getFont("chat");
        ChatPane.setStyle("chatMessage", GUIHelper.getColor("chatMessage"), font);
        ChatPane.setStyle("chatUser", GUIHelper.getColor("chatUser"), font);
        ChatPane.setStyle("chatInfo", GUIHelper.getColor("chatInfo"), font);
        ChatPane.setStyle("chatError", GUIHelper.getColor("chatError"), font);
    }

    public void appendLater(String string, String string2) {
        Runnable runnable = new Runnable(this, string, string2){
            private final /* synthetic */ ChatPane this$0;
            private final /* synthetic */ String val$text;
            private final /* synthetic */ String val$style;

            public final void run() {
                this.this$0.append(this.val$text, this.val$style);
            }
            {
                this.val$text = string;
                this.val$style = string2;
                this.this$0 = chatPane;
                this.constructor$0(chatPane);
            }

            private final void constructor$0(ChatPane chatPane) {
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void appendLater(String string) {
        this.appendLater(string, "default");
    }

    public void append(String string, String string2) {
        Document document = this.jtp.getDocument();
        try {
            document.insertString(document.getLength(), string, ChatPane.getStyle(string2));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        int n = jScrollBar.getMaximum();
        int n2 = jScrollBar.getModel().getExtent();
        jScrollBar.setValue(n - n2);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.jtp.setBackground(GUIHelper.getColor("chatBackground"));
    }

    public void setText(String string) {
        this.jtp.setText(string);
    }

    public ChatPane() {
        this.jtp.setBackground(GUIHelper.getColor("chatBackground"));
        this.jtp.setEditable(false);
        this.jtp.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setVerticalScrollBarPolicy(20);
        this.setHorizontalScrollBarPolicy(30);
        this.setViewportView(this.jtp);
        prefs.addColorListener("chatBackground", this);
    }

    static {
        ChatPane.updateStyles();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ChatPane.updateStyles();
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
        prefs.addFontListener("chat", propertyChangeListener);
        prefs.addColorListener("chatMessage", propertyChangeListener);
        prefs.addColorListener("chatUser", propertyChangeListener);
        prefs.addColorListener("chatInfo", propertyChangeListener);
        prefs.addColorListener("chatError", propertyChangeListener);
    }
}

