/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import xnap.XNap;
import xnap.gui.ConsoleDialog;
import xnap.gui.GridBagHelper;
import xnap.gui.MultiLineLabel;
import xnap.util.Debug;
import xnap.util.Formatter;
import xnap.util.Preferences;

public class FeedbackDialog
extends JDialog {
    private static FeedbackDialog me = null;
    private static Preferences prefs = Preferences.getInstance();
    private JTextArea jtaInfo;
    private JTextField jtName;
    private JTextField jtEmail;
    private JTextField jtSubject;
    private JTextArea jtaText;
    private JCheckBox jcbIncErrorLog;
    private SendAction acSend = new SendAction();
    private CancelAction acCancel = new CancelAction();

    public static String getSystemInfo() {
        Properties properties = System.getProperties();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("XNap ");
        stringBuffer.append("2.4-pre5");
        stringBuffer.append(" (");
        stringBuffer.append(Locale.getDefault());
        stringBuffer.append(")\nOS : ");
        stringBuffer.append(((Hashtable)properties).get("os.name"));
        stringBuffer.append(" ");
        stringBuffer.append(((Hashtable)properties).get("os.version"));
        stringBuffer.append(" (");
        stringBuffer.append(((Hashtable)properties).get("os.arch"));
        stringBuffer.append(")\nJRE: ");
        stringBuffer.append(((Hashtable)properties).get("java.vendor"));
        stringBuffer.append(" ");
        stringBuffer.append(((Hashtable)properties).get("java.version"));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public static void showDialog(Component component) {
        if (me == null) {
            me = new FeedbackDialog();
            if (component != null) {
                me.setLocationRelativeTo(component);
            }
        }
        me.show();
    }

    static /* synthetic */ FeedbackDialog access$2() {
        return me;
    }

    private FeedbackDialog() {
        String string = new String(XNap.tr("Feedback is very important to us. Please take a minute and send criticism, questions or everything else you think is important. Please don't forget to include your name and email address if you would like to get a reply! We understand English, German and some French.") + "\n" + "(" + XNap.tr("Note, if you have a bug report or feature request, please consider using the tracker facilities at SourceForge (http://sourceforge.net/projects/xnap/) instead!") + ")");
        this.jtaInfo = new MultiLineLabel(string);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagHelper.addLabel(jPanel, XNap.tr("Subject"));
        this.jtSubject = new JTextField(20);
        GridBagHelper.add((Container)jPanel, this.jtSubject);
        GridBagHelper.addLabel(jPanel, XNap.tr("Feedback"));
        this.jtaText = new JTextArea(FeedbackDialog.getSystemInfo(), 12, 40);
        this.jtaText.setLineWrap(true);
        this.jtaText.setWrapStyleWord(true);
        this.jtaText.setEditable(true);
        this.jtaText.setBorder(new EmptyBorder(5, 5, 5, 5));
        JScrollPane jScrollPane = new JScrollPane(this.jtaText);
        GridBagHelper.addPanel(jPanel, jScrollPane);
        GridBagHelper.addLabel(jPanel, XNap.tr("Your Name"));
        this.jtName = new JTextField(20);
        GridBagHelper.add((Container)jPanel, this.jtName);
        GridBagHelper.addLabel(jPanel, XNap.tr("Your Email"));
        this.jtEmail = new JTextField(20);
        GridBagHelper.add((Container)jPanel, this.jtEmail);
        GridBagHelper.addLabel(jPanel, "");
        String string2 = XNap.tr("Include error.log") + " (" + Formatter.formatSize(Debug.getErrorFileSize()) + ")";
        this.jcbIncErrorLog = new JCheckBox(string2, Debug.getErrorFileSize() > 0L);
        GridBagHelper.add((Container)jPanel, this.jcbIncErrorLog);
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        jPanel2.add(new JButton(new ErrorLogAction()));
        jPanel2.add(new JButton(this.acSend));
        jPanel2.add(new JButton(this.acCancel));
        this.setTitle(XNap.tr("Feedback"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new CloseListener());
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagHelper.add(this.getContentPane(), this.jtaInfo);
        GridBagHelper.addPanel(this.getContentPane(), jPanel);
        GridBagHelper.add(this.getContentPane(), jPanel2);
        if (prefs.getRememberFeedback()) {
            this.jtEmail.setText(prefs.getFeedbackEmail());
            this.jtName.setText(prefs.getFeedbackName());
        }
        this.pack();
        this.jtSubject.grabFocus();
    }

    private class ErrorLogAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            ConsoleDialog.showDialog(FeedbackDialog.this, true);
        }

        public ErrorLogAction() {
            this.putValue("Name", XNap.tr("Show error.log"));
            this.putValue("ShortDescription", XNap.tr("Opens the console dialog and shows the error.log"));
            this.putValue("MnemonicKey", new Integer(69));
        }
    }

    private class SendAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray;
            int n;
            if (FeedbackDialog.this.jtaText.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(FeedbackDialog.this, XNap.tr("Can not send empty Feedback"), XNap.tr("Send Feedback"), 0);
                return;
            }
            if (FeedbackDialog.this.jtEmail.getText().trim().length() == 0 && (n = JOptionPane.showConfirmDialog(FeedbackDialog.this, objectArray = new Object[]{XNap.tr("You did not provide an Email address. "), XNap.tr("We will not be able to answer. "), XNap.tr("Really send feedback?")}, XNap.tr("Send Feedback"), 0)) == 1) {
                return;
            }
            FeedbackDialog feedbackDialog = FeedbackDialog.this;
            if (feedbackDialog == null) {
                throw null;
            }
            objectArray = new Thread((Runnable)feedbackDialog.new SendWorker(), "SendFeedback");
            objectArray.start();
        }

        public SendAction() {
            this.putValue("Name", XNap.tr("Send"));
            this.putValue("ShortDescription", XNap.tr("Sends your feedback to the XNap team. :-)"));
            this.putValue("MnemonicKey", new Integer(83));
        }
    }

    private class CancelAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            FeedbackDialog.this.dispose();
            me = null;
        }

        public CancelAction() {
            this.putValue("Name", XNap.tr("Cancel"));
            this.putValue("ShortDescription", XNap.tr("Closes the dialog without sending feedback. :-("));
            this.putValue("MnemonicKey", new Integer(67));
        }
    }

    private class CloseListener
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            FeedbackDialog.this.dispose();
            me = null;
        }

        CloseListener() {
        }
    }

    private class SendWorker
    implements Runnable {
        public void run() {
            Object object;
            FeedbackDialog.this.acSend.setEnabled(false);
            FeedbackDialog.this.acCancel.setEnabled(false);
            FeedbackDialog.this.setTitle(XNap.tr("Sending feedback..."));
            if (prefs.getRememberFeedback()) {
                prefs.setFeedbackEmail(FeedbackDialog.this.jtEmail.getText());
                prefs.setFeedbackName(FeedbackDialog.this.jtName.getText());
            }
            String string = URLEncoder.encode(FeedbackDialog.this.jtSubject.getText().trim());
            String string2 = URLEncoder.encode(FeedbackDialog.this.jtName.getText().trim());
            String string3 = URLEncoder.encode(FeedbackDialog.this.jtEmail.getText().trim());
            String string4 = FeedbackDialog.this.jtaText.getText().trim();
            if (FeedbackDialog.this.jcbIncErrorLog.isSelected() && Debug.getErrorFile() != null && Debug.getErrorFile().length() > 0L) {
                try {
                    object = new BufferedReader(new FileReader(Debug.getErrorFile()));
                    string4 = string4 + "\n\nerror.log:\n";
                    while (((BufferedReader)object).ready()) {
                        string4 = string4 + ((BufferedReader)object).readLine() + "\n";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string4 = URLEncoder.encode(string4);
            object = new StringBuffer();
            ((StringBuffer)object).append(prefs.getFeeedbackURL());
            ((StringBuffer)object).append("?noresponse=1");
            ((StringBuffer)object).append("&from=" + string3);
            ((StringBuffer)object).append("&subject=" + string);
            ((StringBuffer)object).append("&name=" + string2);
            ((StringBuffer)object).append("&message=" + string4);
            String string5 = ((StringBuffer)object).toString();
            boolean bl = false;
            String string6 = "";
            try {
                URL uRL = new URL(string5);
                uRL.getContent();
            }
            catch (Exception exception) {
                string6 = exception.getMessage();
                bl = true;
            }
            if (bl) {
                JOptionPane.showMessageDialog(FeedbackDialog.this, XNap.tr("Could not send feedback.") + string6 + ").", XNap.tr("Feedback"), 0);
                FeedbackDialog.this.setTitle(XNap.tr("Feedback"));
            } else {
                JOptionPane.showMessageDialog(FeedbackDialog.this, XNap.tr("Thank you."), XNap.tr("Feedback"), 1);
                FeedbackDialog.this.dispose();
                me = null;
            }
            FeedbackDialog.this.acSend.setEnabled(true);
            FeedbackDialog.this.acCancel.setEnabled(true);
        }

        SendWorker() {
        }
    }
}

