/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import xnap.XNap;
import xnap.gui.AbstractPanel;
import xnap.gui.Dialogs;
import xnap.gui.EditableComboBox;
import xnap.gui.MP3FileFilter;
import xnap.gui.ViewerPanel;
import xnap.gui.XNapFrame;
import xnap.gui.action.CopyFileAction;
import xnap.gui.action.CutFileAction;
import xnap.gui.action.OpenFileWithMenu;
import xnap.gui.action.PasteFileAction;
import xnap.gui.event.DirectoryCollector;
import xnap.gui.event.DoubleClickListener;
import xnap.gui.event.DragFilesSupport;
import xnap.gui.event.EraseAction;
import xnap.gui.event.FileCollector;
import xnap.gui.event.OpenFileAction;
import xnap.gui.event.PopupListener;
import xnap.gui.table.LibraryTableModel;
import xnap.gui.tree.DroppableJTree;
import xnap.gui.tree.FileCellRenderer;
import xnap.gui.tree.FileNode;
import xnap.gui.tree.FileTreeModel;
import xnap.io.Repository;
import xnap.io.RepositoryFile;
import xnap.plugin.GUIPluginManager;
import xnap.plugin.IPlugin;
import xnap.plugin.IViewerPlugin;
import xnap.plugin.PluginManager;
import xnap.util.FileHelper;
import xnap.util.Formatter;
import xnap.util.SearchFilter;
import xnap.util.audio.AudioPlayer;
import xnap.util.audio.AudioSupport;
import xnap.util.event.StateEvent;
import xnap.util.event.StateListener;

public class LibraryPanel
extends AbstractPanel
implements PropertyChangeListener,
TreeSelectionListener,
ListSelectionListener,
DirectoryCollector,
FileCollector {
    public static final String HISTORY_FILENAME = FileHelper.getHomeDir() + "repository_search_history";
    private AudioPlayer player = null;
    private EditableComboBox jcSearch;
    private JTree jt;
    private JTable jta;
    private JFileChooser jfc = null;
    private LibraryTableModel ltm;
    private DefaultMutableTreeNode root;
    private FileTreeModel ftm;
    private DragFilesSupport dfs;
    private JSplitPane jspH;
    private JSplitPane jspV;
    private JPanel jpPreview;
    private JScrollPane jspPreview;
    private JLabel jlStatus;
    private PlayAction playAction = new PlayAction();
    private PlayFileAction playFileAction = new PlayFileAction();
    private RefreshAction refreshAction = new RefreshAction();
    private StopAction stopAction = new StopAction();
    private EnqueueAction enqueueAction = new EnqueueAction();
    private PlayFolderAction playFolderAction = new PlayFolderAction();
    private EnqueueFolderAction enqueueFolderAction = new EnqueueFolderAction();
    private OpenFileAction acOpenFile = new OpenFileAction(this);
    private ShareFolderAction shareFolderAction = new ShareFolderAction();
    private UnshareFolderAction unshareFolderAction = new UnshareFolderAction();
    private ReloadTreeAction acReloadTree = new ReloadTreeAction();
    private DeleteAction deleteAction = new DeleteAction();
    private RenameAction renameAction = new RenameAction();
    private CopyFileAction acCopyFile = new CopyFileAction(this);
    private CutFileAction acCutFile = new CutFileAction(this);
    private PasteFileAction acPasteFile = new PasteFileAction(this);
    private File currentDir;
    private int currentRow;
    private Timer delayTimer;
    private DisplayThread displayThread = new DisplayThread();

    private final void initialize() {
        Box box = new Box(0);
        QueryAction queryAction = new QueryAction();
        EraseAction eraseAction = new EraseAction();
        JButton jButton = new JButton(eraseAction);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        box.add(jButton);
        this.jcSearch = new EditableComboBox(queryAction, AbstractPanel.prefs.getSearchHistorySize());
        this.jcSearch.readHistoryFile(new File(HISTORY_FILENAME));
        box.add(this.jcSearch);
        eraseAction.setJTextField(this.jcSearch.getJTextField());
        JButton jButton2 = new JButton(queryAction);
        box.add(jButton2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new TitledBorder(XNap.tr("Library Search", 1)));
        jPanel.add((Component)box, "Center");
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem(this.playFolderAction));
        jPopupMenu.add(new JMenuItem(this.enqueueFolderAction));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(this.shareFolderAction));
        jPopupMenu.add(new JMenuItem(this.unshareFolderAction));
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.acPasteFile);
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(this.acReloadTree));
        this.ftm = new FileTreeModel(XNap.tr("Files"));
        this.jt = new DroppableJTree(this.ftm, this);
        this.jt.addTreeSelectionListener(this);
        this.jt.setCellRenderer(new FileCellRenderer());
        this.jt.putClientProperty("JTree.lineStyle", "Angled");
        PopupListener popupListener = new PopupListener(jPopupMenu);
        this.jt.addMouseListener(popupListener);
        this.jt.getSelectionModel().setSelectionMode(4);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.jt);
        JPopupMenu jPopupMenu2 = new JPopupMenu();
        jPopupMenu2.add(new JMenuItem(this.playAction));
        jPopupMenu2.add(new JMenuItem(this.enqueueAction));
        jPopupMenu2.addSeparator();
        jPopupMenu2.add(new JMenuItem(this.acOpenFile));
        jPopupMenu2.add(new OpenFileWithMenu(this));
        jPopupMenu2.addSeparator();
        jPopupMenu2.add(this.createViewerMenu());
        jPopupMenu2.addSeparator();
        jPopupMenu2.add(this.acCopyFile);
        jPopupMenu2.add(this.acCutFile);
        jPopupMenu2.add(this.acPasteFile);
        jPopupMenu2.addSeparator();
        jPopupMenu2.add(this.renameAction);
        jPopupMenu2.add(this.deleteAction);
        this.ltm = new LibraryTableModel();
        this.jta = this.ltm.createJTable();
        this.dfs = new DragFilesSupport(this.jta, this);
        this.jta.getSelectionModel().addListSelectionListener(this);
        this.jta.setShowGrid(false);
        PopupListener popupListener2 = new PopupListener(jPopupMenu2);
        this.jta.addMouseListener(popupListener2);
        this.jta.addMouseListener(new DoubleClickListener(this.acOpenFile, this.jta));
        ActionListener actionListener = this.jta.getActionForKeyStroke(KeyStroke.getKeyStroke(40, 0));
        this.jta.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(78, 2), 0);
        actionListener = this.jta.getActionForKeyStroke(KeyStroke.getKeyStroke(38, 0));
        this.jta.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(80, 2), 0);
        actionListener = this.jta.getActionForKeyStroke(KeyStroke.getKeyStroke(34, 0));
        this.jta.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(86, 2), 0);
        actionListener = this.jta.getActionForKeyStroke(KeyStroke.getKeyStroke(33, 0));
        this.jta.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(86, 8), 0);
        actionListener = this.jta.getActionForKeyStroke(KeyStroke.getKeyStroke(36, 2));
        this.jta.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(153, 8), 0);
        actionListener = this.jta.getActionForKeyStroke(KeyStroke.getKeyStroke(35, 2));
        this.jta.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(153, 9), 0);
        this.jta.getInputMap().put(KeyStroke.getKeyStroke(10, 0), this.acOpenFile);
        this.jta.getActionMap().put(this.acOpenFile, this.acOpenFile);
        this.jta.getInputMap().put(KeyStroke.getKeyStroke(116, 0), this.refreshAction);
        this.jta.getActionMap().put(this.refreshAction, this.refreshAction);
        this.jta.getInputMap().put(KeyStroke.getKeyStroke(127, 0), this.deleteAction);
        this.jta.getActionMap().put(this.deleteAction, this.deleteAction);
        this.jta.getInputMap().put(KeyStroke.getKeyStroke(113, 0), this.renameAction);
        this.jta.getActionMap().put(this.renameAction, this.renameAction);
        this.jta.getInputMap().put(KeyStroke.getKeyStroke(81, 0), this.enqueueAction);
        this.jta.getActionMap().put(this.enqueueAction, this.enqueueAction);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setViewportView(this.jta);
        this.delayTimer = new Timer(500, new SelectionListener());
        this.delayTimer.setRepeats(false);
        this.jpPreview = new JPanel(new BorderLayout());
        this.jpPreview.setBackground(Color.gray);
        this.jspPreview = new JScrollPane(this.jpPreview);
        actionListener = this.jspPreview.getActionForKeyStroke(KeyStroke.getKeyStroke(34, 0));
        this.jspPreview.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(32, 2), 2);
        actionListener = this.jspPreview.getActionForKeyStroke(KeyStroke.getKeyStroke(33, 0));
        this.jspPreview.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(32, 3), 2);
        this.jspV = new JSplitPane(0);
        this.jspV.add((Component)jScrollPane2, "top");
        this.jspV.add((Component)this.jspPreview, "bottom");
        this.jspV.setDividerLocation(AbstractPanel.prefs.getLibraryVerticalDividerLocation());
        this.jspV.setOneTouchExpandable(true);
        this.jlStatus = new JLabel(" ");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.jspV, "Center");
        jPanel2.add((Component)this.jlStatus, "South");
        this.jspH = new JSplitPane(1);
        this.jspH.add((Component)jScrollPane, "left");
        this.jspH.add((Component)jPanel2, "right");
        this.jspH.setDividerLocation(AbstractPanel.prefs.getLibraryHorizontalDividerLocation());
        this.jspH.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)this.jspH, "Center");
        this.updateAudioPlayer();
        this.updateTree();
        AbstractPanel.prefs.addPropertyChangeListener(this);
    }

    public JFileChooser getFileChooser() {
        if (this.jfc == null) {
            this.jfc = new JFileChooser();
            MP3FileFilter mP3FileFilter = new MP3FileFilter();
            this.jfc.setFileFilter(mP3FileFilter);
        }
        return this.jfc;
    }

    public JMenu getTableMenu() {
        return this.ltm.createJMenu();
    }

    public void hasChanged(File file) {
        if (this.currentDir != null) {
            this.showDirectory(this.currentDir);
        }
    }

    public void purgeHistory() {
        this.jcSearch.removeAllItems();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getSource() == AbstractPanel.prefs) {
            if (string.equals("incompleteDir")) {
                this.ftm.removeChildrenOfSubRoot(XNap.tr("Incomplete Files"));
                this.ftm.addChildOfSubRoot(new File(AbstractPanel.prefs.getIncompleteDir()), XNap.tr("Incomplete Files"));
            } else if (string.equals("uploadDirs")) {
                this.ftm.removeChildrenOfSubRoot(XNap.tr("Shared Files"));
                String[] stringArray = AbstractPanel.prefs.getUploadDirsArray();
                int n = 0;
                while (n < stringArray.length) {
                    this.ftm.addChildOfSubRoot(new File(stringArray[n]), XNap.tr("Shared Files"));
                    ++n;
                }
            } else if (string.equals("mp3PlayerCmd") || string.equals("mp3PlayerType")) {
                this.updateAudioPlayer();
            } else if (string.equals("downloadDir") || string.indexOf("DownloadDir") != -1) {
                this.ftm.removeChildrenOfSubRoot(XNap.tr("Downloaded Files"));
                this.addDownloadDirs();
            }
        }
    }

    public void savePrefs() {
        AbstractPanel.prefs.setLibraryHorizontalDividerLocation(this.jspH.getDividerLocation());
        AbstractPanel.prefs.setLibraryVerticalDividerLocation(this.jspV.getDividerLocation());
        this.jcSearch.setHistorySize(AbstractPanel.prefs.getSearchHistorySize());
        this.jcSearch.writeHistoryFile(new File(HISTORY_FILENAME));
    }

    private final void updateAudioPlayer() {
        this.player = AudioSupport.getInstance(AbstractPanel.prefs.getMP3PlayerType(), AbstractPanel.prefs.getMP3PlayerCmd());
    }

    private final void updateTree() {
        this.ftm.removeSubRoots();
        int n = 0;
        String[] stringArray = AbstractPanel.prefs.getLibraryTreeNodesArray();
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3;
            Object[] objectArray;
            if (stringArray[n2].equals("shares")) {
                this.ftm.addSubRoot(XNap.tr("Shared Files"));
                objectArray = AbstractPanel.prefs.getUploadDirsArray();
                n3 = 0;
                while (n3 < objectArray.length) {
                    this.ftm.addChildOfSubRoot(new File(objectArray[n3]), XNap.tr("Shared Files"));
                    ++n3;
                }
                this.jt.expandRow(this.jt.getRowCount() - 1);
            } else if (stringArray[n2].equals("incompletes")) {
                this.ftm.addChildOfSubRoot(new File(AbstractPanel.prefs.getIncompleteDir()), XNap.tr("Incomplete Files"));
                this.jt.expandRow(this.jt.getRowCount() - 1);
            } else if (stringArray[n2].equals("downloads")) {
                this.addDownloadDirs();
                this.jt.expandRow(this.jt.getRowCount() - 1);
            } else if (stringArray[n2].equals("home")) {
                this.ftm.addChildOfSubRoot(new File(System.getProperty("user.home")), XNap.tr("Home Directory"));
                this.jt.expandRow(this.jt.getRowCount() - 1);
            } else if (stringArray[n2].equals("root")) {
                objectArray = File.listRoots();
                n3 = 0;
                while (n3 < objectArray.length) {
                    this.ftm.addChildOfSubRoot((File)objectArray[n3], XNap.tr("Root Directory"));
                    ++n3;
                }
                this.jt.expandRow(this.jt.getRowCount() - 1);
            } else {
                ++n;
            }
            ++n2;
        }
        if (n == stringArray.length) {
            this.ftm.addSubRoot(XNap.tr("Root Directory"));
            File[] fileArray = File.listRoots();
            int n4 = 0;
            while (n4 < fileArray.length) {
                this.ftm.addChildOfSubRoot(fileArray[n4], XNap.tr("Root Directory"));
                ++n4;
            }
            this.jt.expandRow(this.jt.getRowCount() - 1);
        }
    }

    private final void addDownloadDirs() {
        this.ftm.addChildOfSubRoot(new File(AbstractPanel.prefs.getDownloadDir()), XNap.tr("Downloaded Files"));
        int n = 0;
        while (n < SearchFilter.media.length) {
            String string = (String)SearchFilter.media[n];
            String string2 = AbstractPanel.prefs.getMediaTypeDownloadDir(string);
            if (n != 0 && string2.length() > 0) {
                this.ftm.addChildOfSubRoot(new File(string2), XNap.tr("Downloaded Files"), " (" + string + ")");
            }
            ++n;
        }
    }

    private final void showDirectory(File file) {
        this.currentDir = file;
        this.ltm.clear();
        if (file.canRead()) {
            this.ltm.add(file);
            this.ltm.resort();
        }
        this.resetPanel();
    }

    private final void showFiles(File[] fileArray) {
        this.ltm.clear();
        this.ltm.add(fileArray);
        this.ltm.resort();
        this.resetPanel();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = treeSelectionEvent.getPath().getLastPathComponent();
        if (object instanceof File) {
            File file = (File)object;
            this.showDirectory(file);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.jta.getSelectedRowCount() > 1) {
            this.resetPanel();
            return;
        }
        int n = this.jta.getSelectedRow();
        if (n != -1) {
            this.currentRow = n;
            this.delayTimer.restart();
        }
    }

    public AbstractAction[] getActions() {
        return new AbstractAction[]{this.playFileAction, this.enqueueAction, this.playAction, this.stopAction, null, this.refreshAction, null, this.shareFolderAction, this.unshareFolderAction};
    }

    private final void playFile(File file) {
        if (this.player != null) {
            new Thread(this, file, "PlayFile " + file){
                private final /* synthetic */ LibraryPanel this$0;
                private final /* synthetic */ File val$f;

                public final void run() {
                    boolean bl = this.val$f == null ? LibraryPanel.access$0(this.this$0).play() : LibraryPanel.access$0(this.this$0).play(this.val$f);
                    if (!bl) {
                        if (this.val$f == null) {
                            this.this$0.setStatus(XNap.tr("Could not start player"));
                        } else {
                            this.this$0.setStatus(XNap.tr("Could not play file", 0, 1) + this.val$f);
                        }
                    } else if (this.val$f != null) {
                        this.this$0.setStatus(XNap.tr("Playing", 0, 1) + this.val$f);
                    } else {
                        this.this$0.setStatus(XNap.tr("Starting player"));
                    }
                }
                {
                    this.val$f = file;
                    this.this$0 = libraryPanel;
                    this.constructor$0(libraryPanel, string);
                }

                private final void constructor$0(LibraryPanel libraryPanel, String string) {
                }
            }.start();
        } else {
            this.setStatus(XNap.tr("Could not launch player"));
        }
    }

    private final void enqueueFiles(LinkedList linkedList) {
        if (this.player != null) {
            new Thread(this, linkedList, "EnqueueFiles"){
                private final /* synthetic */ LibraryPanel this$0;
                private final /* synthetic */ LinkedList val$files;

                public final void run() {
                    int n = this.val$files.size();
                    while (this.val$files.size() > 0) {
                        File file = (File)this.val$files.removeFirst();
                        if (LibraryPanel.access$0(this.this$0).enqueue(file)) continue;
                        this.this$0.setStatus(XNap.tr("Could not enqueue file") + file);
                    }
                    if (n > 0) {
                        this.this$0.setStatus(XNap.tr("Enqueued", 0, 1) + n + XNap.tr("file(s)", 1, 0));
                    }
                }
                {
                    this.val$files = linkedList;
                    this.this$0 = libraryPanel;
                    this.constructor$0(libraryPanel, string);
                }

                private final void constructor$0(LibraryPanel libraryPanel, String string) {
                }
            }.start();
        } else {
            this.setStatus(XNap.tr("Could not launch audio player, please check your preferences"));
        }
    }

    private final void doPlay(int[] nArray) {
        if (nArray.length == 0) {
            this.playFile(null);
        } else if (nArray.length > 0 && this.player.canPlay(this.ltm.get(nArray[0]))) {
            this.playFile(this.ltm.get(nArray[0]));
        }
        if (nArray.length > 1) {
            LinkedList<RepositoryFile> linkedList = new LinkedList<RepositoryFile>();
            int n = 1;
            while (n < nArray.length) {
                if (this.player.canPlay(this.ltm.get(nArray[n]))) {
                    linkedList.add(this.ltm.get(nArray[n]));
                }
                ++n;
            }
            this.enqueueFiles(linkedList);
        }
    }

    public File getDirectory() {
        Object object;
        TreePath treePath = this.jt.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof File) {
            return (File)object;
        }
        return null;
    }

    public File[] getFiles(boolean bl) {
        int n = this.jta.getSelectedRowCount();
        int[] nArray = this.jta.getSelectedRows();
        if (bl && n == 0) {
            this.setStatus(XNap.tr("Please select something first"));
            return null;
        }
        File[] fileArray = new File[n];
        int n2 = 0;
        while (n2 < n) {
            fileArray[n2] = this.ltm.get(nArray[n2]);
            ++n2;
        }
        return fileArray;
    }

    public File[] getFiles() {
        return this.getFiles(true);
    }

    private final void displayFile(File file) {
        if (!file.canRead()) {
            this.jspPreview.setViewportView(this.jpPreview);
            this.jlStatus.setText(XNap.tr("Do not have permission to read file"));
            return;
        }
        ViewerPanel viewerPanel = GUIPluginManager.getGUIInstance().getViewer(file);
        if (viewerPanel != null) {
            this.jlStatus.setText(viewerPanel.getStatus());
            this.displayThread.setPanel(viewerPanel);
        } else {
            this.resetPanel();
        }
    }

    public void resetPanel() {
        this.jspPreview.setViewportView(this.jpPreview);
        this.updateStatus();
    }

    public int getHorizontalDividerLocation() {
        return this.jspH.getDividerLocation();
    }

    public void setHorizontalDividerLocation(int n) {
        if (n == -1) {
            this.jspH.setDividerLocation(200);
        } else {
            this.jspH.setDividerLocation(n);
        }
    }

    public int getVerticalDividerLocation() {
        return this.jspV.getDividerLocation();
    }

    public void setVerticalDividerLocation(int n) {
        if (n == -1) {
            this.jspV.setDividerLocation(200);
        } else {
            this.jspV.setDividerLocation(n);
        }
    }

    public void updateStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        File[] fileArray = this.getFiles(false);
        if (fileArray.length == 0) {
            stringBuffer.append(this.ltm.getRowCount());
            stringBuffer.append(" files - ");
            stringBuffer.append(Formatter.formatSize(this.ltm.getTotalSize()));
        } else if (fileArray.length == 1) {
            stringBuffer.append("1 file - ");
            stringBuffer.append(Formatter.formatNumber(fileArray[0].length()) + " bytes");
        } else {
            long l = 0L;
            int n = 0;
            while (n < fileArray.length) {
                l += fileArray[n].length();
                ++n;
            }
            stringBuffer.append("selected - ");
            stringBuffer.append(fileArray.length);
            stringBuffer.append(" files - ");
            stringBuffer.append(Formatter.formatSize(l));
        }
        stringBuffer.insert(0, " ");
        this.jlStatus.setText(stringBuffer.toString());
    }

    private final JMenu createViewerMenu() {
        JMenu jMenu = new JMenu(XNap.tr("View with Plugin"));
        jMenu.setIcon(XNapFrame.getEmptyIcon());
        IPlugin[] iPluginArray = PluginManager.getInstance().getPlugins();
        int n = 0;
        while (n < iPluginArray.length) {
            if (iPluginArray[n] instanceof IViewerPlugin) {
                jMenu.add(new ViewerAction((IViewerPlugin)iPluginArray[n], this));
            }
            ++n;
        }
        return jMenu;
    }

    static /* synthetic */ JScrollPane access$17(LibraryPanel libraryPanel) {
        return libraryPanel.jspPreview;
    }

    public LibraryPanel() {
        this.initialize();
    }

    private class ViewerAction
    extends AbstractAction
    implements StateListener {
        private IViewerPlugin plugin;
        private FileCollector fc;

        public void actionPerformed(ActionEvent actionEvent) {
            File[] fileArray = this.fc.getFiles();
            if (fileArray != null && fileArray.length > 0) {
                ViewerPanel viewerPanel = this.plugin.handle(fileArray[0]);
                LibraryPanel.this.jlStatus.setText(viewerPanel.getStatus());
                LibraryPanel.this.displayThread.setPanel(viewerPanel);
            }
        }

        public void stateDisabled(StateEvent stateEvent) {
            if (this.plugin == stateEvent.getSource()) {
                this.setEnabled(false);
            }
        }

        public void stateEnabled(StateEvent stateEvent) {
            if (this.plugin == stateEvent.getSource()) {
                this.setEnabled(true);
            }
        }

        public ViewerAction(IViewerPlugin iViewerPlugin, FileCollector fileCollector) {
            this.plugin = iViewerPlugin;
            this.fc = fileCollector;
            this.putValue("Name", iViewerPlugin.getName());
            this.setEnabled(iViewerPlugin.isEnabled());
            GUIPluginManager.getInstance().addStateListener(this);
        }
    }

    private class PlayFileAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (LibraryPanel.this.getFileChooser().showOpenDialog(LibraryPanel.this) == 0) {
                LibraryPanel.this.playFile(LibraryPanel.this.jfc.getSelectedFile());
            }
        }

        public PlayFileAction() {
            this.putValue("Name", XNap.tr("Play File"));
            this.putValue("ShortDescription", XNap.tr("Open a file to play"));
            this.putValue("SmallIcon", XNapFrame.getIcon("fileopen.png"));
            this.putValue("MnemonicKey", new Integer(79));
        }
    }

    private class PlayAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryPanel.this.doPlay(LibraryPanel.this.jta.getSelectedRows());
        }

        public PlayAction() {
            this.putValue("Name", XNap.tr("Play"));
            this.putValue("ShortDescription", XNap.tr("Plays selected file(s)"));
            this.putValue("SmallIcon", XNapFrame.getIcon("1rightarrow.png"));
            this.putValue("MnemonicKey", new Integer(80));
        }
    }

    private class StopAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (LibraryPanel.this.player != null) {
                LibraryPanel.this.player.stop();
            }
        }

        public StopAction() {
            this.putValue("Name", XNap.tr("Stop"));
            this.putValue("ShortDescription", XNap.tr("Stop player"));
            this.putValue("SmallIcon", XNapFrame.getIcon("player_stop.png"));
            this.putValue("MnemonicKey", new Integer(83));
        }
    }

    private class RefreshAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (LibraryPanel.this.currentDir != null) {
                LibraryPanel.this.showDirectory(LibraryPanel.this.currentDir);
            }
        }

        public RefreshAction() {
            this.putValue("Name", XNap.tr("Refresh"));
            this.putValue("ShortDescription", XNap.tr("Refresh list of files"));
            this.putValue("SmallIcon", XNapFrame.getIcon("reload.png"));
            this.putValue("MnemonicKey", new Integer(82));
        }
    }

    private class ReloadTreeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            LibraryPanel.this.ftm.reload();
        }

        public ReloadTreeAction() {
            this.putValue("Name", XNap.tr("Reload Tree"));
            this.putValue("ShortDescription", XNap.tr("Reload Tree"));
            this.putValue("SmallIcon", XNapFrame.getIcon("reload.png"));
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            File[] fileArray = LibraryPanel.this.getFiles();
            if (fileArray == null) {
                return;
            }
            if ((fileArray = Dialogs.showDeleteFilesDialog(LibraryPanel.this, fileArray)) != null) {
                int n = 0;
                while (n < fileArray.length) {
                    if (!LibraryPanel.this.ltm.delete(fileArray[n])) {
                        LibraryPanel.this.setStatus(XNap.tr("Could not delete file", 0, 1) + fileArray[n].getName());
                    }
                    ++n;
                }
            }
        }

        public DeleteAction() {
            this.putValue("Name", XNap.tr("Delete"));
            this.putValue("ShortDescription", XNap.tr("Delete selected file(s)"));
            this.putValue("SmallIcon", XNapFrame.getIcon("editdelete.png"));
            this.putValue("MnemonicKey", new Integer(68));
        }
    }

    private class EnqueueAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            LinkedList<RepositoryFile> linkedList = new LinkedList<RepositoryFile>();
            int n = LibraryPanel.this.jta.getSelectedRowCount();
            int[] nArray = LibraryPanel.this.jta.getSelectedRows();
            int n2 = 0;
            while (n2 < n) {
                if (LibraryPanel.this.player.canPlay(LibraryPanel.this.ltm.get(nArray[n2]))) {
                    linkedList.add(LibraryPanel.this.ltm.get(nArray[n2]));
                }
                ++n2;
            }
            LibraryPanel.this.enqueueFiles(linkedList);
        }

        public EnqueueAction() {
            this.putValue("Name", XNap.tr("Enqueue"));
            this.putValue("ShortDescription", XNap.tr("Enqueue selected file"));
            this.putValue("SmallIcon", XNapFrame.getIcon("queue.png"));
            this.putValue("MnemonicKey", new Integer(81));
        }
    }

    private class EnqueueFolderAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            LinkedList<RepositoryFile> linkedList = new LinkedList<RepositoryFile>();
            int n = 0;
            while (n < LibraryPanel.this.ltm.getRowCount()) {
                if (LibraryPanel.this.player.canPlay(LibraryPanel.this.ltm.get(n))) {
                    linkedList.add(LibraryPanel.this.ltm.get(n));
                }
                ++n;
            }
            LibraryPanel.this.enqueueFiles(linkedList);
        }

        public EnqueueFolderAction() {
            this.putValue("Name", XNap.tr("Enqueue Folder"));
            this.putValue("ShortDescription", XNap.tr("Enqueue selected folder"));
            this.putValue("SmallIcon", XNapFrame.getIcon("queue.png"));
            this.putValue("MnemonicKey", new Integer(70));
        }
    }

    private class PlayFolderAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = new int[LibraryPanel.this.ltm.getRowCount()];
            int n = 1;
            while (n < nArray.length) {
                nArray[n] = n;
                ++n;
            }
            LibraryPanel.this.doPlay(nArray);
        }

        public PlayFolderAction() {
            this.putValue("Name", XNap.tr("Play Folder"));
            this.putValue("ShortDescription", XNap.tr("Plays selected folder"));
            this.putValue("SmallIcon", XNapFrame.getIcon("1rightarrow.png"));
            this.putValue("MnemonicKey", new Integer(76));
        }
    }

    private class RenameAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = LibraryPanel.this.jta.getSelectedRow();
            if (n != -1) {
                LibraryPanel.this.ltm.setCellEditable(n, LibraryTableModel.NAME);
                LibraryPanel.this.jta.editCellAt(n, LibraryTableModel.NAME);
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)LibraryPanel.this.jta.getCellEditor();
                JTextField jTextField = (JTextField)defaultCellEditor.getComponent();
                jTextField.grabFocus();
                jTextField.setCaretPosition(0);
                LibraryPanel.this.ltm.setCellEditable(-1, -1);
            }
        }

        public RenameAction() {
            this.putValue("Name", XNap.tr("Rename"));
            this.putValue("ShortDescription", XNap.tr("Rename selected file"));
            this.putValue("MnemonicKey", new Integer(82));
            this.putValue("SmallIcon", XNapFrame.getEmptyIcon());
        }
    }

    private class ShareFolderAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray = LibraryPanel.this.jt.getSelectionPaths();
            int n = 0;
            while (n < treePathArray.length) {
                Object object = treePathArray[n].getLastPathComponent();
                if (object instanceof FileNode) {
                    AbstractPanel.prefs.appendToUploadDirs(((FileNode)object).getPath());
                    AbstractPanel.prefs.write();
                } else {
                    LibraryPanel.this.setStatus(XNap.tr("Can not share \"") + object + "\"");
                }
                ++n;
            }
        }

        public ShareFolderAction() {
            this.putValue("Name", XNap.tr("Share Folder"));
            this.putValue("ShortDescription", XNap.tr("Share selected folder"));
            this.putValue("SmallIcon", XNapFrame.getIcon("connect_established.png"));
            this.putValue("MnemonicKey", new Integer(72));
        }
    }

    private class UnshareFolderAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath[] treePathArray = LibraryPanel.this.jt.getSelectionPaths();
            int n = 0;
            while (n < treePathArray.length) {
                Object object = treePathArray[n].getLastPathComponent();
                if (object instanceof FileNode) {
                    AbstractPanel.prefs.removeFromUploadDirs(((FileNode)object).getPath());
                    AbstractPanel.prefs.write();
                } else {
                    LibraryPanel.this.setStatus(XNap.tr("Can not unshare \"") + object + "\"");
                }
                ++n;
            }
        }

        public UnshareFolderAction() {
            this.putValue("Name", XNap.tr("Unshare Folder"));
            this.putValue("ShortDescription", XNap.tr("Unshare selected folder"));
            this.putValue("SmallIcon", XNapFrame.getIcon("connect_no.png"));
            this.putValue("MnemonicKey", new Integer(85));
        }
    }

    private class QueryAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = LibraryPanel.this.jcSearch.getText().trim();
            if (string.length() > 0) {
                File[] fileArray = Repository.getInstance().search(string);
                if (fileArray != null && fileArray.length > 0) {
                    LibraryPanel.this.jt.clearSelection();
                    LibraryPanel.this.showFiles(fileArray);
                    Object[] objectArray = new Object[]{new Integer(fileArray.length)};
                    LibraryPanel.this.setStatus(MessageFormat.format(XNap.tr("Found {0} files"), objectArray));
                } else {
                    LibraryPanel.this.setStatus(string + XNap.tr("not found in library", 1, 0));
                }
                LibraryPanel.this.jcSearch.addDistinctItemAtTop(string);
            } else {
                LibraryPanel.this.setStatus(XNap.tr("What are you trying to search for?"));
            }
        }

        public QueryAction() {
            this.putValue("Name", XNap.tr("Query"));
            this.putValue("ShortDescription", XNap.tr("Perform search"));
            this.putValue("MnemonicKey", new Integer(81));
        }
    }

    protected class SelectionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = LibraryPanel.this.jta.getSelectedRow();
            if (n == -1 || LibraryPanel.this.jta.getSelectedRowCount() != 1) {
                return;
            }
            if (n == LibraryPanel.this.currentRow) {
                LibraryPanel.this.displayFile(LibraryPanel.this.ltm.get(n));
            }
        }

        SelectionListener() {
        }
    }

    private class DisplayThread
    extends Thread {
        private ViewerPanel panel;

        public void setPanel(ViewerPanel viewerPanel) {
            this.panel = viewerPanel;
            this.interrupt();
            DisplayThread displayThread = this;
            synchronized (displayThread) {
                this.notify();
            }
            if (!this.isAlive()) {
                this.start();
            }
        }

        public void run() {
            while (true) {
                Runnable runnable;
                if (this.panel == null) {
                    runnable = this;
                    synchronized (runnable) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this.panel.display();
                runnable = new Runnable(this){
                    private ViewerPanel p;
                    private final /* synthetic */ DisplayThread this$0;
                    private final /* synthetic */ LibraryPanel this$1;

                    public final void run() {
                        LibraryPanel.access$17(this.this$1).getHorizontalScrollBar().setValue(0);
                        LibraryPanel.access$17(this.this$1).getVerticalScrollBar().setValue(0);
                        LibraryPanel.access$17(this.this$1).setViewportView(this.p);
                        LibraryPanel.access$1(this.this$1).setText(this.p.getStatus());
                    }
                    {
                        this.this$0 = displayThread;
                        this.this$1 = DisplayThread.access$1(this.this$0);
                        this.p = DisplayThread.access$0(this.this$0);
                        this.constructor$0(displayThread);
                    }

                    private final void constructor$0(DisplayThread displayThread) {
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.panel = null;
            }
        }

        static /* synthetic */ ViewerPanel access$0(DisplayThread displayThread) {
            return displayThread.panel;
        }

        static /* synthetic */ LibraryPanel access$1(DisplayThread displayThread) {
            return displayThread.LibraryPanel.this;
        }

        public DisplayThread() {
            super("LibraryPanelLoader");
            this.start();
        }
    }
}

