/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.gui.XNapFrame;
import xnap.gui.event.FileCollector;
import xnap.util.Preferences;
import xnap.util.launcher.LauncherSupport;

public class OpenFileWithMenu
extends JMenu
implements PropertyChangeListener {
    protected static Logger logger = Logger.getLogger(class$Lxnap$gui$action$OpenFileWithMenu != null ? class$Lxnap$gui$action$OpenFileWithMenu : (class$Lxnap$gui$action$OpenFileWithMenu = OpenFileWithMenu.class$("xnap.gui.action.OpenFileWithMenu")));
    protected FileCollector fc;
    protected Preferences prefs = Preferences.getInstance();
    private static /* synthetic */ Class class$Lxnap$gui$action$OpenFileWithMenu;

    public void openFiles(String string) {
        File[] fileArray = this.fc.getFiles();
        if (fileArray == null || string == null) {
            return;
        }
        try {
            LauncherSupport.exec(string, fileArray);
        }
        catch (IOException iOException) {
            logger.warn("could not execute", iOException);
        }
    }

    private final void setupMenu() {
        this.removeAll();
        this.add(new OthersAction());
        this.addSeparator();
        String[] stringArray = this.prefs.getOpenWithCommandsArray();
        int n = 0;
        while (n < stringArray.length) {
            this.add(new ItemAction(stringArray[n]));
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setupMenu();
    }

    protected void insertCommand(String string) {
        LinkedList linkedList = this.prefs.getOpenWithCommandsList();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            if (!string.equals((String)iterator.next())) continue;
            iterator.remove();
            break;
        }
        linkedList.addFirst(string);
        while (linkedList.size() > this.prefs.getMaxOpenWithCommands()) {
            linkedList.removeLast();
        }
        this.prefs.setOpenWithCommands(linkedList);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public OpenFileWithMenu(FileCollector fileCollector) {
        super(XNap.tr("Open With"));
        this.fc = fileCollector;
        this.setIcon(XNapFrame.getIcon("folder_new.png"));
        this.setupMenu();
        this.prefs.addPropertyChangeListener("openWithCommands", this);
    }

    protected class ItemAction
    extends AbstractAction {
        String command;

        public void actionPerformed(ActionEvent actionEvent) {
            OpenFileWithMenu.this.openFiles(this.command);
            OpenFileWithMenu.this.insertCommand(this.command);
        }

        public ItemAction(String string) {
            this.command = string;
            this.putValue("Name", string);
        }
    }

    protected class OthersAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = OpenFileWithMenu.this.fc instanceof Component ? JOptionPane.showInputDialog((Component)((Object)OpenFileWithMenu.this.fc), XNap.tr("Enter command"), XNap.tr("Open With") + "...", 3) : JOptionPane.showInputDialog(null, XNap.tr("Enter command"), XNap.tr("Open With") + "...", 3);
            OpenFileWithMenu.this.openFiles(string);
            if (string != null) {
                OpenFileWithMenu.this.insertCommand(string);
            }
        }

        public OthersAction() {
            this.putValue("Name", XNap.tr("Other") + "...");
        }
    }
}

