/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.prefs;

import java.awt.Container;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import xnap.XNap;
import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.GridBagHelper;
import xnap.gui.ValidatedTextField;
import xnap.gui.XNapFrame;

public class ApplicationPrefsPanel
extends AbstractPreferencesPanel {
    private JCheckBox jcShowIcons;
    private JCheckBox jcShowSplash;
    private JCheckBox jcShowTooltips;
    private ValidatedTextField jteMaxConsoleLines;
    private ValidatedTextField jteHistorySize;
    private JRadioButton jrbFocusAlways;
    private JRadioButton jrbFocusNever;

    public void apply() {
        AbstractPreferencesPanel.prefs.setShowIcons(this.jcShowIcons.isSelected());
        AbstractPreferencesPanel.prefs.setShowSplash(this.jcShowSplash.isSelected());
        AbstractPreferencesPanel.prefs.setShowToolTips(this.jcShowTooltips.isSelected());
        AbstractPreferencesPanel.prefs.setMaxConsoleLines(this.jteMaxConsoleLines.getIntValue());
        AbstractPreferencesPanel.prefs.setSearchHistorySize(this.jteHistorySize.getIntValue());
        AbstractPreferencesPanel.prefs.setFocusOnAllEvents(this.jrbFocusAlways.isSelected());
    }

    public Icon getIcon() {
        return XNapFrame.getIcon("gohome.png");
    }

    public String getTitle() {
        return XNap.tr("Application");
    }

    public ApplicationPrefsPanel() {
        this.setLayout(new GridBagLayout());
        this.jcShowSplash = new JCheckBox(XNap.tr("Show Splash Screen", 1), AbstractPreferencesPanel.prefs.getShowSplash());
        GridBagHelper.add((Container)this, this.jcShowSplash);
        this.jcShowIcons = new JCheckBox(XNap.tr("Display Icons", 1), AbstractPreferencesPanel.prefs.getShowIcons());
        GridBagHelper.add((Container)this, this.jcShowIcons);
        this.jcShowTooltips = new JCheckBox(XNap.tr("Show Tooltips", 1), AbstractPreferencesPanel.prefs.getShowToolTips());
        GridBagHelper.add((Container)this, this.jcShowTooltips);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(XNap.tr("Number of Lines", 1)));
        GridBagHelper.add((Container)this, jPanel);
        GridBagHelper.addLabel(jPanel, XNap.tr("Console"));
        this.jteMaxConsoleLines = new ValidatedTextField(AbstractPreferencesPanel.prefs.getMaxConsoleLines() + "", 5, "0123456789");
        GridBagHelper.add(jPanel, this.jteMaxConsoleLines, false);
        GridBagHelper.addLabel(jPanel, XNap.tr("History"));
        this.jteHistorySize = new ValidatedTextField(AbstractPreferencesPanel.prefs.getSearchHistorySize() + "", 5, "0123456789");
        GridBagHelper.add(jPanel, this.jteHistorySize, false);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(XNap.tr("Global Focus Policy", 1)));
        GridBagHelper.add((Container)this, jPanel2);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.jrbFocusAlways = new JRadioButton(XNap.tr("Auto Focus New Windows"), AbstractPreferencesPanel.prefs.getFocusOnAllEvents());
        buttonGroup.add(this.jrbFocusAlways);
        GridBagHelper.add((Container)jPanel2, this.jrbFocusAlways);
        this.jrbFocusNever = new JRadioButton(XNap.tr("Never Switch Focus"), !AbstractPreferencesPanel.prefs.getFocusOnAllEvents());
        buttonGroup.add(this.jrbFocusNever);
        GridBagHelper.add((Container)jPanel2, this.jrbFocusNever);
        GridBagHelper.addVerticalSpacer(this);
    }
}

