/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.gui.table;

import java.util.AbstractCollection;
import java.util.ArrayList;
import xnap.XNap;
import xnap.gui.table.AbstractDynamicTableModel;
import xnap.gui.table.Column;
import xnap.gui.table.LinkSpeedCellRenderer;
import xnap.gui.table.NumberCellRenderer;
import xnap.gui.table.TimeCellRenderer;
import xnap.net.IUser;
import xnap.plugin.nap.Plugin;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.server.MessageListener;
import xnap.plugin.nap.net.msg.server.ServerMessage;
import xnap.plugin.nap.net.msg.server.WhoisResponseMessage;
import xnap.plugin.nap.util.NapPreferences;
import xnap.util.LinkSpeed;

public class WhoisTableModel
extends AbstractDynamicTableModel
implements MessageListener {
    public static final int NAME = 0;
    public static final int SERVER = 1;
    public static final int FILE_COUNT = 2;
    public static final int LINK_SPEED = 3;
    public static final int LEVEL = 4;
    public static final int STATUS = 5;
    public static final int DOWNLOAD_COUNT = 6;
    public static final int UPLOAD_COUNT = 7;
    public static final int CLIENT_INFO = 8;
    public static final int LAST_SEEN = 9;
    public static final int CONNECT_DURATION = 10;
    protected Column[] columns = new Column[]{new Column(Plugin.tr("User"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WhoisTableModel.class$("java.lang.String"))), new Column(Plugin.tr("Server"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WhoisTableModel.class$("java.lang.String"))), new Column(Plugin.tr("File Count"), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = WhoisTableModel.class$("java.lang.Integer")), new NumberCellRenderer()), new Column(Plugin.tr("Link Speed"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WhoisTableModel.class$("java.lang.String")), new LinkSpeedCellRenderer()), new Column(Plugin.tr("Level"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WhoisTableModel.class$("java.lang.String"))), new Column(Plugin.tr("Status"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WhoisTableModel.class$("java.lang.String"))), new Column(Plugin.tr("Downloads"), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = WhoisTableModel.class$("java.lang.Integer")), new NumberCellRenderer()), new Column(Plugin.tr("Upload"), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = WhoisTableModel.class$("java.lang.Integer")), new NumberCellRenderer()), new Column(Plugin.tr("Client"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WhoisTableModel.class$("java.lang.String"))), new Column(Plugin.tr("Last Seen"), class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = WhoisTableModel.class$("java.lang.Long")), new TimeCellRenderer()), new Column(Plugin.tr("Online"), class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = WhoisTableModel.class$("java.lang.Long")), new TimeCellRenderer())};
    private ArrayList rows = new ArrayList();
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$lang$Long;

    public void add(User user) {
        int n = this.rows.indexOf(new MyUser(user));
        if (n == -1) {
            this.rows.add(user);
            this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
        } else {
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void clear() {
        int n = this.rows.size() - 1;
        this.rows.clear();
        this.fireTableRowsDeleted(0, n);
    }

    public User get(int n) {
        return (User)this.rows.get(this.mapToIndex(n));
    }

    public Object get(int n, int n2) {
        if (n >= this.rows.size()) {
            return null;
        }
        User user = (User)this.rows.get(n);
        if (user == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return user.getName();
            }
            case 1: {
                return user.getServer().getHost() + ":" + user.getServer().getPort();
            }
            case 2: {
                return new Integer(user.getFileCount());
            }
            case 3: {
                return new LinkSpeed(user.getLinkSpeed()).toString();
            }
            case 4: {
                return user.getLevel();
            }
            case 5: {
                return IUser.STATUS_MSGS[user.getStatus()];
            }
            case 6: {
                return new Integer(user.getDownloadCount());
            }
            case 7: {
                return new Integer(user.getUploadCount());
            }
            case 8: {
                return user.getClientInfo();
            }
            case 9: {
                long l = user.getLastSeen();
                return new Long(l > 0L ? l : -1L);
            }
            case 10: {
                return new Integer(user.getConnectDuration());
            }
        }
        return "";
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public String getTableName() {
        return XNap.tr("Whois Table");
    }

    public void messageReceived(ServerMessage serverMessage) {
        WhoisResponseMessage whoisResponseMessage = (WhoisResponseMessage)serverMessage;
        this.add(whoisResponseMessage.getServer().getUser(whoisResponseMessage.nick));
    }

    public void reload() {
        this.fireTableDataChanged();
    }

    public void remove(User user) {
        int n = this.rows.indexOf(user);
        if (n != -1) {
            ((AbstractCollection)this.rows).remove(user);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void set(Object object, int n, int n2) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public WhoisTableModel() {
        super("whois", NapPreferences.getInstance());
        this.setColumns(this.columns);
        MessageHandler.subscribe(604, this);
    }

    class MyUser
    extends User {
        public boolean equals(Object object) {
            if (object != null && object instanceof User) {
                User user = (User)object;
                return this.getName().equals(user.getName()) && this.getServer().equals(user.getServer());
            }
            return false;
        }

        public MyUser(User user) {
            super(user.getName(), user.getServer());
        }
    }
}

