/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.util;

import java.io.IOException;
import xnap.net.AbstractChannel;
import xnap.net.IUser;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.ExceptionListener;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.PrivateMessage;
import xnap.plugin.nap.net.msg.server.GlobalMessage;
import xnap.plugin.nap.net.msg.server.MessageListener;
import xnap.plugin.nap.net.msg.server.ServerMessage;

public class PrivateChannel
extends AbstractChannel
implements MessageListener,
ExceptionListener {
    public static final int ERROR_WAIT = 3000;
    protected long lastSent;
    protected User user;
    protected Server server;

    public boolean canChangeTopic() {
        return false;
    }

    public void changeTopic(String string) {
    }

    public void close() {
        MessageHandler.unsubscribe(628, this);
        MessageHandler.removePrivateChannel(this);
    }

    public void exceptionThrown(Exception exception) {
        this.errorReceived(exception.getMessage());
    }

    public User getUser() {
        return this.user;
    }

    public IUser[] getUsers() {
        return new IUser[]{this.user};
    }

    public void join() {
        MessageHandler.subscribe(628, this);
        this.infoReceived("Talking to " + this.user.toString());
    }

    public void messageReceived(String string) {
        this.messageReceived(this.user, string);
    }

    public void sendMessage(String string) throws IOException {
        PrivateMessage privateMessage = new PrivateMessage(this.user.getName(), string);
        privateMessage.setExceptionListener(this);
        MessageHandler.send(this.server, privateMessage);
        this.lastSent = System.currentTimeMillis();
        this.messageReceived(this.server.getUser(), string);
    }

    public void messageReceived(ServerMessage serverMessage) {
        if (serverMessage.getServer() != this.server) {
            return;
        }
        if (serverMessage instanceof GlobalMessage && System.currentTimeMillis() - this.lastSent < 3000L) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.server.getHost());
            stringBuffer.append(": ");
            stringBuffer.append(((GlobalMessage)serverMessage).message);
            this.errorReceived(stringBuffer.toString());
        }
    }

    public PrivateChannel(User user) {
        super(user.getServer(), user.toString(), "", 1);
        this.user = user;
        this.server = user.getServer();
    }
}

