/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import xnap.net.ITransferContainer;

public class Formatter {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final String[] SIZES = new String[]{"B", "KB", "MB", "GB", "TB"};

    public static String formatNumber(Object object, int n) {
        if (object != null && object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return Formatter.formatNumber(d, n);
        }
        return null;
    }

    public static String formatNumber(double d, int n) {
        if (d >= 0.0) {
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            if (n > 0) {
                numberFormat.setMinimumFractionDigits(n);
                numberFormat.setMaximumFractionDigits(n);
            }
            return numberFormat.format(d);
        }
        return "";
    }

    public static String formatNumber(double d) {
        return Formatter.formatNumber(d, 0);
    }

    public static String formatSize(Object object) {
        if (object != null && object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return Formatter.formatSize(d);
        }
        return null;
    }

    public static String formatSize(double d) {
        int n = 0;
        while (n < SIZES.length - 1 && d >= 1024.0) {
            d /= 1024.0;
            ++n;
        }
        return Formatter.formatNumber(d, 1) + " " + SIZES[n];
    }

    public static String formatLength(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = l / 3600L;
        if (l2 > 0L) {
            stringBuffer.append(l2);
            stringBuffer.append(":");
        }
        if ((l2 = l % 3600L / 60L) < 10L) {
            stringBuffer.append("0");
        }
        stringBuffer.append(l2);
        stringBuffer.append(":");
        l2 = l % 60L;
        if (l2 < 10L) {
            stringBuffer.append("0");
        }
        stringBuffer.append(l2);
        return stringBuffer.toString();
    }

    public static String formatTime(long l) {
        return DateFormat.getDateInstance().format(new Date(l));
    }

    public static String formatTable(String[] stringArray, int[] nArray) {
        int n;
        if (stringArray.length == 0) {
            return "(list is empty)";
        }
        int[] nArray2 = new int[nArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n2], "|");
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                n = stringTokenizer.nextToken().length();
                if (n > nArray2[n3]) {
                    nArray2[n3] = n;
                }
                ++n3;
            }
            ++n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < stringArray.length) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n4], "|");
            n = 0;
            while (n < nArray.length) {
                String string = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : "";
                int n5 = nArray2[n] - string.length();
                switch (nArray[n]) {
                    case 0: {
                        stringBuffer.append(string);
                        stringBuffer.append(Formatter.fill(" ", n5));
                        break;
                    }
                    case 1: {
                        int n6 = n5 / 2;
                        stringBuffer.append(Formatter.fill(" ", n6));
                        stringBuffer.append(string);
                        stringBuffer.append(Formatter.fill(" ", n5 - n6));
                        break;
                    }
                    case 2: {
                        stringBuffer.append(Formatter.fill(" ", n5));
                        stringBuffer.append(string);
                        break;
                    }
                }
                if (n < nArray.length - 1) {
                    stringBuffer.append(" | ");
                }
                ++n;
            }
            stringBuffer.append("\n");
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static String formatTransfer(ITransferContainer iTransferContainer) {
        return new String(iTransferContainer.getUser() + " - - " + "[" + Formatter.getCLFDate() + "]" + " " + "\"" + iTransferContainer.getFilename() + "\"" + " " + "\"" + iTransferContainer.getStatusText() + "\"" + " " + iTransferContainer.getFilesize() + " - " + "\"" + iTransferContainer.getUser().getClientInfo() + "\"" + "\n");
    }

    public static String fill(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String getCLFDate() {
        String string = "dd/MMM/yyyy:HH:mm:ss";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(new Date());
    }

    public static String shortDate() {
        return DateFormat.getTimeInstance(3).format(new Date());
    }
}

