#!/usr/bin/env python
# Copyright (c) 2002 Nathan Sharfi
# Copyright terms are included in a file called 'license.txt'.

import os
import prioritymanager

"""
Vorbisgain has a --recursive option on Windows as of version 0.32, but
the unix one doesn't. Hence, _posixize() and _ntize().

"""

def _posixize(directory):
    """The POSIX way to get a directory done."""
    return '"%s/"*' % directory 
def _ntize(directory):
    return '--recursive ' + directory
    
    
    
def vorbisgainBunch(directory, album=True, skip=True, quiet=False):
    """Calls vorbisgain on a directory full of files."""
    if album: albumCmd = '--album'
    else:     albumCmd = ''
    if skip:  skipCmd  = '--skip'
    else:     skipCmd  = ''
    if quiet: quietCmd = '--quiet'
    else:     quietCmd = ''
    
    dirCmd = None
    if   os.name == 'posix':
        dirCmd = _posixize(directory)
    elif os.name == 'nt':
        dirCmd = _ntize(directory)
    else:
        raise RuntimeError, 'unsupported OS type, should be either posix or nt'
    cmd = 'vorbisgain %s %s %s %s' % \
          (albumCmd, skipCmd, quietCmd, dirCmd)
    cmd = prioritymanager.priorityManager(cmd)
    print cmd
    os.system(cmd)
                   
