/*
 * Decompiled with CFR 0.152.
 */
package jacorb.imr.util;

import jacorb.imr.Admin;
import jacorb.imr.AdminHelper;
import jacorb.imr.HostInfo;
import jacorb.imr.ImplementationRepositoryImpl;
import jacorb.imr.Registration;
import jacorb.imr.RegistrationHelper;
import jacorb.imr.ServerInfo;
import jacorb.imr.UnknownServerName;
import jacorb.util.Debug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.omg.CORBA.ORB;

public class ImRManager {
    private static jacorb.orb.ORB m_orb;

    private static void addServer(String[] stringArray) {
        Admin admin;
        if (stringArray.length < 2) {
            System.out.println("Please specify a server name");
            ImRManager.usage();
        }
        String string = stringArray[1];
        String string2 = null;
        String string3 = null;
        try {
            int n = 2;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-h")) {
                    if (string2 == null) {
                        string2 = stringArray[++n];
                    } else {
                        ImRManager.usage();
                    }
                } else if (stringArray[n].equals("-c")) {
                    if (string3 == null) {
                        string3 = stringArray[++n];
                    }
                } else {
                    System.out.println("Unrecognized switch: " + stringArray[n]);
                    ImRManager.usage();
                }
                ++n;
            }
            if (string2 == null) {
                string2 = ImRManager.getLocalHostName();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ImRManager.usage();
        }
        if (string == null || string2 == null) {
            ImRManager.usage();
        }
        if (string3 == null) {
            string3 = "";
        }
        if ((admin = AdminHelper.narrow(ImplementationRepositoryImpl.getImR(m_orb))) == null) {
            System.out.println("Unable to connect to repository process!");
            System.out.println("Please check, if the URL and the IOR file path point to the same file.");
            System.out.println("Properties jacorb.imr.ior_file and");
            System.out.println("jacorb.ImplementationRepositoryURL");
            System.exit(-1);
        }
        try {
            if (stringArray[0].equals("add")) {
                admin.register_server(string, string3, string2);
            } else {
                admin.edit_server(string, string3, string2);
            }
            System.out.println("Server " + string + " successfully " + stringArray[0] + "ed");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    public static void autoRegisterServer(ORB oRB, String string, String string2, String string3, boolean bl) {
        try {
            Admin admin = AdminHelper.narrow(ImplementationRepositoryImpl.getImR(oRB));
            ServerInfo serverInfo = null;
            try {
                serverInfo = admin.get_server_info(string);
            }
            catch (UnknownServerName unknownServerName) {
                Debug.output(2050, unknownServerName);
            }
            if (serverInfo == null) {
                admin.register_server(string, string2, string3);
            } else if (serverInfo != null && bl) {
                admin.edit_server(string, string2, string3);
            }
        }
        catch (Exception exception) {
            Debug.output(2050, exception);
        }
    }

    public static String getAnyHostName(ORB oRB) {
        try {
            Admin admin = AdminHelper.narrow(ImplementationRepositoryImpl.getImR(oRB));
            HostInfo[] hostInfoArray = admin.list_hosts();
            if (hostInfoArray.length > 0) {
                return hostInfoArray[0].name;
            }
        }
        catch (Exception exception) {
            Debug.output(2050, exception);
        }
        return "";
    }

    public static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            Debug.output(2050, unknownHostException);
            return "";
        }
    }

    private static void holdServer(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Please specify a server name");
            ImRManager.usage();
        }
        String string = stringArray[1];
        int n = 0;
        Admin admin = AdminHelper.narrow(ImplementationRepositoryImpl.getImR(m_orb));
        if (admin == null) {
            System.out.println("Unable to connect to repository process!");
            System.out.println("Please check, if the URL and the IOR file path point to the same file.");
            System.out.println("Properties jacorb.imr.ior_file and");
            System.out.println("jacorb.ImplementationRepositoryURL");
            System.exit(-1);
        }
        try {
            if (stringArray.length == 3) {
                n = Integer.parseInt(stringArray[2]);
            }
            admin.hold_server(string);
            System.out.println("Server " + string + " set to holding");
            if (n > 0) {
                Thread.sleep(n);
                admin.release_server(string);
                System.out.println("Server " + string + " released");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    private static void list(String[] stringArray) {
        Admin admin;
        if (stringArray.length < 2) {
            System.out.println("Please use (servers | hosts) in command");
            ImRManager.usage();
        }
        if ((admin = AdminHelper.narrow(ImplementationRepositoryImpl.getImR(m_orb))) == null) {
            System.out.println("Unable to connect to repository process!");
            System.out.println("Please check, if the URL and the IOR file path point to the same file.");
            System.out.println("Properties jacorb.imr.ior_file and");
            System.out.println("jacorb.ImplementationRepositoryURL");
            System.exit(-1);
        }
        try {
            if (stringArray[1].equals("servers")) {
                ServerInfo[] serverInfoArray = admin.list_servers();
                System.out.println("Servers (total: " + serverInfoArray.length + "):");
                int n = 0;
                while (n < serverInfoArray.length) {
                    System.out.println(String.valueOf(n + 1) + ") " + serverInfoArray[n].name);
                    System.out.println("   Host: " + serverInfoArray[n].host);
                    System.out.println("   Command: " + serverInfoArray[n].command);
                    System.out.println("   active: " + (serverInfoArray[n].active ? "yes" : "no"));
                    System.out.println("   holding: " + (serverInfoArray[n].holding ? "yes" : "no"));
                    ++n;
                }
            } else if (stringArray[1].equals("hosts")) {
                HostInfo[] hostInfoArray = admin.list_hosts();
                System.out.println("Hosts (total: " + hostInfoArray.length + "):");
                int n = 0;
                while (n < hostInfoArray.length) {
                    System.out.println(String.valueOf(n + 1) + ") " + hostInfoArray[n].name);
                    ++n;
                }
            } else {
                System.out.println("Unrecognized option: " + stringArray[1]);
                ImRManager.usage();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            ImRManager.usage();
        }
        m_orb = (jacorb.orb.ORB)ORB.init(stringArray, null);
        try {
            if (stringArray[0].equals("add") || stringArray[0].equals("edit")) {
                ImRManager.addServer(stringArray);
            } else if (stringArray[0].equals("remove")) {
                ImRManager.remove(stringArray);
            } else if (stringArray[0].equals("list")) {
                ImRManager.list(stringArray);
            } else if (stringArray[0].equals("hold")) {
                ImRManager.holdServer(stringArray);
            } else if (stringArray[0].equals("release")) {
                ImRManager.releaseServer(stringArray);
            } else if (stringArray[0].equals("start")) {
                ImRManager.startServer(stringArray);
            } else if (stringArray[0].equals("savetable")) {
                ImRManager.saveTable();
            } else if (stringArray[0].equals("shutdown")) {
                ImRManager.shutdownImR(stringArray);
            } else if (stringArray[0].equals("setdown")) {
                ImRManager.setDown(stringArray);
            } else if (stringArray[0].equals("gui")) {
                Class.forName("jacorb.imr.util.ImRManagerGUI").newInstance();
            } else if (stringArray[0].equals("help")) {
                ImRManager.usage();
            } else {
                System.out.println("Unrecognized command: " + stringArray[0]);
                ImRManager.usage();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    private static void releaseServer(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Please specify a server name");
            ImRManager.usage();
        }
        String string = stringArray[1];
        boolean bl = false;
        Admin admin = AdminHelper.narrow(ImplementationRepositoryImpl.getImR(m_orb));
        if (admin == null) {
            System.out.println("Unable to connect to repository process!");
            System.out.println("Please check, if the URL and the IOR file path point to the same file.");
            System.out.println("Properties jacorb.imr.ior_file and");
            System.out.println("jacorb.ImplementationRepositoryURL");
            System.exit(-1);
        }
        try {
            admin.release_server(string);
            System.out.println("Server " + string + " released");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    private static void remove(String[] stringArray) {
        Admin admin;
        if (stringArray.length < 3) {
            ImRManager.usage();
        }
        if ((admin = AdminHelper.narrow(ImplementationRepositoryImpl.getImR(m_orb))) == null) {
            System.out.println("Unable to connect to repository process!");
            System.out.println("Please check, if the URL and the IOR file path point to the same file.");
            System.out.println("Properties jacorb.imr.ior_file and");
            System.out.println("jacorb.ImplementationRepositoryURL");
            System.exit(-1);
        }
        if (stringArray[1].equals("server")) {
            try {
                admin.unregister_server(stringArray[2]);
                System.out.println("Server " + stringArray[2] + " successfully removed");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (stringArray[1].equals("host")) {
            try {
                admin.unregister_host(stringArray[2]);
                System.out.println("Host " + stringArray[2] + " successfully removed");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.out.println("Unknown command " + stringArray[1]);
        }
        System.exit(0);
    }

    private static void saveTable() {
        Admin admin = AdminHelper.narrow(ImplementationRepositoryImpl.getImR(m_orb));
        try {
            admin.save_server_table();
            System.out.println("Backup of server table was successfull");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    private static void setDown(String[] stringArray) {
        Registration registration;
        if (stringArray.length < 2) {
            System.out.println("Please specify a server name");
            ImRManager.usage();
        }
        if ((registration = RegistrationHelper.narrow(ImplementationRepositoryImpl.getImR(m_orb))) == null) {
            System.out.println("Unable to connect to repository process!");
            System.out.println("Please check, if the URL and the IOR file path point to the same file.");
            System.out.println("Properties jacorb.imr.ior_file and");
            System.out.println("jacorb.ImplementationRepositoryURL");
            System.exit(-1);
        }
        try {
            registration.set_server_down(stringArray[1]);
            System.out.println("Server " + stringArray[1] + " set down");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    private static void shutdownImR(String[] stringArray) {
        Admin admin = AdminHelper.narrow(ImplementationRepositoryImpl.getImR(m_orb));
        if (admin == null) {
            System.out.println("Unable to connect to repository process!");
            System.out.println("Please check, if the URL and the IOR file path point to the same file.");
            System.out.println("Properties jacorb.imr.ior_file and");
            System.out.println("jacorb.ImplementationRepositoryURL");
            System.exit(-1);
        }
        boolean bl = true;
        if (stringArray.length == 2) {
            if (stringArray[1].equals("force")) {
                bl = false;
            } else {
                System.out.println("Unrecognized option: " + stringArray[1]);
                ImRManager.usage();
            }
        }
        try {
            admin.shutdown(bl);
            System.out.println("The Implementation Repository has been shut down correctly");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    private static void startServer(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Please specify a server name");
            ImRManager.usage();
        }
        String string = stringArray[1];
        Admin admin = AdminHelper.narrow(ImplementationRepositoryImpl.getImR(m_orb));
        if (admin == null) {
            System.out.println("Unable to connect to repository process!");
            System.out.println("Please check, if the URL and the IOR file path point to the same file.");
            System.out.println("Properties jacorb.imr.ior_file and");
            System.out.println("jacorb.ImplementationRepositoryURL");
            System.exit(-1);
        }
        try {
            admin.start_server(string);
            System.out.println("Server " + string + " started");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.exit(0);
    }

    private static void usage() {
        System.out.println("Usage: ImRManager <command> [<servername>] [switches]");
        System.out.println("Command: (add | edit) <servername> [-h hostname] [-c startup cmd]");
        System.out.println("\t -h <hostname> Use this hostname for the server");
        System.out.println("\t -c <command> Specifies a startup-command for this server");
        System.out.println("\t If -h is not set, the local hosts name is used");
        System.out.println("\nCommand: remove  (server | host) <name>");
        System.out.println("\t Removes the server or host  <name> from the repository");
        System.out.println("\nCommand: list (servers | hosts)");
        System.out.println("\t Lists all servers or all hosts");
        System.out.println("\nCommand: hold  <servername> [<time>]");
        System.out.println("\t Holds the server <servername> (if <time> is specified,");
        System.out.println("\t it is released automatically)");
        System.out.println("\nCommand: release  <servername>");
        System.out.println("\t Releases the server <servername>");
        System.out.println("\nCommand: start  <servername>");
        System.out.println("\t Starts the server <servername> on its given host with its given command");
        System.out.println("\nCommand: setdown  <servername>");
        System.out.println("\t Declares the server <servername> as \"down\" to the repository,");
        System.out.println("\t that means the repository tries to start the server up after ");
        System.out.println("\t receiving the next request for it.");
        System.out.println("\t This is actually an operation only committed by the ORB, but it ");
        System.out.println("\t might be useful for server migration and recovery of crashed servers.");
        System.out.println("\t Note: Use \"hold\" before, to avoid the server being restarted at the");
        System.out.println("\t wrong moment.");
        System.out.println("\nCommand: savetable  ");
        System.out.println("\t Makes a backup of the server table");
        System.out.println("\nCommand: shutdown [force]");
        System.out.println("\t Shuts the ImR down orderly. If \"force\" is specified, the ORB ");
        System.out.println("\t is forced down, ignoring open connections.");
        System.out.println("\nCommand: gui");
        System.out.println("\t Bring up manager GUI window");
        System.out.println("\nCommand: help");
        System.out.println("\t This screen");
        System.exit(1);
    }
}

