/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.domain;

import jacorb.orb.domain.Domain;
import jacorb.orb.domain.DomainHelper;
import jacorb.orb.domain.DomainListHelper;
import jacorb.orb.domain.GraphNode;
import jacorb.orb.domain.GraphNodeHelper;
import jacorb.orb.domain.GraphNodeOperations;
import jacorb.orb.domain.GraphNodePackage.ClosesCycle;
import jacorb.orb.domain.GraphNodePackage.ClosesCycleHelper;
import jacorb.orb.domain.NameAlreadyDefined;
import jacorb.orb.domain.NameAlreadyDefinedHelper;
import java.util.Hashtable;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyHelper;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class GraphNodePOA
extends Servant
implements InvokeHandler,
GraphNodeOperations {
    private static final Hashtable m_opsHash = new Hashtable();
    private String[] ids = new String[]{"IDL:jacorb/orb/domain/GraphNode:1.0"};

    static {
        m_opsHash.put("getParentCount", new Integer(0));
        m_opsHash.put("getParents", new Integer(1));
        m_opsHash.put("hasChild", new Integer(2));
        m_opsHash.put("insertChild", new Integer(3));
        m_opsHash.put("isRoot", new Integer(4));
        m_opsHash.put("containsDomain", new Integer(5));
        m_opsHash.put("getChildCount", new Integer(6));
        m_opsHash.put("insertParent", new Integer(7));
        m_opsHash.put("getChilds", new Integer(8));
        m_opsHash.put("deleteParent", new Integer(9));
        m_opsHash.put("deleteChild", new Integer(10));
        m_opsHash.put("getRootDomain", new Integer(11));
        m_opsHash.put("hasParent", new Integer(12));
        m_opsHash.put("get_effective_domain_policy", new Integer(13));
    }

    public String[] _all_interfaces(POA pOA, byte[] byArray) {
        return this.ids;
    }

    public OutputStream _invoke(String string, InputStream inputStream, ResponseHandler responseHandler) throws SystemException {
        OutputStream outputStream = null;
        Integer n = (Integer)m_opsHash.get(string);
        if (n == null) {
            throw new BAD_OPERATION(String.valueOf(string) + " not found");
        }
        switch (n) {
            case 0: {
                outputStream = responseHandler.createReply();
                outputStream.write_long(this.getParentCount());
                break;
            }
            case 1: {
                outputStream = responseHandler.createReply();
                DomainListHelper.write(outputStream, this.getParents());
                break;
            }
            case 2: {
                Domain domain = DomainHelper.read(inputStream);
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(this.hasChild(domain));
                break;
            }
            case 3: {
                try {
                    Domain domain = DomainHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.insertChild(domain);
                }
                catch (ClosesCycle closesCycle) {
                    outputStream = responseHandler.createExceptionReply();
                    ClosesCycleHelper.write(outputStream, closesCycle);
                }
                catch (NameAlreadyDefined nameAlreadyDefined) {
                    outputStream = responseHandler.createExceptionReply();
                    NameAlreadyDefinedHelper.write(outputStream, nameAlreadyDefined);
                }
                break;
            }
            case 4: {
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(this.isRoot());
                break;
            }
            case 5: {
                Domain domain = DomainHelper.read(inputStream);
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(this.containsDomain(domain));
                break;
            }
            case 6: {
                outputStream = responseHandler.createReply();
                outputStream.write_long(this.getChildCount());
                break;
            }
            case 7: {
                try {
                    Domain domain = DomainHelper.read(inputStream);
                    outputStream = responseHandler.createReply();
                    this.insertParent(domain);
                }
                catch (ClosesCycle closesCycle) {
                    outputStream = responseHandler.createExceptionReply();
                    ClosesCycleHelper.write(outputStream, closesCycle);
                }
                catch (NameAlreadyDefined nameAlreadyDefined) {
                    outputStream = responseHandler.createExceptionReply();
                    NameAlreadyDefinedHelper.write(outputStream, nameAlreadyDefined);
                }
                break;
            }
            case 8: {
                outputStream = responseHandler.createReply();
                DomainListHelper.write(outputStream, this.getChilds());
                break;
            }
            case 9: {
                Domain domain = DomainHelper.read(inputStream);
                outputStream = responseHandler.createReply();
                this.deleteParent(domain);
                break;
            }
            case 10: {
                Domain domain = DomainHelper.read(inputStream);
                outputStream = responseHandler.createReply();
                this.deleteChild(domain);
                break;
            }
            case 11: {
                outputStream = responseHandler.createReply();
                DomainHelper.write(outputStream, this.getRootDomain());
                break;
            }
            case 12: {
                Domain domain = DomainHelper.read(inputStream);
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(this.hasParent(domain));
                break;
            }
            case 13: {
                int n2 = inputStream.read_long();
                outputStream = responseHandler.createReply();
                PolicyHelper.write(outputStream, this.get_effective_domain_policy(n2));
                break;
            }
        }
        return outputStream;
    }

    public GraphNode _this() {
        return GraphNodeHelper.narrow(this._this_object());
    }

    public GraphNode _this(ORB oRB) {
        return GraphNodeHelper.narrow(this._this_object(oRB));
    }

    public abstract boolean containsDomain(Domain var1);

    public abstract void deleteChild(Domain var1);

    public abstract void deleteParent(Domain var1);

    public abstract int getChildCount();

    public abstract Domain[] getChilds();

    public abstract int getParentCount();

    public abstract Domain[] getParents();

    public abstract Domain getRootDomain();

    public abstract Policy get_effective_domain_policy(int var1);

    public abstract boolean hasChild(Domain var1);

    public abstract boolean hasParent(Domain var1);

    public abstract void insertChild(Domain var1) throws ClosesCycle, NameAlreadyDefined;

    public abstract void insertParent(Domain var1) throws ClosesCycle, NameAlreadyDefined;

    public abstract boolean isRoot();
}

