/*
 * Decompiled with CFR 0.152.
 */
package jacorb.orb.domain;

import jacorb.orb.domain.CacheEntry;
import jacorb.util.Environment;
import java.util.Hashtable;
import org.omg.CORBA.Policy;

public class PolicyCache {
    private Hashtable thePolicies = new Hashtable(10);

    public void clear() {
        this.thePolicies.clear();
    }

    public boolean isValid(int n) {
        Object v = this.thePolicies.get(new Integer(n));
        if (v == null) {
            return false;
        }
        CacheEntry cacheEntry = (CacheEntry)v;
        return System.currentTimeMillis() - cacheEntry.timestamp <= Environment.LifetimeOfCacheEntry();
    }

    public Policy read(int n) {
        Object v = this.thePolicies.get(new Integer(n));
        if (v == null) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)v;
        if (System.currentTimeMillis() - cacheEntry.timestamp > Environment.LifetimeOfCacheEntry()) {
            return null;
        }
        return cacheEntry.policy;
    }

    public void remove(int n) {
        this.thePolicies.remove(new Integer(n));
    }

    public void write(Policy policy) {
        this.thePolicies.put(new Integer(policy.policy_type()), new CacheEntry(policy, System.currentTimeMillis()));
    }
}

