/* EntryActionListener.java
 *
 * created: Mon Jan 31 2000
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 2000  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/components/EntryActionListener.java,v 1.1 2000/02/01 15:01:56 kmr Exp $
 */

package diana.components;

import diana.*;

import java.awt.event.*;

/**
 *  This class is an implementation of the ActionListener interface that can
 *  remember an entry.
 *
 *  @author Kim Rutherford
 *  @version $Id: EntryActionListener.java,v 1.1 2000/02/01 15:01:56 kmr Exp $
 **/

abstract public class EntryActionListener implements ActionListener {
  /**
   *  Make a new EntryActionListener from the given Entry.
   **/
  EntryActionListener (final EntryEdit entry_edit,
                       final Entry entry) {
    this.entry = entry;
    this.entry_edit = entry_edit;
  }

  abstract public void actionPerformed (final ActionEvent event);

  public Entry getEntry () {
    return entry;
  }

  public EntryEdit getEntryEdit () {
    return entry_edit;
  }

  final Entry entry;
  final EntryEdit entry_edit;
};

