/* FeatureDisplayOwner.java
 *
 * created: Tue Jul  6 1999
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 1999  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/components/FeatureDisplayOwner.java,v 1.4 1999/07/16 16:10:36 kmr Exp $
 */

package diana.components;

import diana.*;

/**
 *  An object that implements this interface can be passed to the
 *  FeatureDisplay constructor.  Objects of this class contain all the
 *  methods that the FeatureDisplay class needs to draw itself.
 *
 *  @author Kim Rutherford
 *  @version $Id: FeatureDisplayOwner.java,v 1.4 1999/07/16 16:10:36 kmr Exp $
 **/

public interface FeatureDisplayOwner {
  /**
   *  This method will call pack () on the Frame that owns the FeatureDisplay.
   **/
  public void packme ();
}
