/* KeyChooser.java
 *
 * created: Mon Sep  6 1999
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 1999  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/components/KeyChooser.java,v 1.2 2000/02/24 13:12:46 kmr Exp $
 */

package diana.components;

import diana.*;

import uk.ac.sanger.pathogens.embl.Key;
import uk.ac.sanger.pathogens.embl.EntryInformation;

import java.awt.*;
import java.awt.event.*;

/**
 *  This component is a KeyChoice component in a Frame (set addItemListener ()
 *  and removeItemListener () for details).
 *
 *  @author Kim Rutherford
 *  @version $Id: KeyChooser.java,v 1.2 2000/02/24 13:12:46 kmr Exp $
 **/

public class KeyChooser extends Frame {
  /**
   *  Create a new KeyChooser component with CDS as the default key.
   *  @param entry_information The object to get the list of possible
   *    keys from.
   **/
  public KeyChooser (final EntryInformation entry_information) {
    this (entry_information, Key.CDS);
  }

  /**
   *  Create a new KeyChooser component with the given key as the default.
   *  @param entry_information The object to get the list of possible
   *    keys from.
   **/
  public KeyChooser (final EntryInformation entry_information,
                     final Key default_key) {
    key_choice = new KeyChoice (entry_information, default_key);

    add (key_choice, "Center");

    final Panel panel = new Panel ();

    panel.add (ok_button);
    ok_button.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent e) {
        KeyChooser.this.dispose ();
      }
    });

    panel.add (close_button);
    close_button.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent e) {
        KeyChooser.this.dispose ();
      }
    });

    close_button.addActionListener (new ActionListener () {
      public void actionPerformed (ActionEvent e) {
        KeyChooser.this.dispose ();
      }
    });

    add (panel, "South");
    pack ();

    addWindowListener (new WindowAdapter () {
      public void windowClosing (WindowEvent event) {
        KeyChooser.this.dispose ();
      }
    });

    pack ();

    final Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    setLocation (new Point ((screen.width - getSize ().width) / 2,
                            (screen.height - getSize ().height) / 2));
  }

  /**
   *  Return the KeyChoice component that is displayed in this Frame.
   **/
  public KeyChoice getKeyChoice () {
    return key_choice;
  }

  /**
   *  Return the reference of the OK button of this KeyChooser.
   **/
  public Button getOKButton () {
    return ok_button;
  }

  private KeyChoice key_choice;

  final private Button ok_button = new Button ("OK");

  final private Button close_button = new Button ("Cancel");
}

