/* ComparisonDataFactory.java
 *
 * created: Thu Jul 15 1999
 *
 * This file is part of Artemis
 * 
 * Copyright (C) 1999  Genome Research Limited
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Header: /nfs/disk222/yeastpub/Repository/powmap/diana/ComparisonDataFactory.java,v 1.5 2000/06/05 12:34:54 kmr Exp $
 */

package diana;

import uk.ac.sanger.pathogens.*;
import uk.ac.sanger.pathogens.embl.LinePushBackReader;

import java.io.*;
import java.util.StringTokenizer;

/**
 *  This class contains the method readComparisonData (), which returns an
 *  appropriate ComparisonData object for a given Document.
 *
 *  @author Kim Rutherford
 *  @version $Id: ComparisonDataFactory.java,v 1.5 2000/06/05 12:34:54 kmr Exp $
 **/

public class ComparisonDataFactory {
  /**
   *  This method creates an appropriate ComparisonData object from a Document.
   **/
  static public ComparisonData readComparisonData (Document data_document)
      throws IOException {
    
    final Reader in_file = data_document.getReader ();

    final LinePushBackReader pushback_reader =
      new LinePushBackReader (in_file);

    final String line = pushback_reader.readLine ();

    if (line == null) {
      throw new IOException ("End of file while reading from: " +
                             data_document);
    }

    pushback_reader.pushBack (line);

    final StringTokenizer tokenizer = new StringTokenizer (line, " ");

//      if (tokenizer.countTokens () < 8) {
//        return new MUMmerComparisonData (pushback_reader);
//      } else {
      return new MSPcrunchComparisonData (pushback_reader);
//      }
  }
}

