/////////////////////////////////////////////////////////////////////////////
// File:            gnBaseHeader.h
// Purpose:         abstract Header class
// Description:     Provides an interface for Headers in memory and on disk.
// Changes:        
// Version:         libGenome 0.1.0 
// Author:          Aaron Darling 
// Last Edited:     April 15, 2001, 10:34:50pm 
// Modified by:     
// Copyright:       (c) Aaron Darling 
// Licenses:        Proprietary 
/////////////////////////////////////////////////////////////////////////////
#ifndef _gnBaseHeader_h_
#define _gnBaseHeader_h_

#include "gn/gnDefs.h"

#include <string>
#include "gn/gnClone.h"
#include "gn/gnLocation.h"

/**
 * This class provides a general interface to sequence related headers.
 * Headers commonly precede sequence data in several file formats.  In
 * FastA files, the header is on the > line before a contig.
 * In GenBank files, each contig has headers describing authors and other
 * information.  In GenBank files, the header name corresponds to the
 * name of the header field.  A few genBank header names are: DEFINITION
 * ACCESSION, VERSION, KEYWORDS, SEGMENT, SOURCE, REFERENCE, and COMMENT.
 * Eventually, individual classes may be implemented for each header type.
 */
class GNDLLEXPORT gnBaseHeader : public gnClone
{
public:
	gnBaseHeader(){}
	virtual ~gnBaseHeader(){}
	virtual gnBaseHeader* Clone() const = 0;
	/**
	 * Get the header.
	 * @return The header as a string.
	 */
	virtual string GetHeader() const = 0;
	/**
	 * Get the header's name, if any.
	 * @return The header name as a string.
	 */
	virtual string GetHeaderName() const = 0;	
	/**
	 * Get the header's length in bytes.
	 * @return The length of the header.
	 */
	virtual uint32 GetLength() const = 0;
private:
}; //class gnBaseHeader

#endif
	// _gnBaseHeader_h_
	
