/////////////////////////////////////////////////////////////////////////////
// File:            gnBaseQualifier.h
// Purpose:         abstract Qualifier class
// Description:     Provides an interface for Qualifiers in memory and on disk.
// Changes:        
// Version:         libGenome 0.1.0 
// Author:          Aaron Darling 
// Last Edited:     April 15, 2001, 10:34:50pm 
// Modified by:     
// Copyright:       (c) Aaron Darling 
// Licenses:        Proprietary 
/////////////////////////////////////////////////////////////////////////////
#ifndef _gnBaseQualifier_h_
#define _gnBaseQualifier_h_

#include "gn/gnDefs.h"

#include <string>
#include "gn/gnClone.h"

/**
 * gnBaseQualifier is a general interface to sequence qualifiers.
 * gnBaseFeature uses qualifiers to store annotated sequences.
 * Use gnStringQualifier for a general purpose qualifier class.
 */
class GNDLLEXPORT gnBaseQualifier : public gnClone
{
public:
	gnBaseQualifier(){}
	virtual ~gnBaseQualifier(){}
	virtual gnBaseQualifier* Clone() const = 0;
	/**
	 * Get the name of qualifier stored in this class.
	 * @return The qualifier name as a string.
	 */
	virtual string GetName() const = 0;
	/**
	 * Get the qualifier stored in this class.
	 * @return The qualifier as a string.
	 */
	virtual string GetValue() const = 0;
	
	/**
	 * Get the length of the qualifier name stored in this class.
	 * @return The length of the qualifier name.
	 */
	virtual uint32 GetNameLength() const = 0;
	/**
	 * Get the length of the qualifier stored in this class.
	 * @return The length of the qualifier.
	 */
	virtual uint32 GetValueLength() const = 0;
private:
}; //class gnBaseQualifier

#endif
	// _gnBaseQualifier_h_
	
