/////////////////////////////////////////////////////////////////////////////
// DataBase:        gnDataBaseSource.h
// Purpose:         Implements gnBaseSource for .DataBase files
// Description:     
// Changes:        
// Version:         libGenome 0.1.0 
// Author:          Aaron Darling 
// Last Edited:     April 15, 2001, 10:34:50pm 
// Modified by:     
// Copyright:       (c) Aaron Darling 
// Licenses:        Proprietary 
/////////////////////////////////////////////////////////////////////////////
#ifndef _gnDataBaseSource_h_
#define _gnDataBaseSource_h_

#include "gn/gnDefs.h"

#include <string>
#include "gnBaseSource.h"

/**
 * Not yet implemented.
 */
class gnDataBaseSource : public gnBaseSource
{
public:
	virtual ~gnDataBaseSourcee(){}

	virtual gnDataBaseSource* Clone() const = 0;

	virtual gnBaseSource* Clone() const = 0;

	virtual boolean Open( string openString ) = 0;
	virtual boolean Open() = 0;
	virtual boolean Close() = 0;
	virtual string GetOpenString() const = 0;
	virtual uint32 GetContigListLength() const = 0;
	virtual boolean HasContig( const string& name ) const = 0;
	virtual uint32 GetContigID( const string& name ) const = 0;
	virtual string GetContigName( const uint32 i ) const = 0;
	virtual gnSeqI GetContigSeqLength( const uint32 i ) const = 0;
	virtual const gnFilter* GetFilter() const = 0;
	virtual boolean SetFilter( gnFilter* pFilter ) = 0;
	virtual boolean Read( const uint64 pos, char* buf, uint32& len) = 0;
	virtual boolean SeqRead( const gnSeqI start, char* buf, uint32& bufLen, const uint32 contigI=ALL_CONTIGS ) = 0;
	virtual gnGenomeSpec *GetSpec() const = 0;
private:
	gnDataBaseSource(){}
};// class gnDataBaseSource

#endif
	// _gnDataBaseSource_h_
