/////////////////////////////////////////////////////////////////////////////
// File:            gnFileSource.h
// Purpose:         Implements gnBaseSource for .File files
// Description:     
// Changes:        
// Version:         libGenome 0.1.0 
// Author:          Aaron Darling 
// Last Edited:     April 15, 2001, 10:34:50pm 
// Modified by:     
// Copyright:       (c) Aaron Darling 
// Licenses:        Proprietary 
/////////////////////////////////////////////////////////////////////////////
#ifndef _gnFileSource_h_
#define _gnFileSource_h_

#include "gn/gnDefs.h"

#include <string>
#include <fstream>
#include "gn/gnBaseSource.h"
#include "gn/gnFileContig.h"
#include "gn/gnException.h"

/**
 * gnFileSource is a standard interface to all file based sources of genetic information.
 * All file source classes are derived from this class.
 */
class GNDLLEXPORT gnFileSource : public gnBaseSource
{
public:
	gnFileSource(){}
	gnFileSource(const gnFileSource& gnfs);
	virtual ~gnFileSource(){}
	virtual gnFileSource* Clone() const = 0;
	// Open, Close	
	virtual void Open( string openString );
	virtual void Open();
	virtual void Close();
	virtual string GetOpenString() const ;
	  // Filter
	virtual const gnFilter* GetFilter() const ;
	virtual void SetFilter( gnFilter* filter );

	virtual boolean Read( const uint64 pos, char* buf, uint32& bufLen );
	/**
	 * Returns a pointer to the file contig corresponding to contigI or
	 * null if none exists.
	 */
	virtual gnFileContig* GetFileContig( const uint32 contigI ) const = 0;
protected:
	string m_openString;
	ifstream m_ifstream;
	const gnFilter* m_pFilter;
	gnNewlineType m_newlineType;
	uint32 m_newlineSize;
private:
	virtual boolean ParseStream( istream& fin ) = 0;
};// class gnFileSource

inline
string gnFileSource::GetOpenString( ) const
{
	return m_openString;
}
// Filter
inline
const gnFilter* gnFileSource::GetFilter() const
{
	return m_pFilter;
}

inline
void gnFileSource::SetFilter( gnFilter* filter )
{
	if(filter == NULL){
		Throw_gnEx(NullPointer());
	}
	m_pFilter = filter;
}

#endif
	// _gnFileSource_h_
