/////////////////////////////////////////////////////////////////////////////
// File:            gnPosSpecificTranslator.h
// Purpose:         Special case ORF translation
// Description:     Used to translate sequences differently based on the position of
//					input characters.  Useful for tranlating genes because the first
//					codon is translated differently
// Changes:        
// Version:         libGenome 0.1.0 
// Author:          Aaron Darling 
// Last Edited:     March 18, 2001, 10:34:50pm 
// Modified by:     
// Copyright:       (c) Aaron Darling 
// Licenses:        Proprietary 
/////////////////////////////////////////////////////////////////////////////
#ifndef _gnPosSpecificTranslator_h_
#define _gnPosSpecificTranslator_h_


#include "gn/gnDefs.h"

#include <string>
#include <vector>
#include <map>
#include "gn/gnClone.h"
#include "gn/gnBaseFilter.h"
#include "gn/gnFastTranslator.h"

/** 
 * Used to translate sequences differently based on the position of
 * input characters.  Useful for tranlating genes because the first
 * codon is translated differently.
 */
class GNDLLEXPORT gnPosSpecificTranslator : public gnBaseFilter
{
public:

	static const gnPosSpecificTranslator *ProteinDNATranslator();
	static const gnPosSpecificTranslator *DNAProteinTranslator();

	enum gnTranslatorType{
		ProteinDNATranslatorType,
		DNAProteinTranslatorType,
	};

	gnPosSpecificTranslator();
	gnPosSpecificTranslator( gnTranslatorType t_type );
	gnPosSpecificTranslator( const gnPosSpecificTranslator& sf );
	gnPosSpecificTranslator& operator= (const gnPosSpecificTranslator& sf);
	gnPosSpecificTranslator* Clone() const;
	

	// gnSeqC 
	virtual gnSeqC Filter( const gnSeqC ch ) const;

	virtual void Filter( gnSeqC** seq, uint32& len ) const;
	// string
	virtual void Filter( string &seq ) const;

private:
	gnTranslatorType m_type;	// defines the type of translator this is
	const gnBaseFilter* filter;		// this is the filter used to do the translation
	void CreateProteinDNATranslator();
	void CreateDNAProteinTranslator();

};//class gnPosSpecificTranslator

inline
gnPosSpecificTranslator* gnPosSpecificTranslator::Clone() const
{
	return new gnPosSpecificTranslator(*this);
}

#endif // _gnPosSpecificTranslator_h_
