/////////////////////////////////////////////////////////////////////////////
// File:            gn/gnSetup.h
// Purpose:         libGenome setup
// Description:     Defines os/compiler specific constants, etc.
//                  Included in gn/gnDefs.h.
// Rev:             A
// Author:          Aaron Darling 
// Last Edited:     April 15, 2001, 10:34:50pm 
// Modified by:     
// Copyright:       (c) Aaron Darling 
// Licenses:        
 
/////////////////////////////////////////////////////////////////////////////
#ifndef _gnSetup_h_
#define _gnSetup_h_

#include <stdlib.h>
using namespace std; 	//introduces namespace std

#ifdef GN_GUI
#include "wx/wx_cw_d.h"
#endif

#ifdef GNMAKINGDLL   // build the libgenome dll
#define GNDLLEXPORT __declspec(dllexport)
#define GNDLLEXPORT_DATA(type) __declspec(dllexport) type
#elif defined(GNUSINGDLL)  
// the project uses a libGenome as a dll
#define GNDLLEXPORT __declspec(dllimport)
#define GNDLLEXPORT_DATA(type) __declspec(dllimport) type
#else	// static linking
#define GNDLLEXPORT
#define GNDLLEXPORT_DATA
#endif

#endif
	//_gnSetup_h_
