/////////////////////////////////////////////////////////////////////////////
// File:            gnStringTools.h
// Purpose:         Random string manipulation tools
// Description:     Random string manipulation tools
// Changes:        
// Version:         libGenome 0.1.0 
// Author:          Aaron Darling 
// Last Edited:     April 15, 2001, 10:34:50pm 
// Modified by:     
// Copyright:       (c) Aaron Darling 
// Licenses:        Proprietary 
/////////////////////////////////////////////////////////////////////////////

#ifndef _gnStringTools_h_
#define _gnStringTools_h_

#include <iostream>
#include <string>
#include <vector>
#include <stdlib.h>
#include <stdio.h>
#include "gn/gnDefs.h"

unsigned int removeSpace(string &str);
void removeEndSpace(string &str);

bool isNewLine(char ch);
bool isWhiteSpace(char ch);
bool isSpace(char ch);

string uintToString(unsigned int value);

string ulongToString(unsigned long value);

string charArrayToString( char *charArray, unsigned int length);

bool isBase(char base);
void BaseCount(const string& bases, gnSeqI& a_count, gnSeqI& c_count, gnSeqI& g_count, gnSeqI& t_count, gnSeqI& other_count);

unsigned int parseValue(string &valueString);
int parseUintValue(string &valueString);
int parseIntValue(string &valueString);

vector< string > tokenizeString( const string &str, char delimiter  = '\t' );
vector< string > tokenizeString( const char* str, unsigned int len, char delimiter = '\t' );

// **** MAKE SURE YOU STANDARIZE ALL PATHS ****
void standarizePathString( string &oFileName );

// **** ONLY '/' IS USED for file seperation on all below functions ****

// make more robust to handle dir and files
string getPathString( string oFileName );
// look for '/' at end
string getFileString( string oFileName );
// look for '/' before '.'
string getExtString( string oFileName );
// look for '/' before '.'
string getFileNoExtString( string oFileName );

#endif
// gnStringTools_h
