;;; gb2jis.el -- Mule's interface for gb2jis by Kenichi Handa
(defvar gb2jis-program "gb2jis")
(defvar gb2jis-arg-list '("-j"))

(define-program-coding-system nil gb2jis-program '*junet*)

(defun gb2jis-region (from to)
  "Convert Chinese text (GB) in the region FROM and TO to Japanese (JIS).
The conversion is done by outernal program `gb2jis'."
  (interactive "r")
  (apply 'call-process-region from to gb2jis-program t t t gb2jis-arg-list))

(defun gb2jis-buffer ()
  "Convert Chinese text (GB) in the current buffer to Japanese (JIS).
The conversion is done by outernal program `gb2jis'."
  (interactive)
  (gb2jis-region (point-min) (point-max)))
