// EmailAttach.cpp

#include <mimepp/mimepp.h>
#include "EmailAttach.h"


EmailAttachment::EmailAttachment()
{
}


EmailAttachment::EmailAttachment(const EmailAttachment& aAttach)
  : mType(aAttach.mType),
    mSubtype(aAttach.mSubtype),
    mFileName(aAttach.mFileName),
    mDescription(aAttach.mDescription),
    mContent(aAttach.mContent)
{
}


EmailAttachment::~EmailAttachment()
{
}


EmailAttachment& EmailAttachment::operator=(const EmailAttachment& aAttach)
{
    if (this != &aAttach) {
        mFileName    = aAttach.mFileName;
        mType        = aAttach.mType;
        mSubtype     = aAttach.mSubtype;
        mDescription = aAttach.mDescription;
        mContent     = aAttach.mContent;
    }
    return *this;
}


const string& EmailAttachment::Type() const
{
    return mType;
}

 
const string& EmailAttachment::Subtype() const
{
    return mSubtype;
}


void EmailAttachment::MediaType(const string& aType, const string& aSubtype)
{
    mType = aType;
    mSubtype = aSubtype;
}

const string& EmailAttachment::Charset() const
{
    return mCharset;
}


void EmailAttachment::Charset(const string& aCharset)
{
    mCharset = aCharset;
}


int EmailAttachment::Size() const
{
    return mContent.size();
}


const string& EmailAttachment::FileName() const
{
    return mFileName;
}


void EmailAttachment::FileName(const string& aName)
{
    mFileName = aName;
}


const string& EmailAttachment::Description() const
{
    return mDescription;
}


void EmailAttachment::Description(const string& aDesc)
{
    mDescription = aDesc;
}


const DwString& EmailAttachment::Content() const
{
    return mContent;
}


void EmailAttachment::Content(const DwString& aStr)
{
    mContent = aStr;
}
