// EmailDate.cpp

#include <time.h>
#include <mimepp/mimepp.h>
#include "EmailDate.h"


EmailDate::EmailDate()
{
    // The DwDateTime class has code to figure out the time zone.
    // We can reuse that code.

    DwDateTime date;

    mYear = date.Year();
    mMonth = date.Month();
    mDay = date.Day();
    mHour = date.Hour();
    mMinute = date.Minute();
    mSecond = date.Second();
    mZone = date.Zone();
}


EmailDate::EmailDate(const EmailDate& aDate)
{
    mYear = aDate.mYear;
    mMonth = aDate.mMonth;
    mDay = aDate.mDay;
    mHour = aDate.mHour;
    mMinute = aDate.mMinute;
    mSecond = aDate.mSecond;
    mZone = aDate.mZone;
}


EmailDate::~EmailDate()
{
}



EmailDate& EmailDate::operator = (const EmailDate& aDate)
{
    if (this != &aDate) {
        mYear = aDate.mYear;
        mMonth = aDate.mMonth;
        mDay = aDate.mDay;
        mHour = aDate.mHour;
        mMinute = aDate.mMinute;
        mSecond = aDate.mSecond;
        mZone = aDate.mZone;
    }
    return *this;
}


void EmailDate::SetValues(int aYear, int aMonth, int aDay, int aHour,
    int aMinute, int aSecond)
{
    // The DwDateTime class has code to figure out the time zone.
    // We can reuse that code.

    DwDateTime date;
    date.SetValuesLocal(aYear, aMonth, aDay, aHour, aMinute, aSecond);

    mYear = date.Year();
    mMonth = date.Month();
    mDay = date.Day();
    mHour = date.Hour();
    mMinute = date.Minute();
    mSecond = date.Second();
    mZone = date.Zone();
}


void EmailDate::SetValues(int aYear, int aMonth, int aDay, int aHour,
    int aMinute, int aSecond, int aZone)
{
    mYear = aYear;
    mMonth = aMonth;
    mDay = aDay;
    mHour = aHour;
    mMinute = aMinute;
    mSecond = aSecond;
    mZone = aZone;
}


void EmailDate::SetCurrent()
{
    *this = EmailDate();
}


const string& EmailDate::DisplayString() const
{
    char scratch[100];
    struct tm stime;

    stime.tm_year = mYear - 1900;
    stime.tm_mon = mMonth - 1;
    stime.tm_mday = mDay;
    stime.tm_hour = mHour;
    stime.tm_min = mMinute;
    stime.tm_sec = mSecond;
	mktime(&stime);
    strftime(scratch, sizeof(scratch), "%a, %d %b %Y", &stime);
    mString = scratch;
    return mString;
}
