// email.h -- Basic facade class for human to human email

#ifndef EMAILMESSAGE_H
#define EMAILMESSAGE_H

#include <vector>
#include <mimepp/mimepp.h>
#include "EmailDate.h"
#include "EmailAttach.h"
#include "EmailAttachList.h"
#include "EmailAddress.h"
#include "EmailAddressList.h"
#include "EmailText.h"

//typedef std::vector<EmailAddress*> EmailAddressList;
//typedef std::vector<EmailAttachment*> EmailAttachmentList;


class EmailMessage {

public:

    EmailMessage();

    virtual ~EmailMessage();

    void ParseFrom(const DwString& aMessageString);
    void SerializeTo(DwString& aMessageString);

    const EmailAddress& Originator();
    void Originator(const EmailAddress&);

    EmailAddressList& ToRecipients() { return mToRecipients; }
    EmailAddressList& CcRecipients() { return mCcRecipients; }
    EmailAddressList& BccRecipients() { return mBccRecipients; }

    const EmailText& Subject();
    void Subject(const EmailText&);

    const EmailDate& Date();
    void Date(const EmailDate&);

    const EmailText& MemoText();
    void MemoText(const EmailText&);

    EmailAttachmentList& Attachments() { return mAttachments; }

protected:

    EmailDate mDate;
    EmailAddress mOriginator;
    EmailAddressList mToRecipients;
    EmailAddressList mCcRecipients;
    EmailAddressList mBccRecipients;
    EmailText mSubject;
    EmailText mMemoText;
    EmailAttachmentList mAttachments;

    virtual void ParseOriginator(DwMessage& message, EmailAddress& address);
    virtual void ParseRecipients(DwMessage& message, const string& which,
        EmailAddressList& addresses);
    virtual void ParseSubject(DwMessage& message, EmailText& subject);
    virtual void ParseMemoText(DwMessage& message, EmailText& memoText);
    virtual void ParseAttachments(DwMessage& message,
        EmailAttachmentList& list);

    virtual void ParseMemoText_Text(DwMessage& message,
        EmailText& text);
    virtual void ParseMemoText_Message(DwMessage& message,
        EmailText& text);
    virtual void ParseMemoText_Multipart(DwMessage& message,
        EmailText& text);

    virtual void ParseAttachments_Simple(DwMessage& message,
        EmailAttachmentList& list);
    virtual void ParseAttachments_Message(DwMessage& message,
        EmailAttachmentList& list);
    virtual void ParseAttachments_Multipart(DwMessage& message,
        EmailAttachmentList& list);
};

#endif
