// EmailAddressList.h

#ifndef EMAIL_ADDRESS_LIST_H
#define EMAIL_ADDRESS_LIST_H

#include <vector>
#include "EmailAddress.h"


class EmailAddressList
{

public:

    EmailAddressList();
    EmailAddressList(const EmailAddressList&);
    virtual ~EmailAddressList();

    EmailAddressList& operator = (const EmailAddressList&);

    void Add(const EmailAddress& addr);

    int Count() const;
    const EmailAddress& Get(int index) const;

private:

    std::vector<EmailAddress*> mAddresses;

    void _DeleteAddresses();
    void _CopyAddresses(const EmailAddressList&);

};

#endif
