// EmailAttach.h

#ifndef EMAIL_ATTACH_H
#define EMAIL_ATTACH_H

#include <string>
#include <mimepp/mimepp.h>

using std::string;


class EmailAttachment {

public:

    EmailAttachment();
    EmailAttachment(const EmailAttachment&);

    ~EmailAttachment();

    EmailAttachment& operator = (const EmailAttachment&);

    const string& Type() const;
    const string& Subtype() const;
    void MediaType(const string& type, const string& subtype);

    const string& Charset() const;
    void Charset(const string& charset);

    int Size() const;

    const string& FileName() const;
    void FileName(const string& name);

    // to do: Description should probably be EmailText, so that we can
    // also specify the charset

    const string& Description() const;
    void Description(const string& desc);

    const DwString& Content() const;
    void Content(const DwString& buffer);

private:

    string mType;
    string mSubtype;
    string mCharset;
    string mFileName;
    string mDescription;
    DwString mContent;

};

#endif
