#!/usr/bin/perl
#********************************************************************
#
#  term.pl :  This script computes the number of interest periods or
#             months left for a loan given the Amount-Owed, 
#             Interest-Rate and Monthly-Payment.
#
#  G. K. Fenton  1/1997
#
#********************************************************************
#
# Definitions of main variables...
#   $amt_owed = Total amount left to pay on loan.
#   $I        = Interest Rate divided by 12 for units of Months then
#               divided by 100 to put into a percentage format.
#   $payment  = Monthly payment of existing loan.
#
#   $term     = Number of Monthly payments to go...
#
#********************************************************************
#
# $Id: term.pl,v 1.1.1.1 1999/12/18 02:06:10 curt Exp $
# (Log is kept at end of this file)
#



#  Process the Command Line Arguments
# print @ARGV,"\n";
# print $#ARGV+1,"\n";

  if ($#ARGV+1 < 6) {
     print "\n\n term.pl :  This script computes the number of interest periods Left to Pay.\n\n";
     print " Usage: term.pl [-a <amount>] [-i <int_rate>] [-p <payment>]\n\n";
     print "\n Example: term.pl -a 100000 -i 7.0 -p 871.00\n\n";
     print " Where,  -a --> Amount left to pay on Loan.\n";
     print "         -i --> Annual Interest Percentage Rate.\n";
     print "         -p --> Monthly payment of Loan.\n\n";
     exit(1);
  } 


  $i = 0;
  foreach (@ARGV) {
     if ($ARGV[$i] eq "-a") {  # Get the Amount Left to Pay.
        $amt_owed = $ARGV[$i+1];
     }
     if ($ARGV[$i] eq "-i") {  # Get the Annual Interest Rate.
        $I = $ARGV[$i+1];
        $I = $I/12.0/100.0;    # Put into Monthly percentage Units.
     }
     if ($ARGV[$i] eq "-p") {  # Get the Monthly Payment.
        $payment = $ARGV[$i+1];
     } 
     $i++;
  }

  $tmp_var0  = $I*(1.0 + $I)*$amt_owed/$payment; 
  if ($tmp_var0 > 1.0) {
    $tmp_var0  = $I*(1.0 + $I)*$amt_owed; 
    print "\n\n  WARNING:  You will never get out DEBT\n";
    print "            with this size of Payment!!!\n\n";
    print "   Your Payment needs to be greater than: \$$payment\/Month\n\n";
    printf("   Try Paying at least  \$%7.2f\/month\n", $tmp_var0);
    print "   And be Prepared for a long life of PAYMENTS...\n\n";

    $tmp_var1  = log($I);
    $tmp_var2  = log(1.0 + $I);

    $term      = -1.0*$tmp_var1/$tmp_var2;
    printf("\n Time with suggested payment = %4.0f Months\n\n", $term);

    exit(0);
  }

  $tmp_var1  = log(1.0 - $tmp_var0 + $I);
  $tmp_var2  = log(1.0 + $I);

  $term      = -1.0*$tmp_var1/$tmp_var2;

  printf("\n Time Left to Pay on Existing Loan = %4.0f Months\n\n", $term);


  exit(0);


# ----------------------------------------------------------------------------
# $Log: term.pl,v $
# Revision 1.1.1.1  1999/12/18 02:06:10  curt
# Start of 0.8 branch
#
# Revision 1.1  1999/12/17 19:21:02  curt
# Added to repository.
#
# Revision 2.2  1997/01/16 03:29:15  curt
# Check to see if the payment is too small and makes a suggestion
# to a workable minimum payment.
#
# Revision 2.1  1997/01/10 19:05:10  curt
# Initial revision.
#

