#!wish8.2 -f
#  'CBB' -- Check Book Balancer
#
#   undo.tcl -- Undo routines.
#
#  Written by Curtis Olson.  Started December 7, 1996.
#
#  Copyright (C) 1994 - 1999  Curtis L. Olson  - curt@me.umn.edu
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# $Id: undo.tcl,v 1.1.1.1 1999/12/18 02:05:32 curt Exp $


#------------------------------------------------------------------------------
# Procedures to handle undo functionality
#------------------------------------------------------------------------------

proc undoInit {} {
    global undo

    set undo(command) ""
    set undo(data) ""
}

proc undoRegister arg {
    global undo

    set pos [string first " " $arg]
    set undo(command) [string range $arg 0 [expr $pos - 1]]
    set undo(data) [string range $arg [expr $pos + 1] end]
}

proc undoAction {} {
    global cbb key eng undo

    if { $cbb(debug) } { puts "un$undo(command) $undo(data)" }

    if { "$undo(command)" == "delete" } {
    	# reinsert

        update_globals $undo(data)
        set key ""
        done_entering
    } elseif { "$undo(command)" == "insert" } {
        # delete

    	set pos [string first "\t" $undo(data)]
        set key [string range $undo(data) 0 [expr $pos - 1]]

        puts $eng "delete_trans $key"; flush $eng
        gets $eng result
        if { $cbb(debug) } { puts "deleting:  $result" }

        set cbb(index1) [find_index_from_key [listGetSize] $key]
        if { [expr $cbb(index1) < 0] } {
            set cbb(index1) 0
        }
        update_rest $cbb(index1) $key
    } elseif { "$undo(command)" == "edit" } {
        # change back

	set newkey [string range $undo(data) 0 10]
	if { $cbb(debug) } { puts "first need to delete $newkey" }
	puts $eng "delete_trans $newkey"; flush $eng
	gets $eng result
	if { $cbb(debug) } { puts "deleting:  $result" }

	set cbb(index1) [find_index_from_key [listGetSize] $newkey]
	if { [expr $cbb(index1) < 0] } {
	    set cbb(index1) 0
	}
	update_rest $cbb(index1) $newkey

	if { $cbb(debug) } {
	    puts "-> [string range $undo(data) 12 end]"
	}

        update_globals [string range $undo(data) 12 end]
        done_entering
    } else {
        cbbWindow.ok "Nothing to undo  :-("
        tkwait window .ok
    }

    undoInit
    clear_entry_area
}
