#!/usr/bin/ruby

# б (Ruby)
# Atsushi YAMAMOTO <yamamoto@graco.c.u-tokyo.ac.jp>
# Copyright (c) 2001-2003 Atsushi YAMAMOTO. All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# on condition that redistributions contain above copyright notice.
# This program is provided ``AS IS'' and there are NO WARRANTY.

$DIR,$PRG = $1, $2
$PRG = File.basename(__FILE__)
$DIR = File.dirname(__FILE__)
Dir::chdir($DIR)
require 'Calendar.rb'
require 'getopts'
getopts("ngjosh")
Version = 1.13
Author='Atsushi YAMAMOTO <yamamoto@graco.c.u-tokyo.ac.jp>'
Web='http://aglaia.c.u-tokyo.ac.jp/~yamamoto/Script/Calendar/'
Prgname='б(Ruby)'

if ARGV.empty?
  month = Time::now.month
  year = Time::now.year
elsif ARGV.length == 1
  month = ARGV[0].to_i
  unless month > 0 and month < 13
    raise "ʷ: 1-12 ȤäƤ\n"
  end
  year = Time::now.year
  if month < Time::now.month
    year += 1
  end
elsif ARGV.length == 2
  month = ARGV[0].to_i
  year = ARGV[1].to_i
  unless month > 0 and month < 13
    raise "ʷ: 1-12 ȤäƤ\n"
  end
  unless year > 0 and year < 9999
    raise "ǯ: 1-9999 ȤäƤ"
  end
else
  raise "#{$PRG} [ץ] [ [ǯ]]"
end
def print_help
  print <<"USAGE"

 #{Prgname} #{Version}
  usage: #{$PRG} [ץ] [ [ǯ]]

  -n ʸ⡼
  -s ɸcalߴ⡼
  -j ⡼(-g/-o)
  -h 

 
 ʬʬϡ1900ǯ2099ǯޤǤбǤ
 1ưɸcalȤϰۤʤޤ
 1ǯΤΥϽФޤ(ݤʤΤ)
 ʸˤʤˤ-nץǤƲʤɤ
 Ҥɬפʤˤ-sɸcalߴ⡼ɤˤʤޤ
 
 #{Author}
 #{Web}

USAGE
end

if $OPT_h
  print_help()
  exit()
end

if $OPT_j
  month_class = Month_jp
  week_class = Week_jp
elsif $OPT_o
  month_class = Month_jp_old
  week_class = Week_jp
elsif $OPT_g
  month_class = Month_jp_eraname
  week_class = Week_jp
else
  month_class = Month
  week_class = Week
end

if $OPT_n
  puts month_class.new(month, year, "long", week_class).to_s
elsif $OPT_s
  puts month_class.new(month, year, "normal", week_class).to_s
else
  puts month_class.new(month, year, "color", week_class).to_s
end
