<?php
  /**************************************************************************\
  * phpGroupWare - phpgw_dj                                                  *
  * http://www.phpgroupware.org                                              *
  * Written by Miles Lott <milosch@phpgroupware.org>                         *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: import.php,v 1.8 2001/05/11 17:59:59 milosch Exp $ */

	$phpgw_info['flags'] = array(
		'currentapp'           => 'dj',
		'enable_browser_class' => True
	);
	include('../header.inc.php');

	$sep = SEP;

	function _debug($s)
	{
	 	global $debug;
		if ($debug)
		{
		 	echo '<br>' . $s;
		}
	}

	if (!$convert)
	{
		$t = new Template($phpgw_info['server']['app_tpl']);
		$t->set_file(array('import' => 'import.tpl'));

		$t->set_var('lang_cancel',lang('Cancel'));
		$t->set_var('lang_cat',lang('Select Category'));
		$t->set_var('cancel_url',$phpgw->link('/dj/index.php'));
		$t->set_var('navbar_bg',$phpgw_info['theme']['navbar_bg']);
		$t->set_var('navbar_text',$phpgw_info['theme']['navbar_text']);
		$t->set_var('import_text',lang('import file list'));
		$t->set_var('action_url',$phpgw->link('/dj/import.php'));
		$t->set_var('tsvfilename','');
		$t->set_var('conv',$conv);
		$t->set_var('debug',lang('Debug output in browser'));
		$t->set_var('download',lang('Submit'));
		$t->set_var('start',$start);
		$t->set_var('sort',$sort);
		$t->set_var('order',$order);
		$t->set_var('filter',$filter);
		$t->set_var('query',$query);
		$t->set_var('cat_id',$cat_id);
		$t->pparse('out','import');
		$phpgw->common->phpgw_footer();
	}
	else
	{
		$cats = CreateObject('phpgwapi.categories');
		$fp = fopen($tsvfile,'r');
		$num = 0;
		while ($data = fgets($fp,8000))
		{
			$buffer .= $data;
			$mp3info = get_info($data);

			$mp3info->title = $mp3info->name;

			if (!$mp3info->title)
			{
				$ta = explode('/',$data);
				$_title = $ta[count($ta)-1];
				$_title = ereg_replace('.mp3','',$_title);
				$_title = ereg_replace('.MP3','',$_title);
				$_title = urldecode($_title);
				$mp3info->title = $_title;
				unset($ta);
				unset($title);
			}

			$mp3info->descr = $mp3info->genre .' (#'. $mp3info->genreno .')';

			if(!$cats->exists('mains',$mp3info->genre))
			{
				$cats->add($mp3info->genre,$mp3info->genre,$mp3info->descr,'','public','');
			}

			_debug('name: ' . $mp3info->name);
			_debug('title: ' . $mp3info->title);
			_debug('data:' . $data . '<p>');

			add_song($mp3info);

			$num++;
		}

		fclose($fp);

		if ($debug)
		{
			echo "<pre>$buffer</pre>";
			echo '<a href="'.$phpgw->link("/dj/index.php",
				"sort=$sort&order=$order&filter=$filter&start=$start&query=$query&cat_id=$cat_id")
				. '">'.lang("OK").'</a>';
			$phpgw->common->phpgw_footer();
		}
		else
		{
			echo '<a href="'.$phpgw->link("/dj/index.php",
				"sort=$sort&order=$order&filter=$filter&start=$start&query=$query&cat_id=$cat_id")
				. '">'.lang("OK").'</a>';
			//echo "<br>" . lang('Successfully imported x records',$num);
			if($num)
			{
				echo "<br>Successfully imported $num records\n";
			}
			else
			{
				echo "<br>No new files\n";
			}

			$phpgw->common->phpgw_footer();
		}
	}
?>
