<?php
  /**************************************************************************\
  * phpGroupWare - Shopping cart                                             *
  * http://www.phpgroupware.org                                              *
  * Written by Bettina Gille [ceb@phpgroupware.org]                          *
  * -----------------------------------------------                          *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/
  /* $Id: list_products.php,v 1.2 2001/05/10 22:06:58 bettina Exp $ */
  
    $phpgw_info["flags"] = array('currentapp' => 'cart',
		    'enable_nextmatchs_class' => True);

    include('../header.inc.php');

    $t = new Template(PHPGW_APP_TPL);
    $t->set_file(array('listproducts_t' => 'list_products.tpl',
                        'listproducts'  => 'list_products.tpl'));

    $t->set_block('listproducts_t','listproducts','list');

    $inventory = CreateObject('inv.inventory');
    $c = CreateObject('phpgwapi.categories');
    $c->app_name = 'inv';
    $grants = $phpgw->acl->get_grants('cart');

    if (isset($phpgw_info['user']['preferences']['common']['currency'])) 
    {
	$currency = $phpgw_info['user']['preferences']['common']['currency'];
	$t->set_var('error','');
    }
    else 
    {
	$t->set_var('error',lang('Please select your currency in preferences !'));
    }

    $archive_id = $inventory->get_status_id('archive');

    if (!$start) 
    { 
	$start = '0'; 
    }

    if ($query) 
    { 
	$querymethod = " AND (name like '%$query%' OR descr like '%$query%' OR id like '%$query%') "; 
    }

    if ($cat_id)
    {
	$filter = $cat_id;
    }

    if (! $filter) 
    {
	$phpgw->db->query("SELECT category from phpgw_inv_products WHERE status != '$archive_id' $querymethod");    
	$phpgw->db->next_record();
	$category = $c->return_single($phpgw->db->f('category'));
	if ($category)
	{
	    if ($inventory->check_perms($grants[$category[0]['owner']],PHPGW_ACL_READ) || $category[0]['owner'] == $phpgw_info['user']['account_id']) 
	    {
		$filter = $phpgw->db->f('category');
	    }
    	}
	else 
	{ 
	    $filter = '999'; 
	}
    }
    else 
    { 
	$category = $c->return_single($filter); 
    }

    if($phpgw_info['user']['preferences']['common']['maxmatchs'] && $phpgw_info['user']['preferences']['common']['maxmatchs'] > 0) 
    {
	$limit = $phpgw_info['user']['preferences']['common']['maxmatchs'];
    }
    else 
    { 
	$limit = '15'; 
    }

    $products = $inventory->read_products($start,$limit,$query,'category',$filter,$sort,$order,'active');

//--------------------------------- nextmatch --------------------------------------------

    $left = $phpgw->nextmatchs->left('/cart/list_products.php',$start,$inventory->total_records);
    $right = $phpgw->nextmatchs->right('/cart/list_products.php',$start,$inventory->total_records);
    $t->set_var('left',$left);
    $t->set_var('right',$right);

    if ($query) 
    {
	if ($inventory->total_records == 0) 
	{  
	    $t->set_var('lang_showing',lang('Your search has returned no matchs !')); 
	}
        else 
	{ 
	    $t->set_var('lang_showing',lang('showing x',$inventory->total_records)); 
	}
    }
    else 
    {
	if ($inventory->total_records > $limit) 
	{ 
	    $t->set_var('lang_showing',lang('showing x - x of x',($start + 1),($start + $limit),$inventory->total_records)); 
	}
	else 
	{ 
	    $t->set_var('lang_showing',lang('showing x',$inventory->total_records)); 
	}
    }

// ------------------------------ end nextmatch ------------------------------------------

//---------------------------- list variable template-declarations -------------------------

    $t->set_var('th_bg',$phpgw_info['theme']['th_bg']);
    $t->set_var('sort_id',$phpgw->nextmatchs->show_sort_order($sort,'id',$order,'/cart/list_products.php',lang('Product ID')));
    $t->set_var('sort_name',$phpgw->nextmatchs->show_sort_order($sort,'name',$order,'/cart/list_products.php',lang('Name')));
    $t->set_var('sort_price',$phpgw->nextmatchs->show_sort_order($sort,'price',$order,'/cart/list_products.php',lang('Price')));
    $t->set_var('sort_retail',$phpgw->nextmatchs->show_sort_order($sort,'retail',$order,'/cart/list_products.php',lang('Retail')));
    $t->set_var('lang_view',lang('View'));
    $t->set_var('currency',$currency);
    $t->set_var('search_action',$phpgw->link('/cart/list_products.php'));
    $t->set_var('lang_search',lang('Search'));
    $t->set_var('category_list',$c->formated_list('list','all',$filter,False,'/cart/list_products.php'));
    $t->set_var('lang_submit',lang('Submit'));

// -------------------------------- end declaration -----------------------------------------

    $taxpercent = select_tax($filter);
    for ($i=0;$i<count($products);$i++) 
    {

	$phpgw->templater_color = $phpgw->nextmatchs->alternate_row_color($phpgw->templater_color);
	$t->set_var('tr_color',$phpgw->templater_color);

	$name = $phpgw->strip_html($products[$i]['name']);
	if (! $name) 
	{ 
	    $name = '&nbsp;';
	}
	$id = $phpgw->strip_html($products[$i]['id']);

	$price = $products[$i]['price'];
	$retail = round(($price)*(1+$taxpercent),2);

//---------------------------------- list records -------------------------------------

	$t->set_var(array('id' => $id,
            	    'name' => $name,
                   'price' => $price,
        	  'retail' => sprintf("%01.2f",$retail)));

	$t->set_var('view',$phpgw->link('/cart/view_product.php','con=' . $products[$i]['con'] . "&filter=$filter"));

	$t->parse('list','listproducts',True);
    }

// ---------------------------- end list records -----------------------------------------

    $t->parse('out','listproducts_t',True);
    $t->p('out');

    $phpgw->common->phpgw_footer();
?>
