<?php
  /**************************************************************************\
  * phpGroupWare - phpgw_dj                                                  *
  * http://www.phpgroupware.org                                              *
  * Written by: Miles Lott <milosch@phpgroupware.org>                        *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: view.php,v 1.8 2001/05/11 14:56:05 milosch Exp $ */

	$phpgw_info['flags'] = array(
		'currentapp' => 'dj',
		'enable_categories_class' => True
	);
	include('../header.inc.php');

	if (! $song_id)
	{
		Header('Location: ' . $phpgw->link('/dj/index.php',"cat_id=$cat_id&start=$start"));
		$phpgw->common->phpgw_exit();
	}

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array('view' => 'view.tpl'));
	$t->set_block('view','form','form');
	$t->set_block('view','footer','footer');

	$hidden_vars = "<input type=\"hidden\" name=\"start\" value=\"$start\">\n"
		. "<input type=\"hidden\" name=\"id\" value=\"$id\">\n"
		. "<input type=\"hidden\" name=\"cat_id\" value=\"$cat_id\">\n";

	$t->set_var('hidden_vars',$hidden_vars);

	if ($new_cat) { $cat_id = $new_cat; }

	$phpgw->db->query("SELECT * FROM phpgw_dj_songlist WHERE song_id='$song_id'");
	$phpgw->db->next_record();

	$t->set_var('song_name',$phpgw->db->f('song_name'));
	$t->set_var('song_title',$phpgw->db->f('song_title'));
	$t->set_var('song_artist',$phpgw->db->f('song_artist'));
	$t->set_var('song_album',$phpgw->db->f('song_album'));
	$t->set_var('song_year',$phpgw->db->f('song_year'));
	$t->set_var('song_comment',$phpgw->db->f('song_comment'));
	$t->set_var('genre_option',$phpgw->db->f('song_genre'));
	$t->set_var('song_size',nicesize($phpgw->db->f('song_size')));
	$t->set_var('song_length',date('i:s',$phpgw->db->f('song_length')));
	$t->set_var('song_bitrate',$phpgw->db->f('song_bitsize') . lang('kb/s'));
	$t->set_var('song_samplerate',$phpgw->db->f('song_samplerate') . lang('hz'));
	$t->set_var('song_frames',$phpgw->db->f('song_frames'));
	$t->set_var('song_emphasis',$phpgw->db->f('song_emphasis'));
	$t->set_var('song_cmode',$phpgw->db->f('song_cmode'));
	$t->set_var('song_version',$phpgw->db->f('song_version'));
	$t->set_var('song_layer',$phpgw->db->f('song_layer'));

	if ($phpgw->db->f('song_crc'))
	{
		$t->set_var('song_crc',lang('disabled'));
	}
	else
	{
		$t->set_var('song_crc',lang('enabled'));
	}

	if ($phpgw->db->f('song_copyright'))
	{
		$t->set_var('song_copyright',lang('Yes'));
	}
	else
	{
		$t->set_var('song_copyright',lang('No'));
	}

	if($phpgw->db->f('song_original'))
	{
		$t->set_var('song_original',lang('Yes'));
	}
	else
	{
		$t->set_var('song_original',lang('No'));
	}

	if($phpgw->db->f('song_status') == 'A')
	{
		$t->set_var('song_status',lang('Available'));
	}
	else
	{
		$t->set_var('song_status',lang('Unavailable'));
	}

	if($phpgw->db->f('song_cycle_status') == 'A')
	{
		$t->set_var('song_cycle_status',lang('Available'));
	}
	else
	{
		$t->set_var('song_cycle_status',lang('Played'));
	}

	$t->set_var('lang_name',lang('File Name'));
	$t->set_var('lang_title',lang('Title'));
	$t->set_var('lang_artist',lang('Artist'));
	$t->set_var('lang_album',lang('Album'));
	$t->set_var('lang_year',lang('Year'));
	$t->set_var('lang_comment',lang('Comment'));
	$t->set_var('lang_genre',lang('Genre'));
	$t->set_var('lang_size',lang('File Size'));
	$t->set_var('lang_length',lang('Length'));
	$t->set_var('lang_bitrate',lang('Bitrate'));
	$t->set_var('lang_samplerate',lang('Sample Rate'));
	$t->set_var('lang_frames',lang('Frames'));
	$t->set_var('lang_emphasis',lang('Emphasis'));
	$t->set_var('lang_cmode',lang('Channel Mode'));
	$t->set_var('lang_version',lang('Version'));
	$t->set_var('lang_layer',lang('Layer'));
	$t->set_var('lang_crc',lang('Error Correction'));
	$t->set_var('lang_copyright',lang('Copyright'));
	$t->set_var('lang_original',lang('Original'));
	$t->set_var('lang_status',lang('Status'));
	$t->set_var('lang_cycle_status',lang('Cycle Status'));
	$t->set_var('lang_edit',lang('Edit'));

	$t->set_var('song_id',$song_id);
	$t->set_var('sort',$sort);
	$t->set_var('order',$order);
	$t->set_var('filter',$filter);
	$t->set_var('query',$query);
	$t->set_var('start',$start);
	$t->set_var('cat_id',$cat_id);
	$t->set_var('lang_done',lang('Done'));
	$t->set_var('lang_view',lang('View'));
	$t->set_var('lang_cancel',lang('cancel'));
	$t->set_var('lang_submit',lang('submit'));
	$t->set_var('lang_request',lang('request'));
	$t->set_var('edit_link','<form method="POST" action="' . $phpgw->link('/dj/edit.php','song_id=' . $song_id . '&start=' . $start . '&cat_id=' . $cat_id) . '">');
	$t->set_var('done_link','<form method="POST" action="' . $phpgw->link('/dj/index.php','start=' . $start . '&cat_id=' . $cat_id) . '">');
	$t->set_var('request_link',$phpgw->link('/dj/request.php','song_id=' . $song_id . '&start=' . $start . '&cat_id='.$cat_id));

	//$t->set_var('delete_link','<form method="POST" action="'.$phpgw->link('/dj/delete.php') . '">');
	$t->set_var('delete_link','');
	//$t->set_var('delete_button','<input type="submit" name="delete" value="' . lang('Delete') . '">');
	$t->set_var('delete_button','');

	$t->pparse('out','form');
	$t->pparse('out','footer');

	$phpgw->common->phpgw_footer();
?>
