<?php
/**************************************************************************\
* phpGroupWare - Inventory                                                 *
* http://www.phpgroupware.org                                              *
* Written by Bettina Gille [ceb@phpgroupware.org]                          *
* -----------------------------------------------                          *
*  This program is free software; you can redistribute it and/or modify it *
*  under the terms of the GNU General Public License as published by the   *
*  Free Software Foundation; either version 2 of the License, or (at your  *
*  option) any later version.                                              *
\**************************************************************************/
/* $Id: listdist.php,v 1.20 2001/05/10 22:08:57 bettina Exp $ */

    $phpgw_info["flags"] = array('currentapp' => 'inv',
		 'enable_nextmatchs_class' => True);

    include('../header.inc.php');

    $t = new Template(PHPGW_APP_TPL);
    $t->set_file(array('distlist_list_t'	=> 'listdist.tpl',
		        'distlist_list' => 'listdist.tpl'));
    $t->set_block('distlist_list_t','distlist_list','list');
        
    $d = CreateObject('phpgwapi.contacts');
    $c = CreateObject('phpgwapi.categories');
    $c->app_name = 'addressbook';

    $t->set_var('bg_color',$phpgw_info["theme"]["bg_color"]);
    $t->set_var('lang_action',lang('Distributor list'));
    $t->set_var('lang_search',lang('Search'));
    $t->set_var('searchurl',$phpgw->link('/inv/distlist.php',"cat_id=$cat_id"));
    $t->set_var('add_action',$phpgw->link('/inv/adddist.php',"cat_id=$cat_id"));
    $t->set_var('lang_add',lang('Add'));
    $t->set_var('lang_submit',lang('Submit'));
    $t->set_var('lang_all',lang('All'));
    $t->set_var(lang_category,lang('Category'));

    if (! $start) { $start = 0; }

    if (!$filter) { $filter = 'none'; }    

    if (!$cat_id) {
    if ($filter == 'none') { $qfilter  = 'tid=n'; } 
    elseif ($filter == 'private') { $qfilter  = 'tid=n,owner='.$phpgw_info["user"]["account_id"]; } 
    else { $qfilter = 'tid=n,owner='.$filter; }
    }
    else {
    if ($filter == 'none') { $qfilter  = 'tid=n,cat_id='.$cat_id; } 
    elseif ($filter == 'private') { $qfilter  = 'tid=n,owner='.$phpgw_info["user"]["account_id"].',cat_id='.$cat_id; }
    else { $qfilter = 'tid=n,owner='.$filter.'cat_id='.$cat_id; }
    }

    if($phpgw_info["user"]["preferences"]["common"]["maxmatchs"] && $phpgw_info["user"]["preferences"]["common"]["maxmatchs"] > 0) {
    $offset = $phpgw_info["user"]["preferences"]["common"]["maxmatchs"];
    }
    else { $offset = 15; }

    $account_id = $phpgw_info['user']['account_id'];

    $cols = array('org_name' => 'org_name',
		'org_unit' => 'org_unit',
		'industry_type' => 'industry_type',
		'url' => 'url',
		'ftp' => 'ftp'
	);

    $entries = $d->read($start,$offset,$cols,$query,$qfilter,$sort,$order,$account_id);

//--------------------------------- nextmatch --------------------------------------------

    $left = $phpgw->nextmatchs->left('/inv/listdist.php',$start,$d->total_records,"&order=$order&filter=$filter&sort=$sort&query=$query");
    $right = $phpgw->nextmatchs->right('/inv/listdist.php',$start,$d->total_records,"&order=$order&filter=$filter&sort=$sort&query=$query");
    $t->set_var('left',$left);
    $t->set_var('right',$right);

    if ($query) {
        if ($d->total_records == 0) {  $t->set_var('lang_showing',lang('Your search has returned no matchs !')); }
        else { $t->set_var('lang_showing',lang("showing x",$d->total_records)); }
    }
    else {
	if ($d->total_records > $offset) { $t->set_var('lang_showing',lang("showing x - x of x",($start + 1),($start + $offset),$d->total_records)); }
	else { $t->set_var('lang_showing',lang("showing x",$d->total_records)); }
    }

// ------------------------------ end nextmatch ------------------------------------------

// -------------- list header variable template-declaration ------------------------

    $t->set_var('th_bg',$phpgw_info["theme"]["th_bg"]);
    $t->set_var('sort_company',$phpgw->nextmatchs->show_sort_order($sort,'org_name',$order,'/inv/listdist.php',lang('Company name')));
    $t->set_var('sort_department',$phpgw->nextmatchs->show_sort_order($sort,'org_unit',$order,'/inv/listdist.php',lang('Department')));
    $t->set_var('sort_industry_type',$phpgw->nextmatchs->show_sort_order($sort,'industry_type',$order,'/inv/listdist.php',lang('Industry type')));
    $t->set_var('sort_url',$phpgw->nextmatchs->show_sort_order($sort,'url',$order,'/inv/listdist.php',lang('WWW')));
    $t->set_var('sort_ftp',$phpgw->nextmatchs->show_sort_order($sort,'ftp',$order,'/inv/listdist.php',lang('FTP')));
    $t->set_var('lang_products',lang('Products'));
    $t->set_var('lang_view',lang('View'));
    $t->set_var('lang_edit',lang('Edit'));
    $t->set_var('cats_action',$phpgw->link('/inv/listdist.php',"sort=$sort&order=$order&filter=$filter&start=$start&query=$query&cat_id=$cat_id"));
    $t->set_var('cats_list',$c->formated_list('select','all',$cat_id,'True'));

// ------------------------- end header declaration --------------------------------

    for ($i=0;$i<count($entries);$i++) {
    $tr_color = $phpgw->nextmatchs->alternate_row_color($tr_color);
    $t->set_var('tr_color',$tr_color);
    $id            = $entries[$i]['id'];
    $company       = $phpgw->strip_html($entries[$i]['org_name']);
    if (! $company)  $company  = '&nbsp;';
    $department = $phpgw->strip_html($entries[$i]['org_unit']);
    if (! $department)  $department  = '&nbsp;';
    $industry_type = $phpgw->strip_html($entries[$i]['industry_type']);
    if (! $industry_type)  $industry_type  = '&nbsp;';

    $url  = $entries[$i]['url'];

    if (!$url || ($url == 'http://')) {
    $url = ''; 
    $t->set_var('lang_url','&nbsp;');
    }
    else {
    $url = $phpgw->strip_html($url);
    if (! ereg('http://',$url)) { $url = 'http://'. $url; }
    $t->set_var('lang_url',lang('Click me'));
    }
    $t->set_var('url',$url);

    $ftp  = $entries[$i]['ftp'];

    if (!$ftp || ($ftp == 'ftp://')) { 
    $ftp = ""; 
    $t->set_var('lang_ftp','&nbsp;');
    }
    else {
    $ftp = $phpgw->strip_html($ftp);
    if (! ereg('ftp://',$ftp)) { $ftp = 'ftp://'. $ftp; }
    $t->set_var('lang_ftp',lang('Click me'));
    }
    $t->set_var('ftp',$ftp);
    $cat_id = $entries[$i]['cat_id'];

// --------------- template declaration for list records ---------------------------- 

     $t->set_var(array('company' => $company,
		    'department' => $department,
		 'industry_type' => $industry_type,
			   'url' => $url,
			   'ftp' => $ftp));

    $t->set_var('products',$phpgw->link('/inv/listreceipt.php',"filter=$id"));
    $t->set_var('edit',$phpgw->link('/inv/editdist.php',"id=$id&cat_id=$cat_id"));
    $t->set_var('view',$phpgw->link('/inv/viewdist.php',"id=$id&cat_id=$cat_id"));
    $t->set_var('lang_edit_entry',lang('Edit'));

    $t->parse('list','distlist_list',True);
    }
 
    $t->parse('out','distlist_list_t',True);
    $t->p("out");

    $phpgw->common->phpgw_footer();
?>

