<?php
  /**************************************************************************\
  * phpGroupWare application (NNTP)                                               *
  * http://www.phpgroupware.org                                              *
  * Written by Mark Peters <mpeters@satx.rr.com>                             *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

	/* $Id: read_article.php,v 1.23 2001/05/17 04:01:39 skeeter Exp $ */

	$phpgw_flags = Array(
		'currentapp'		=>	'nntp',
		'enable_vfs_class'=>	True
	);

	$phpgw_info['flags'] = $phpgw_flags;
	include('../header.inc.php');

//	include(PHPGW_APP_INC.'/message.inc.php');

	function close_routine()
	{
		global $nntp;
		$nntp->close_port();
	}

	@set_time_limit(0);

	$phpgw->translation->add_app('email');

	function compose($action,$icon)
	{
		global $phpgw, $phpgw_info, $nntp;

		$str = '';
//		$str = '<a href="'.$phpgw->link('/nntp/compose.php','action='.$action.'&folder='.$nntp->con.'&msgnum='.$nntp->msgnum).'">';
		$str .= '<img src="'.$phpgw_info['server']['app_images'] . '/'.$icon.'" height="19" width="26" alt="'.lang($action).'">';
//		$str .= '</a>';

		return $str;
	}

	if (!$phpgw_info['user']['preferences']['nntp'][$folder])
	{
		echo 'You do not have access to this newsgroup!<br>'."\n";
		$phpgw->common->phpgw_footer();
		$phpgw->common->phpgw_exit();
	}

	if(!$folder && !$msgnum)
	{
		echo lang('Cannot display the requested article from this newsgroup')."<br>\n";
		$phpgw->common->phpgw_footer();
		$phpgw->common->phpgw_exit();
	}

	if ($nntp->errorset)
	{
		echo $nntp->error['msg'].':'.$nntp->error['desc']."<br>\n";
		$phpgw->common->phpgw_footer();
		$phpgw->common->phpgw_exit();
	}

	register_shutdown_function('close_routine');

	$p = CreateObject('phpgwapi.Template',$phpgw->common->get_tpl_dir('nntp'));
	$templates = Array(
		'message'	=> 'msg.tpl'
	);

	$p->set_file($templates);
	$p->set_block('message','msg','msg');
	$p->set_block('message','action','action');
	$p->set_block('message','next_prev','next_prev');
	$p->set_block('message','header','header');
	$p->set_block('message','header_data','header_data');

	$var = Array(
		'th_em_folder'		=>	$phpgw_info['theme']['em_folder'],
		'th_font'			=>	$phpgw_info['theme']['font'],
		'th_em_text'		=>	$phpgw_info['theme']['em_folder_text'],
		'th_bg'				=>	$phpgw_info['theme']['th_bg'],
		'th_row_on'			=>	$phpgw_info["theme"]["row_on"],
		'folder_url'		=>	$phpgw->link('/nntp/viewgroup.php','folder='.$nntp->con),
		'folder'				=>	$nntp->folder
	);

	$p->set_var($var);

	$p->parse('out','header');

	$p->set_var('url',compose('reply','sm_reply.gif'));
	$p->parse('rows','action',True);

	$p->set_var('url',compose('reply all','sm_reply_all.gif'));
	$p->parse('rows','action',True);

	$p->set_var('url',compose('forward','sm_forward.gif'));
	$p->parse('rows','action',True);

	$p->set_var('url','<img src="'.$phpgw_info['server']['app_images'] . '/sm_delete.gif" height="19" width="26" alt="'.lang('delete').'">');
	$p->parse('rows','action',True);

	$np_msg = '<a href="'.$phpgw->link('/nntp/read_article.php','folder='.$nntp->con);

	$pm = $nntp->get_prev_article_number($nntp->msgnum);
	if ((int)$pm <> 0)
	{
		$prev_msg = $np_msg.'&msgnum='.(int)$pm.'"><img border="0" src="'.$phpgw_info['server']['images_dir'].'/left.gif" alt="'.lang('Previous').'"></a>';
	}
	else
	{
		$prev_msg = '<img border="0" src="'.$phpgw_info['server']['images_dir'].'/left-grey.gif" alt="'.lang('Previous').'">';
	}

	$nm = $nntp->get_next_article_number($nntp->msgnum);
	if ((int)$nm <> 0)
	{
		$next_msg = $np_msg.'&msgnum='.(int)$nm.'"><img border="0" src="'.$phpgw_info['server']['images_dir'].'/right.gif" alt="'.lang('Next').'"></a>';
	}
	else
	{
		$next_msg = '<img border="0" src="'.$phpgw_info['server']['images_dir'].'/right-grey.gif" alt="'.lang('Next').'">';
	}

	$var = Array(
		'pm'	=>	$prev_msg,
		'nm'	=>	$next_msg
	);
	$p->set_var($var);

	$p->parse('rows','next_prev',True);

	$from = $nntp->msg->from[0];
	$var = Array(
		'label'		=> lang('from'),
		'header_title'	=> send_to($from,$nntp->con),
		'header_icon'	=> add_to_addressbook($from)
	);
	$p->set_var($var);
	$p->parse('data','header_data');
	$p->parse('rows','header',True);

	$var = Array(
		'data'	=> '',
		'label'	=> lang('to')
	);
	$p->set_var($var);
	$to = new address;
	for($i=0;$i<count($nntp->msg->to);$i++)
	{
		if (!$nntp->msg->to[$i]) { break; }
		$to = $nntp->msg->to[$i];
		$topersonal = $to->personal;
		$nntp->db->query("SELECT con FROM newsgroups WHERE name='".$topersonal."' and active='Y'");

		if ($nntp->db->num_rows() > 0)
		{
			$nntp->db->next_record();
			$con = $nntp->db->f('con');
			$header_title = send_to($to,$nntp->con);
			if (!$phpgw_info['user']['preferences']['nntp'][$con])
			{
				$monitor = monitor(1,$con);
			}
			else
			{
				$monitor = monitor(0,0);
			}
		}
		else
		{
			$toadl = $to->adl;
			$header_title = $toadl;
			$monitor = monitor(0,0);
		}
		if($i<count($nntp->msg->to)) { $monitor .= '<br>'; }
		$var = Array(
			'header_title'	=> $header_title,
			'header_icon'	=> $monitor
		);
		$p->set_var($var);
		$p->parse('data','header_data',True);
	}
	$p->parse('rows','header',True);


	if (isset($nntp->header['Cc']) && $nntp->header['Cc'])
	{
		$var = Array(
			'data'	=> '',
			'label'	=> lang('cc')
		);
		$p->set_var($var);
		for($I=0;$i<count($nntp->msg->cc);$i++)
		{
			$var = Array(
				'header_title'	=> send_to($nntp->msg->cc[$i],$nntp->con),
				'header_icon'	=> add_to_addressbook($nntp->msg->cc[$i])
			);
			
			$p->set_var($var);
			$p->parse('data','header_data',True);
		}
		$p->parse('rows','header',True);
	}

	$var = Array(
		'label'	=> lang('date'),
		'header_title'	=> $phpgw->common->show_date($nntp->msg->udate),
		'header_icon'	=>	'',
		'data'	=> ''
	);
	$p->set_var($var);
	
	$p->parse('data','header_data',True);
	$p->parse('rows','header',True);

// Still doing nothing with attachments

	$var = Array(
		'label'	=> lang('subject'),
		'header_title'	=> $nntp->msg->subject,
		'header_icon'	=>	'',
		'data'	=> ''
	);
	$p->set_var($var);
	
	$p->parse('data','header_data',True);
	$p->parse('rows','header',True);

	$p->set_var('textbody',$nntp->build_body_to_print());
	$p->pparse('out','msg');

	$phpgw->common->phpgw_footer();
?>
