<?php
  /**************************************************************************\
  * phpGroupWare API - Commononly used functions                             *
  * This file written by Dan Kuykendall <seek3r@phpgroupware.org>            *
  * and Joseph Engo <jengo@phpgroupware.org>                                 *
  * and Mark Peters <skeeter@phpgroupware.org>                               *
  * Commononly used functions by phpGroupWare developers                     *
  * Copyright (C) 2000, 2001 Dan Kuykendall                                  *
  * -------------------------------------------------------------------------*
  * This library is part of the phpGroupWare API                             *
  * http://www.phpgroupware.org/api                                          * 
  * ------------------------------------------------------------------------ *
  * This library is free software; you can redistribute it and/or modify it  *
  * under the terms of the GNU Lesser General Public License as published by *
  * the Free Software Foundation; either version 2.1 of the License,         *
  * or any later version.                                                    *
  * This library is distributed in the hope that it will be useful, but      *
  * WITHOUT ANY WARRANTY; without even the implied warranty of               *
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     *
  * See the GNU Lesser General Public License for more details.              *
  * You should have received a copy of the GNU Lesser General Public License *
  * along with this library; if not, write to the Free Software Foundation,  *
  * Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA            *
  \**************************************************************************/

	/* $Id: class.datetime.inc.php,v 1.1 2001/05/20 01:17:48 skeeter Exp $ */

	$d1 = strtolower(substr($phpgw_info['server']['api_inc'],0,3));
	$d2 = strtolower(substr($phpgw_info['server']['server_root'],0,3));
	$d3 = strtolower(substr($phpgw_info['server']['app_inc'],0,3));
	if($d1 == 'htt' || $d1 == 'ftp' || $d2 == 'htt' || $d2 == 'ftp' || $d3 == 'htt' || $d3 == 'ftp')
	{
		echo 'Failed attempt to break in via an old Security Hole!<br>'."\n";
		exit;
	}
	unset($d1);
	unset($d2);
	unset($d3);
		
/*!
@class datetime
@abstract datetime class that contains common date/time functions
*/

class datetime
{
	var $tz_offset;
	var $days = Array();

	function datetime()
	{
		global $phpgw_info;
		$this->tz_offset = ((60 * 60) * intval($phpgw_info['user']['preferences']['common']['tz_offset']));
	}
	
	function get_weekday_start($year,$month,$day)
	{
		global $phpgw_info;

		$weekday = $this->day_of_week($year,$month,$day);
		switch($phpgw_info['user']['preferences']['calendar']['weekdaystarts'])
		{
			// Saturday is for arabic support
			case 'Saturday':
				$this->days = Array(
					0 => 'Sat',
					1 => 'Sun',
					2 => 'Mon',
					3 => 'Tue',
					4 => 'Wed',
					5 => 'Thu',
					6 => 'Fri'
				);
				switch($weekday)
				{
					case 0:
						$sday = mktime(2,0,0,$month,$day - 1,$year);
						break;
					case 6:
						$sday = mktime(2,0,0,$month,$day,$year);
						break;
					default:
						$sday = mktime(2,0,0,$month,$day - ($weekday + 1),$year);
						break;
				}
				return $sday;
				break;
			case 'Sunday':
				$this->days = Array(
					0 => 'Sun',
					1 => 'Mon',
					2 => 'Tue',
					3 => 'Wed',
					4 => 'Thu',
					5 => 'Fri',
					6 => 'Sat'
				);
				return mktime(2,0,0,$month,$day - $weekday,$year);
				break;
			case 'Monday':
				$this->days = Array(
					0 => 'Mon',
					1 => 'Tue',
					2 => 'Wed',
					3 => 'Thu',
					4 => 'Fri',
					5 => 'Sat',
					6 => 'Sun'
				);
				switch($weekday)
				{
					case 0:
						$sday = mktime(2,0,0,$month,$day - 6,$year);
						break;
					case 1:
						$sday = mktime(2,0,0,$month,$day,$year);
						break;
					default:
						$sday = mktime(2,0,0,$month,$day - ($weekday - 1),$year);
						break;
				}
				return $sday;
				break;
		}
	}

	function is_leap_year($year)
	{
		if ((intval($year) % 4 == 0) && (intval($year) % 100 != 0) || (intval($year) % 400 == 0))
			return 1;
		else
			return 0;
	}

	function days_in_month($month,$year)
	{
		$days = Array(
			1	=>	31,
			2	=>	28 + $this->is_leap_year(intval($year)),
			3	=>	31,
			4	=>	30,
			5	=>	31,
			6	=>	30,
			7	=>	31,
			8	=>	31,
			9	=>	30,
			10	=>	31,
			11	=>	30,
			12	=>	31
		);
		return $days[intval($month)];
	}

	function date_valid($year,$month,$day)
	{
		return checkdate(intval($month),intval($day),intval($year));
	}

	function time_valid($hour,$minutes,$seconds)
	{
		if(intval($hour) < 0 || intval($hour) > 24)
		{
			return False;
		}
		if(intval($minutes) < 0 || intval($minutes) > 59)
		{
			return False;
		}
		if(intval($seconds) < 0 || intval($seconds) > 59)
		{
			return False;
		}

		return True;
	}

	function day_of_week($year,$month,$day)
	{
		if($month > 2)
		{
			$month -= 2;
		}
		else
		{
			$month += 10;
			$year--;
		}
		$day = (floor((13 * $month - 1) / 5) + $day + ($year % 100) + floor(($year % 100) / 4) + floor(($year / 100) / 4) - 2 * floor($year / 100) + 77);
		return (($day - 7 * floor($day / 7)));
	}
	
	function day_of_year($year,$month,$day)
	{
		$days = array(0,31,59,90,120,151,181,212,243,273,304,334);
        
		$julian = ($days[$month - 1] + $day);

		if($month > 2 && $this->is_leap_year($year))
		{
			$julian++;
		}
		return($julian);
	}

	function date_compare($a_year,$a_month,$a_day,$b_year,$b_month,$b_day)
	{
		$a_date = mktime(0,0,0,intval($a_month),intval($a_day),intval($a_year));
		$b_date = mktime(0,0,0,intval($b_month),intval($b_day),intval($b_year));
		if($a_date == $b_date)
		{
			return 0;
		}
		elseif($a_date > $b_date)
		{
			return 1;
		}
		elseif($a_date < $b_date)
		{
			return -1;
		}
	}

	function time_compare($a_hour,$a_minute,$a_second,$b_hour,$b_minute,$b_second)
	{
		$a_time = mktime(intval($a_hour),intval($a_minute),intval($a_second),0,0,70);
		$b_time = mktime(intval($b_hour),intval($b_minute),intval($b_second),0,0,70);
		if($a_time == $b_time)
		{
			return 0;
		}
		elseif($a_time > $b_time)
		{
			return 1;
		}
		elseif($a_time < $b_time)
		{
			return -1;
		}
	}

	function makegmttime($hour,$minute,$second,$month,$day,$year)
	{
		return $this->gmtdate(mktime($hour, $minute, $second, $month, $day, $year));
	}

	function localdates($localtime)
	{
		global $phpgw;

		$date = Array('raw','day','month','year','full','dow','dm','bd');
		$date['raw'] = $localtime;
		$date['year'] = intval($phpgw->common->show_date($date['raw'],'Y'));
		$date['month'] = intval($phpgw->common->show_date($date['raw'],'m'));
		$date['day'] = intval($phpgw->common->show_date($date['raw'],'d'));
		$date['full'] = intval($phpgw->common->show_date($date['raw'],'Ymd'));
		$date['bd'] = mktime(0,0,0,$date['month'],$date['day'],$date['year']);
		$date['dm'] = intval($phpgw->common->show_date($date['raw'],'dm'));
		$date['dow'] = $this->day_of_week($date['year'],$date['month'],$date['day']);
		$date['hour'] = intval($phpgw->common->show_date($date['raw'],'H'));
		$date['minute'] = intval($phpgw->common->show_date($date['raw'],'i'));
		$date['second'] = intval($phpgw->common->show_date($date['raw'],'s'));
		
		return $date;
	}

	function gmtdate($localtime)
	{
		return $this->localdates($localtime - $this->tz_offset);
	}

}
?>
