<?php
  /**************************************************************************\
  * phpGroupWare - Image Editor                                              *
  * http://www.phpgroupware.org                                              *
  * This application written by Miles Lott <milosch@phpgroupware.org>        *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  /* $Id: class.soimg.inc.php,v 1.6.2.1 2002/06/23 00:46:21 skeeter Exp $ */

	/* img storage class */
	class soimg
	{
		var $db;
		var $grants = '';

		var $debug=False;
		var $account_id;
		var $table = 'phpgw_img';
		var $fields = array(
			'img_id'    => 0,
			'img_owner' => 0,
			'img_file'  => '',
			'img_cat'   => '',
			'img_name'  => '',
			'img_title' => '',
			'img_des'   => '',
			'img_thumb' => '',
			'img_copy'  => ''
		);
		var $qstr = '';

		function soimg($debug=False)
		{
			$this->debug = $debug;
			$this->db = $GLOBALS['phpgw']->db;
			$this->account_id = $GLOBALS['phpgw_info']['user']['account_id'];

			$this->grants = $GLOBALS['phpgw']->acl->get_grants('img');
		}

		function index($start=0,$query='',$sort='ASC',$order='',$cat_id='',$limit=True)
		{
			$fields = $this->_get_fields();
			$fieldstr = implode(',',$fields);

			if (is_array($this->grants))
			{
				$grants = $this->grants;
				while (list($user) = each($grants))
				{
					$public_user_list[] = $user;
				}
				reset($public_user_list);
				$fwhere .= " OR (img_owner IN(" . implode(',',$public_user_list) . ")) ";
			}

			if($query || $this->qstr)
			{
				if($query)
				{
					$querystr = $this->_makequery($query);
				}
				elseif($this->qstr)
				{
					$querystr = $this->_makequery($this->qstr);
				}
				$querystr .= ' AND img_owner=' . $this->account_id . $fwhere;
			}
			else
			{
				$querystr .= ' WHERE img_owner=' . $this->account_id . $fwhere;
			}

			if ($cat_id)
			{
				if($querystr)
				{
					$querystr .= ' AND';
				}
				else
				{
					$querystr .= ' WHERE ';
				}
				$querystr .= ' img_cat=' . $cat_id;
			}

			$sql = "SELECT " . $fieldstr . " FROM " . $this->table . $querystr;

			if($sort && $order)
			{
				$sort = ' ORDER BY ' . $order . ' ' . $sort . ' ';
			}
			else
			{
				$sort = '';
			}

			if($limit)
			{
				$qfunc = '$this->db->limit_query("' . $sql . $sort . '",' . $start . ',__LINE__,__FILE__);';
			}
			else
			{
				$qfunc = '$this->db->query("' . $sql . $sort . '",__LINE__,__FILE__);';
			}

			$this->db->query($sql,__LINE__,__FILE__);
			$this->total = $this->db->num_rows();

			eval($qfunc);

			if($this->db->num_rows())
			{
				$this->data = array();
			}
			while ($this->db->next_record())
			{
				@reset($fields);
				while(list($a,$b) = @each($fields))
				{
					$this->data[$this->db->f('img_id')][$b] = $this->db->f($b);
				}
			}
			return $this->data;
		}

		function read($id)
		{
			if(is_array($id))
			{
				$id = $id['img_id'];
			}
			if (!(($this->bo->grants[$check['img_owner']] & PHPGW_ACL_DELETE) ||
				$check['img_owner'] == $GLOBALS['phpgw_info']['user']['account_id']))

			$id = intval($id);
			$sql = "SELECT * FROM $this->table WHERE img_id=$id";
			$this->db->query($sql,__LINE__,__FILE__);
			$this->db->next_record();

			if (!(($this->grants[$this->db->f('img_owner')] & PHPGW_ACL_READ) ||
				$this->db->f('img_owner') == $GLOBALS['phpgw_info']['user']['account_id']))
			{
				return array(
					'img_id'   => $id,
					'img_name' => lang('access denied')
				);
			}

			@reset($this->fields);
			while(list($a,$b) = @each($this->fields))
			{
				$this->data[$this->db->f('img_id')][$a] = $this->db->f($a);
			}
			return $this->data;
		}

		function edit($data)
		{
			$mode = 'add';
			if($data['img_id'])
			{
				$mode = 'edit';
			}

			$id = intval($data['img_id']);
			$sql = "SELECT * FROM $this->table WHERE img_id=$id";
			$this->db->query($sql,__LINE__,__FILE__);
			$this->db->next_record();

			if($mode == 'edit')
			{
				if (!(($this->grants[$this->db->f('img_owner')] & PHPGW_ACL_READ) ||
					$this->db->f('img_owner') == $GLOBALS['phpgw_info']['user']['account_id']))
				{
					return array(
						'img_id'   => $id,
						'img_name' => lang('access denied')
					);
				}
			}

			switch ($mode)
			{
				case 'add':
					$sql = "INSERT INTO $this->table (img_owner,img_file,img_cat,img_name,img_title,img_des,img_thumb,img_copy)"
						. " VALUES ("
						. "'" . $data['img_owner'] . "',"
						. "'" . $data['img_file']  . "',"
						. "'" . $data['img_cat']   . "',"
						. "'" . $this->db->db_addslashes($data['img_name'])  . "',"
						. "'" . $this->db->db_addslashes($data['img_title']) . "',"
						. "'" . $this->db->db_addslashes($data['img_des'])   . "',"
						. "'" . $data['img_thumb'] . "',"
						. "'" . $data['img_copy']  . "'"
						. ")";

					$this->db->query($sql,__LINE__,__FILE__);
					$newid = $this->db->get_last_insert_id($this->table,'img_id');
					return $newid;
					break;
				case 'edit':
					/*
					 Read the old data and replace new values
					 to make sure we don't lose something.
					*/
					$old = $this->read($data['img_id']);
					$olddata = $old[$data['img_id']];

					@reset($data);
					while(list($key,$val) = @each($data))
					{
						$olddata[$key] = $val;
					}
					$data = $olddata;

					$sql = "UPDATE $this->table SET "
						. "img_owner='" . $data['img_owner'] . "',"
						. "img_file='"  . $data['img_file']  . "',"
						. "img_cat='"   . $data['img_cat']   . "',"
						. "img_name='"  . $this->db->db_addslashes($data['img_name'])  . "',"
						. "img_title='" . $this->db->db_addslashes($data['img_title']) . "',"
						. "img_des='"   . $this->db->db_addslashes($data['img_des'])   . "',"
						. "img_thumb='" . $data['img_thumb'] . "',"
						. "img_copy='"  . $data['img_copy']  . "'"
						. "WHERE img_id=" . $data['img_id'];

					$this->db->query($sql,__LINE__,__FILE__);
					return $data['img_id'];
					break;
				default:
					break;
			}
		}

		function delete($id)
		{
			$id = intval($id);
			$sql = "SELECT * FROM $this->table WHERE img_id=$id";
			$this->db->query($sql,__LINE__,__FILE__);
			$this->db->next_record();

			if (!(($this->grants[$this->db->f('img_owner')] & PHPGW_ACL_READ) ||
				$this->db->f('img_owner') == $GLOBALS['phpgw_info']['user']['account_id']))
			{
				return;
			}

			$sql = "DELETE FROM $this->table WHERE img_id=" . $id;
			$this->db->query($sql,__LINE__,__FILE__);
		}

		function _get_fields()
		{
			if($this->qfields)
			{
				$tmp = explode(',',$this->qfields);
				@reset($tmp);
				while(list($key,$val) = @each($tmp))
				{
					$fields[] = $val;
				}
			}
			else
			{
				@reset($this->fields);
				while (list($key,$val) = each($this->fields))
				{
					$fields[] = $key;
				}
			}
			return $fields;
		}

		function _makequery($query='')
		{
			if (!$query || $this->qstr)
			{
				return;
			}
			elseif($query)
			{
				$look = $query;
			}
			else
			{
				$look = $this->qstr;
			}

			$s = " WHERE (";

			$fields = $this->_get_fields();
			while (list($key,$val) = each($fields))
			{
				if ($val != 'id')
				{
					$s .= $val . " LIKE '%$look%' OR ";
				}
			}
			$s = substr($s,0,-4);
			$s .= ")";

			return $s;
		}
	}
?>
