<?php
	/*******************************************************************\
	* phpGroupWare - Netsaint                                           *
	* http://www.phpgroupware.org                                       *
	*                                                                   *
	* Administration Tool for NetSaint Network Monitor                  *
	* http://www.netsaint.org                                           *
	* Ethan A. Galstad <netsaint@linuxbox.com>                          *
	*                                                                   *
	* Written by Bettina Gille [ceb@phpgroupware.org]                   *
	* -----------------------------------------------                   *
	* Copyright (C) 2001 Bettina Gille                                  *
	*                                                                   *
	* This program is free software; you can redistribute it and/or     *
	* modify it under the terms of the GNU General Public License as    *
	* published by the Free Software Foundation; either version 2 of    *
	* the License, or (at your option) any later version.               *
	*                                                                   *
	* This program is distributed in the hope that it will be useful,   *
	* but WITHOUT ANY WARRANTY; without even the implied warranty of    *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  *
	* General Public License for more details.                          *
	*                                                                   *
	* You should have received a copy of the GNU General Public License *
	* along with this program; if not, write to the Free Software       *
	* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.         *
	\*******************************************************************/
	/* $Id: class.sonetsaint.inc.php,v 1.13 2001/09/06 22:56:15 bettina Exp $ */

	class sonetsaint
	{
		var $grants;

		function sonetsaint()
		{
			global $phpgw, $phpgw_info;

			$this->db		= $phpgw->db;
			$this->db2		= $this->db;
			$this->grants	= $phpgw->acl->get_grants('netsaint');
			$this->owner	= $phpgw_info['user']['account_id'];
		}

		function filter($type)
		{
			switch ($type)
			{
				case 'com_enabled':		$f = " co_type='com' and co_enabled='1'"; break;
				case 'com_all':			$f = " co_type='com'"; break;
				case 'not_all':			$f = " co_type='hnot' or co_type='snot'"; break;
				case 'hnot_enabled':	$f = " co_type='hnot' and co_enabled='1'"; break;
				case 'snot_enabled':	$f = " co_type='snot' and co_enabled='1'"; break;
				case 'host':			$f = " e_type='host'"; break;
				case 'serv':			$f = " e_type='serv'"; break;
			}
			return $f;
		}

		function read_services($start, $limit = True, $query = '', $filter = '', $sort = '', $order = '', $cat_id = '')
		{
			global $phpgw, $phpgw_info;

			if (!$sort)
			{
				$sort = "ASC";
			}

			if ($order)
			{
				$ordermethod = "order by $order $sort";
			}
			else
			{
				$ordermethod = "order by s_host asc";
			}

			if (! $filter)
			{
				$filter = 'none';
			}

			if ($filter == 'none')
			{
				$filtermethod = " ( s_owner=" . $this->owner;
				if (is_array($this->grants))
				{
					$grants = $this->grants;
					while (list($user) = each($grants))
					{
						$public_user_list[] = $user;
					}
					reset($public_user_list);
					$filtermethod .= " OR (s_access='public' AND s_owner in(" . implode(',',$public_user_list) . ")))";
				}
				else
				{
					$filtermethod .= ' )';
				}
			}
			elseif ($filter == 'yours')
			{
				$filtermethod = " s_owner='" . $this->owner . "'";
			}
			else
			{
				$filtermethod = " s_owner='" . $this->owner . "' AND s_access='private'";
			}

			if ($cat_id)
			{
				$filtermethod .= " AND s_cat='$cat_id' ";
			}

			if ($query)
			{
				$searchmethod = " AND s_host like '%$query%' OR s_descr like '%$query%'  OR s_period like '%$query%' OR cg like '%$query%'";
			}

			$sql = "SELECT * FROM phpgw_ns_service WHERE $filtermethod $searchmethod";

			$this->db2->query($sql,__LINE__,__FILE__);
			$this->total_records = $this->db2->num_rows();
			$this->db->limit_query($sql . $ordermethod,$start,__LINE__,__FILE__);

			$i = 0;
			while ($this->db->next_record())
			{
				$s[$i]['id']		= $this->db->f('s_id');
				$s[$i]['host']		= $this->db->f('s_host');
				$s[$i]['owner']		= $this->db->f('s_owner');
				$s[$i]['date']		= $this->db->f('s_date');
				$s[$i]['cat']		= $this->db->f('s_cat');
				$s[$i]['period']	= $this->db->f('s_period');
				$s[$i]['cg']		= $this->db->f('cg');
				$s[$i]['descr']		= $this->db->f('s_descr');
				$i++;
			}
			return $s;
		}

		function read_config_services($host)
		{
			global $phpgw;

			$sql = "SELECT * FROM phpgw_ns_service WHERE s_host='$host'";

			$this->db->query($sql,__LINE__,__FILE__);

			$i = 0;
			while ($this->db->next_record())
			{
				$s[$i]['host']			= $this->db->f('s_host');
				$s[$i]['descr']			= $this->db->f('s_descr');
				$s[$i]['vol']			= $this->db->f('s_vol');
				$s[$i]['s_period']		= $this->db->f('s_period');
				$s[$i]['max']			= $this->db->f('s_max');
				$s[$i]['c_intval']		= $this->db->f('c_intval');
				$s[$i]['r_intval']		= $this->db->f('r_intval');
				$s[$i]['cg']			= $this->db->f('cg');
				$s[$i]['not_intval']	= $this->db->f('not_intval');
				$s[$i]['c_period']		= $this->db->f('not_period');
				$s[$i]['rec']			= $this->db->f('not_recover');
				$s[$i]['crit']			= $this->db->f('not_crit');
				$s[$i]['warn']			= $this->db->f('not_warn');
				$s[$i]['event']			= $this->db->f('s_event');
				$s[$i]['command']		= $this->db->f('s_comand');
				$i++;
			}
			return $s;
		}

		function read_escal($type, $start, $limit = True, $query = '', $filter = '', $sort = '', $order = '', $cat_id = '')
		{
			global $phpgw, $phpgw_info;

			if (!$sort)
			{
				$sort = "ASC";
			}

			if ($order)
			{
				$ordermethod = "order by $order $sort";
			}
			else
			{
				$ordermethod = "order by e_name asc";
			}

			if (! $filter)
			{
				$filter = 'none';
			}

			if ($filter == 'none')
			{
				$filtermethod = " ( e_owner=" . $this->owner;
				if (is_array($this->grants))
				{
					$grants = $this->grants;
					while (list($user) = each($grants))
					{
						$public_user_list[] = $user;
					}
					reset($public_user_list);
					$filtermethod .= " OR (e_access='public' AND e_owner in(" . implode(',',$public_user_list) . ")))";
				}
				else
				{
					$filtermethod .= ' )';
				}
			}
			elseif ($filter == 'yours')
			{
				$filtermethod = " e_owner='" . $this->owner . "'";
			}
			else
			{
				$filtermethod = " e_owner='" . $this->owner . "' AND e_access='private'";
			}

			if ($cat_id)
			{
				$filtermethod .= " AND e_cat='$cat_id' ";
			}

			if ($query)
			{
				$searchmethod = " AND e_name like '%$query%' OR e_descr like '%$query%'  OR e_c_group like '%query%'";
			}

			$escal_type = $this->filter($type);

			$sql = "SELECT * FROM phpgw_ns_escalation WHERE $filtermethod $searchmethod AND $escal_type";

			$this->db2->query($sql,__LINE__,__FILE__);
			$this->total_records = $this->db2->num_rows();
			$this->db->limit_query($sql . $ordermethod,$start,__LINE__,__FILE__);

			$i = 0;
			while ($this->db->next_record())
			{
				$e[$i]['id']		= $this->db->f('e_id');
				$e[$i]['name']		= $this->db->f('e_name');
				$e[$i]['owner']		= $this->db->f('e_owner');
				$e[$i]['date']		= $this->db->f('e_date');
				$e[$i]['cat']		= $this->db->f('e_cat');
				$e[$i]['first']		= $this->db->f('e_first');
				$e[$i]['last']		= $this->db->f('e_last');
				$i++;
			}
			return $e;
		}

		function read_config_escal($type, $host_name = '')
		{
			global $phpgw;

			$escal_type = $this->filter($type);

			if ($type == 'serv')
			{
				$host_filter = " AND e_name = '$host_name'";
			}

			$sql = "SELECT * FROM phpgw_ns_escalation WHERE $escal_type $host_filter";

			$this->db->query($sql,__LINE__,__FILE__);

			$i = 0;
			while ($this->db->next_record())
			{
				$es[$i]['name']		= $this->db->f('e_name');
				$es[$i]['descr']	= $this->db->f('e_descr');
				$es[$i]['first']	= $this->db->f('e_first');
				$es[$i]['last']		= $this->db->f('e_last');
				$es[$i]['cg']		= $this->db->f('e_c_groups');
				$i++;
			}
			return $es;
		}

		function read_comands($start, $limit = True, $query = '', $type, $sort = '', $order = '', $cat_id = '')
		{
			global $phpgw, $phpgw_info;

			if (!$sort)
			{
				$sort = "ASC";
			}

			if ($order)
			{
				$ordermethod = "order by $order $sort";
			}
			else
			{
				$ordermethod = "order by co_name asc";
			}

			$filter = $this->filter($type);

			if ($cat_id)
			{
				$filter .= " AND co_cat='$cat_id' ";
			}

			if ($query)
			{
				$filter .= " AND co_name like '%$query%' OR co_line like '%$query%'";
			}

			$sql = "SELECT * FROM phpgw_ns_comand WHERE $filter";

			$this->db2->query($sql,__LINE__,__FILE__);
			$this->total_records = $this->db2->num_rows();

			if ($limit)
			{
				$this->db->limit_query($sql . $ordermethod,$start,__LINE__,__FILE__);
			}
			else
			{
				$this->db->query($sql . $ordermethod,__LINE__,__FILE__);
			}

			$i = 0;
			while ($this->db->next_record())
			{
				$co[$i]['id']		= $this->db->f('co_id');
				$co[$i]['name']		= $this->db->f('co_name');
				$co[$i]['date']		= $this->db->f('co_date');
				$co[$i]['cat']		= $this->db->f('co_cat');
				$co[$i]['enabled']	= $this->db->f('co_enabled');
				$co[$i]['type']		= $this->db->f('co_type');
				$co[$i]['line']		= $this->db->f('co_line');
				$i++;
			}
			return $co;
		}

		function read_config_commands()
		{
			global $phpgw;

			$sql = "SELECT * FROM phpgw_ns_comand WHERE co_enabled=1";

			$this->db->query($sql,__LINE__,__FILE__);

			$i = 0;
			while ($this->db->next_record())
			{
				$co[$i]['name']		= $this->db->f('co_name');
				$co[$i]['line']		= $this->db->f('co_line');
				$i++;
			}
			return $co;
		}


		function read_single_service($i_id)
		{
			$this->db->query("select * from phpgw_ns_service where s_id='$i_id'",__LINE__,__FILE__);

			if ($this->db->next_record())
			{
				$s['id']			= $this->db->f('s_id');
				$s['host']			= $this->db->f('s_host');
				$s['access']		= $this->db->f('s_access');
				$s['owner']			= $this->db->f('s_owner');
				$s['date']			= $this->db->f('s_date');
				$s['cat']			= $this->db->f('s_cat');
				$s['descr']			= $this->db->f('s_descr');
				$s['vol']			= $this->db->f('s_vol');
				$s['s_period']		= $this->db->f('s_period');
				$s['max']			= $this->db->f('s_max');
				$s['c_intval']		= $this->db->f('c_intval');
				$s['r_intval']		= $this->db->f('r_intval');
				$s['cg']			= $this->db->f('cg');
				$s['not_intval']	= $this->db->f('not_intval');
				$s['c_period']		= $this->db->f('not_period');
				$s['rec']			= $this->db->f('not_recover');
				$s['crit']			= $this->db->f('not_crit');
				$s['warn']			= $this->db->f('not_warn');
				$s['event']			= $this->db->f('s_event');
				$s['comand']		= $this->db->f('s_comand');
				return $s;
			}
		}

		function read_single_comand($i_id)
		{
			$this->db->query("select * from phpgw_ns_comand where co_id='$i_id'",__LINE__,__FILE__);

			if ($this->db->next_record())
			{
				$co['id']		= $this->db->f('co_id');
				$co['name']		= $this->db->f('co_name');
				$co['line']		= $this->db->f('co_line');
				$co['date']		= $this->db->f('co_date');
				$co['cat']		= $this->db->f('co_cat');
				$co['enabled']	= $this->db->f('co_enabled');
				$co['type']		= $this->db->f('co_type');
				return $co;
			}
		}

		function read_single_escal($i_id)
		{
			$this->db->query("select * from phpgw_ns_escalation where e_id='$i_id'",__LINE__,__FILE__);

			if ($this->db->next_record())
			{
				$es['id']		= $this->db->f('e_id');
				$es['owner']	= $this->db->f('e_owner');
				$es['access']	= $this->db->f('e_access');
				$es['cat']		= $this->db->f('e_cat');
				$es['date']		= $this->db->f('e_date');
				$es['name']		= $this->db->f('e_name');
				$es['descr']	= $this->db->f('e_descr');
				$es['first']	= $this->db->f('e_first');
				$es['last']		= $this->db->f('e_last');
				$es['cg']		= $this->db->f('e_c_groups');
				return $es;
			}
		}

		function add_service($values)
		{
			$values['descr'] = addslashes($values['descr']);

			$this->db->query("INSERT INTO phpgw_ns_service (s_host,s_owner,s_access,s_cat,s_date,s_descr,s_vol,s_period,s_max,c_intval,"
							. "r_intval,cg,not_intval,not_period,not_recover,not_crit,not_warn,s_event,s_comand) VALUES ('"
							. $values['host'] . "','" . $this->owner . "','" . $values['access'] . "','" . $values['cat'] . "','" . time() . "','"
							. $values['descr'] . "','" . $values['vol'] . "','" . $values['s_period'] . "','" . $values['max'] . "','" . $values['c_intval']
							. "','" . $values['r_intval'] . "','" . $values['cg'] . "','" . $values['not_intval'] . "','" . $values['c_period'] . "','"
							. $values['rec'] . "','" . $values['crit'] . "','" . $values['warn'] . "','" . $values['event'] . "','"
							. $values['comand'] . "')",__LINE__,__FILE__);
		}

		function add_escal($values)
		{
			$this->db->query("INSERT INTO phpgw_ns_escalation (e_owner,e_access,e_cat,e_date,e_name,e_type,e_descr,e_first,e_last,"
							. "e_c_groups) VALUES ('" . $this->owner . "','" . $values['access'] . "','" . $values['cat'] . "','" . time() . "','"
							. $values['name'] . "','" . $values['type'] . "','" . $values['descr'] . "','" . $values['first'] . "','" . $values['last']
							. "','" . $values['cg'] . "')",__LINE__,__FILE__);
		}

		function add_comand($values)
		{
			$values['line'] = addslashes($values['line']);
			$values['name'] = addslashes($values['name']);

			$this->db->query("INSERT INTO phpgw_ns_comand (co_name,co_cat,co_date,co_line,co_enabled,co_type) VALUES ('" . $values['name'] . "','"
							. $values['cat'] . "','" . time() . "','" . $values['line'] . "','" . $values['enabled'] . "','" . $values['type']
							. "')",__LINE__,__FILE__);
		}

		function edit_service($values)
		{
			$values['descr'] = addslashes($values['descr']);

			$this->db->query("UPDATE phpgw_ns_service set s_host='" . $values['host'] . "', s_access='" . $values['access'] . "', s_cat='"
							. $values['cat'] . "', s_date='" . time() . "', s_descr='" . $values['descr'] . "', s_vol='" . $values['vol']
							. "', s_period='" . $values['s_period'] . "', s_max='" . $values['max'] . "', c_intval='" . $values['c_intval']
							. "', r_intval='" . $values['r_intval'] . "', cg='" . $values['cg'] . "', not_intval='" . $values['not_intval']
							. "', not_period='" . $values['c_period'] . "', not_recover='" . $values['rec'] . "', not_crit='" . $values['crit']
							. "', not_warn='" . $values['warn'] . "', s_event='" . $values['event'] . "', s_comand='" . $values['comand']
							. "' WHERE s_id='" . $values['id'] . "'",__LINE__,__FILE__);
		}

		function edit_escal($values)
		{
			$this->db->query("UPDATE phpgw_ns_escalation set e_name='" . $values['name'] . "', e_access='" . $values['access'] . "', e_cat='"
							. $values['cat'] . "', e_date='" . time() . "', e_descr='" . $values['descr'] . "', e_first='" . $values['first']
							. "', e_last='" . $values['last'] . "', e_c_groups='" . $values['cg'] . "' WHERE e_id='" . $values['id']
							. "'",__LINE__,__FILE__);
		}

		function edit_comand($values)
		{
			$values['line'] = addslashes($values['line']);
			$values['name'] = addslashes($values['name']);

			$this->db->query("UPDATE phpgw_ns_comand set co_name='" . $values['name'] . "', co_cat='" . $values['cat'] . "', co_date='" . time()
							. "', co_line='" . $values['line'] . "', co_enabled='" . $values['enabled'] . "' WHERE co_id='" . $values['id']
							. "'",__LINE__,__FILE__);
		}

		function delete_service($i_id)
		{
			$this->db->query("DELETE FROM phpgw_ns_service WHERE s_id='$i_id'",__LINE__,__FILE__);
		}

		function delete_comand($i_id)
		{
			$this->db->query("DELETE FROM phpgw_ns_comand WHERE co_id='$i_id'",__LINE__,__FILE__);
		}

		function delete_escal($i_id)
		{
			$this->db->query("DELETE FROM phpgw_ns_escalation WHERE e_id='$i_id'",__LINE__,__FILE__);
		}

		function in_array($needle,$haystack)
		{
			if (function_exists('in_array'))
			{
				return in_array($needle,$haystack);
			}
			while (list ($k,$v) = each($haystack))
			{
				if ($v == $needle)
				{
					return True;
				}
			}
			return False;
		}

		function select_comand_list($type, $selected = '')
		{
			global $phpgw;

			if (!is_array($selected))
			{
				$selected = explode(',',$selected);
			}

			$co = $this->read_comands($start, False, $query, $type, $sort, $order, $cat_id);

			for ($i=0;$i<count($co);$i++)
			{
				$co_select .= '<option value="' . $co[$i]['name'] . '"';
				if ($this->in_array($co[$i]['name'],$selected))
				{
					$co_select .= ' selected';
				}
				$co_select .= '>' . $phpgw->strip_html($co[$i]['name']) . '</option>';
			}
			return $co_select;
		}

		function select_service_list($selected = '')
		{
			global $phpgw;

			$se = $this->read_services($start, False, $query, $type, $sort, $order, $cat_id);

			for ($i=0;$i<count($se);$i++)
			{
				$se_select .= '<option value="' . $se[$i]['descr'] . '"';
				if ($se[$i]['descr'] == $selected)
				{
					$se_select .= ' selected';
				}
				$se_select .= '>' . $phpgw->strip_html($se[$i]['host']) . ' - ' . $phpgw->strip_html($se[$i]['descr']). '</option>';
			}
			return $se_select;
		}

		function exists($action, $i_name, $i_id = '')
		{
			if ($action == 'comand')
			{
				if ($i_id && ($i_id != 0))
				{
					$editexists = " and co_id != '$i_id'";
				}

				$this->db->query("select count(*) from phpgw_ns_comand where co_name = '$i_name' $editexists",__LINE__,__FILE__);
			}

			$this->db->next_record();

			if ($this->db->f(0))
			{
				return True;
			}
			else
			{
				return False;
			}
		}
	}
?>
