################################################################################
# HOST CONFIGURATION
#
# SYNTAX:
# host[<host_name>]=<host_alias>;<address>;<parent_hosts>;<host_check_command>;
#                   <max_attempts>;<notification_interval>;<notification_period>
#                   ;<notify_recovery>;<notify_down>;<notify_unreachable>;
#                   <event_handler>
#
# <host_name>             = A short name used to identify the host
# <host_alias>            = A longer name and/or description of the host
# <address>               = The address of the host (preferably an IP address!)
# <parent_hosts>          = This is a list of short name of the "parent" hosts of
#			    this host.  Multiple parent hosts are separated by 
#                           commas. Read the HTML documentation (particularly the
#                           "theory of operation section") for more information
#                           on this.
# <host_check_command>    = This is the short name for the command that should
#                           be used to check to see if the host is down or up
# <max_attempts>          = Maximum number of times the host will be checked 
#                           before it is deemed to be "down"
# <notification_interval> = Number of minutes to wait before re-notifying 
#                           contact that the host is still down.
# <notification_period>   = The short name of the timeperiod (as defined above) 
#                           that determines when notifications about this host
#                           may be sent out
# <notify_recovery>       = Notify contacts when this host recovers? 
#                           1= yes, 0 =no
# <notify_down>           = Notify contacts when host is down?
#                           1 = yes, 0 = no
# <notify_unreachable>    = Notify contacts when host is unreachable?
#                           1 = yes, 0 = no
# <event_handler>         = The short name of the command that should be
#                           executed when change is detected in the status of
#                           host (i.e. when it goes down or recovers.   If you
#                           do not want to use an event handlers, leave this
#                           options blanks
#
################################################################################

host[{h_name}]={h_alias};{h_address};{h_parent};{h_command};{h_max};{h_intval};{h_period};{h_rec};{h_down};{h_unreach};{h_event}

################################################################################
# SERVICE CONFIGURATION
#
# SYNTAX:
# service[<host>]=<description>;<volatile>;<check_period>;<max_attempts>;
#                 <check_interval>;<retry_interval>;<notification_group>;
#                 <notification_interval>;<notification_period>;<notify_recovery>;
#                 <notify_critical>;<notify_warning>;<event_hander>;<check_command>
#
# <host>                  = The short name of the host (as defined above) that
#                           this service is running on
# <description>           = A description for this service (i.e 'My Website')
# <volatile>              = Specifies whether this service is volatile or not.
#                           See the HTML documentation for more information on
#                           what volatile services are and how they work.  Most
#                           service are *not* volatile.
#                           1 = volatile, 0 = not volatile
# <check_period>          = The short name of the timeperiod (as defined above)
#                           that determines when this service may be checked
# <max_attempts>          = Number of times to retry the service check before
#                           reporting that it is at a warning or critical level
# <check_interval>        = Number of minutes to wait between regular checks
#                           of the service
# <retry_interval>        = Number of minutes to wait between retry of the
#                           service
# <notification_group>    = The short name of the contact group (as defined
#                           above) that should be notified of problems with 
#                           this service.
# <notification_interval> = Number of minutes to wait before *re-notifying*
#                           a contact that the service is *still* at a warning
#                           or critical level (after we notify them about the
#                           problem immediately)
# <notification_period>   = The short name of the timeperiod (as defined above)
#                           that determines when notifications about this
#                           service may be sent out
# <notify_recovery>       = Notify contacts when this service recovers?
#                           1 = yes, 0 = no
# <notify_critical>       = Notify contacts when service is at a critical level?
#                           1 = yes, 0 = no
# <notify_warning>        = Notify contacts when service is at a warning level?
#                           1 = yes, 0 = no
# <event_handler>         = A command that should be executed whenever a change
#                           is detected in the status of the service.  If you do
#		            not want to use an event handler, leave this option
#                           blank.
# <check_command>         = The command used to check the status of the service.
#                           This can be in one of three formats (described
#                           below)
#
# Note: Commands can be in on of three formats...
#
#       1. The short name of a command defined above (this is the simplest form)
#
#		Example: <command_name>
#
#       2. The short name of a command defined above, with arguments delimited
#          with bang (!) characters.  If this format is used, the command must
#          be defined with $ARGx$ macros in order to actually use the arguments
#          that are passed to it (read the doc for more information on this)
#
#		Example: <command_name>!<arg1>!<arg2>!...!<argx>
#
#	3. An actual command line enclosed in quotation marks.  The outside
#          quotation marks are stripped off before the command is exected.
#          Macros can be used in this "raw" command format, but are still 
#          limited to only the macros which are valid during service check
#          (read the documentation for more information)
#
#		Example: "./check_ping $HOSTADDRESS$ 40 80 5.0 100.0"
################################################################################
