<?php
/*
 * $Id: ch05,v 1.19 2001/06/11 16:28:51 aschirmer Exp aschirmer
 * A program that browses Meerkat's story store and allows
 * users to append spontaneous discussions to the story
 * in question.
 */

/*
  * This code has been modified to fit within phpGW by
  * Mark A Peters <skeeter@phpgroupware.org>
 */

	/* $Id: index.php,v 1.5.2.1 2002/08/12 21:59:01 skeeter Exp $ */

	$phpgw_info = array();
	$phpgw_flags = Array(
		'currentapp'	=> 'meerkat',
		'noheader'	=> True,
		'nonavbar'	=> True,
		'nofooter'	=> True
	);
	$GLOBALS['phpgw_info']['flags'] = $phpgw_flags;
	include('../header.inc.php');

	$enable_discussion = True;

	// dispatch() ensures error handling for XML-RPC calls
	function dispatch($client, $method, $args)
	{
		$msg = CreateObject('phpgwapi.xmlrpcmsg',$method,$args);
/*		 $client->debug = True; */
		$resp=$client->send($msg);
		if (!$resp)
		{
			echo '<p>IO error: '.$client->errstr.'</p>';
			$GLOBALS['phpgw']->common->phpgw_exit();
		}
		if ($resp->faultCode())
		{
			echo '<p>There was an error: '.$resp->faultCode().' '.$resp->faultString().'</p>';
			$GLOBALS['phpgw']->common->phpgw_exit();
		}
		return phpgw_xmlrpc_decode($resp->value());
	}

	if($enable_discussion)
	{
		// create client for discussion server
		$dclient = CreateObject('phpgwapi.xmlrpc_client','/phpgroupware/meerkat/discuss.php',$HTTP_HOST,80);
	}

	// check if we're posting a comment, and send it if so
	$storyid=$HTTP_POST_VARS['storyid'];
	if ($storyid)
	{
		// send the comment to the comment server
		$res=dispatch($dclient, 'discuss.addComment',
			Array(
				CreateObject('phpgwapi.xmlrpcval',$storyid),
				CreateObject('phpgwapi.xmlrpcval',stripslashes($HTTP_POST_VARS['name'])),
				CreateObject('phpgwapi.xmlrpcval',stripslashes($HTTP_POST_VARS['commenttext']))
			)
		);

		// send the browser back to the originating page
		Header('Location: '.$GLOBALS['phpgw']->link('/meerkat/index.php','catid='.$HTTP_POST_VARS['catid'].'&chanid='.$HTTP_POST_VARS['chanid'].'&oc='.$HTTP_POST_VARS['catid']));
		$GLOBALS['phpgw']->common->phpgw_exit();
	}

	unset($GLOBALS['phpgw_info']['flags']['noheader']);
	unset($GLOBALS['phpgw_info']['flags']['nonavbar']);
	unset($GLOBALS['phpgw_info']['flags']['nofooter']);
	$GLOBALS['phpgw']->common->phpgw_header();
	
	// handle incoming parameters
	$catid = $HTTP_POST_VARS['catid'] ? $HTTP_POST_VARS['catid'] : $HTTP_GET_VARS['catid'];
	if($HTTP_POST_VARS['oc']==$catid || $HTTP_GET_VARS['oc'] == $catid)
	{
		$chanid = $HTTP_POST_VARS['chanid'] ? $HTTP_POST_VARS['chanid'] : $HTTP_GET_VARS['chanid'];
	}
	else
	{
		$chanid = 0;
	}

	// create the Meerkat client
	$client = CreateObject('phpgwapi.xmlrpc_client','/meerkat/xml-rpc/server.php','www.oreillynet.com', 80);

	if($HTTP_POST_VARS['comment'] || $HTTP_GET_VARS['comment'])
	{
		$comment = $HTTP_POST_VARS['comment'] ? $HTTP_POST_VARS['comment'] : $HTTP_GET_VARS['comment'];
		// we're making a comment on a story,
		// so display a comment form.
		// TODO: retrieve the story headline & abstract
		echo '<h3>' . lang('Make a comment on the story') . '</h3>'."\n"
			. '<form method="post" action="'.$GLOBALS['phpgw']->link('/meerkat/index.php').'">'."\n"
			. '<p>' . lang('Your name') . ':<br /><input type="text" size="30" name="name" /></p>'."\n"
			. '<p>' . lang('Your comment') . ':<br /><textarea rows="5" cols="60" name="commenttext"></textarea></p>'."\n"
			. '<input type="submit" value="Send comment" />'."\n"
			. '<input type="hidden" name="storyid" value="'.$comment.'" />'."\n"
			. '<input type="hidden" name="chanid"  value="'.$chanid.'" />'."\n"
			. '<input type="hidden" name="catid"   value="'.$catid.'" />'."\n"
			. '</form>'."\n";
	}
	else
	{
		// we're exploring the story store
		// first, get the list of top-level categories
		$categories = dispatch($client,'meerkat.getCategories',array());

		// if we've chosen a category, get list of
		// web sites in that category
		if($catid)
		{
			$sources = dispatch($client,
				'meerkat.getChannelsByCategory',
				array(
					CreateObject('phpgwapi.xmlrpcval',$catid,'int')
				)
			);
		}

		// if we've chosen a web site, get list of
		// most recent 5 stories from that web site
		if ($chanid)
		{
			$stories = dispatch($client,
				'meerkat.getItems',
				array(
					CreateObject('phpgwapi.xmlrpcval',
						array(
							'channel'		=> CreateObject('phpgwapi.xmlrpcval',$chanid,'int'),
							'ids'			=> CreateObject('phpgwapi.xmlrpcval',1,'int'),
							'descriptions'	=> CreateObject('phpgwapi.xmlrpcval',200,'int'),
							'num_items'		=> CreateObject('phpgwapi.xmlrpcval',5,'int'),
							'dates'			=> CreateObject('phpgwapi.xmlrpcval',0,'int')
						),
						'struct'
					)
				)
			);
		}
		// data is fetched, now render the page

		// category chooser
		$str = '';
		if(!$catid)
		{
			$str .= '<option value="0">' . lang('Choose a category') . '</option>'."\n";
		}

		while(list($k,$v) = each($categories))
		{
			$str .= '<option value="'.$v['id'].'"'.($v['id']==$catid?' selected':'').'>'.$v['title'].'</option>'."\n";
		}

		echo '<form method="post" action="'.$GLOBALS['phpgw']->link('/meerkat/index.php').'">'."\n"
			. '<p>' . lang('Subject area') . ':<br />'."\n".'<select name="catid">'."\n".$str.'</select></p>'."\n";

		if($catid)
		{
			// web site chooser
			$str = '';
			if(!$chanid)
			{
				$str .= '<option value="0">' . lang('Choose a source') . '</option>'."\n";
			}
			while(list($k,$v) = each($sources))
			{
				$str .= '<option value="'.$v['id'].'"'.($v['id']==$chanid?' selected':'').'>'.$v['title'].'</option>'."\n";
			}
			echo '<p>' . lang('News source') . ':<br />'."\n".'<select name="chanid">'."\n".$str.'</select>'."\n".'</p>'."\n";
		} // end if ($catid)

		echo '<p><input type="submit" value="Update" /></p>'."\n"
			. '<input type="hidden" name="oc" value="'.$catid.'" />'."\n"
			. '</form>'."\n";

		if($chanid)
		{
			echo '<h2>' . lang('Stories available') . '</h2>'."\n"
				. '<table>'."\n";

			// story chooser
			while(list($k,$v) = each($stories))
			{
				echo '<tr>'."\n".'<td><b><a target="_blank" href="'.$v['link'].'">'.$v['title'].'</a></b><br />'."\n"
					. $v['description'].'<br />'."\n";
					
				if($enable_discussion)
				{
					echo '<em><a target="_blank" href="'.$v['link'].'">' . lang('Read full story') . '</a> '."\n"
						. '<a href="'.$GLOBALS['phpgw']->link('/meerkat/index.php','catid='.$catid.'&chanid='.$chanid.'&oc='.$oc.'&comment='.$v['id']).'">' . lang('Comment on this story') . '</a>'."\n".'</em>'."\n";
				}
				echo '</td>'."\n".'</tr>'."\n";

				if($enable_discussion)
				{
					// now look for existing comments that the comment server knows about.
					$res = dispatch($dclient,'discuss.getComments',array(CreateObject('phpgwapi.xmlrpcval',$v['id'])));

					if(sizeof($res)>0)
					{
						// $res is an array of associative arrays -- the result of an xmlrpc_decode() call

						$str = '';
						for($i=0; $i<sizeof($res); $i++)
						{
							$s=$res[$i];
							$str .= '<p><b>From:</b> '.htmlentities($s['name']).'<br />'."\n".'<b>' . lang('Comment') . ':</b> '.htmlentities($s['comment']).'</p>'."\n";
						}
						echo '<tr><td bgcolor="#dddddd"><p><b><i>' . lang('Comments on this story') . ':</i></b></p>'."\n".$str.'</td></tr>'."\n";
					}
				}
				echo '<tr><td><hr /></td></tr>'."\n";
			}
			echo '</table>'."\n";
		} // end if ($chanid) 
	} // end if ($HTTP_POST_VARS['comment'])

	echo '<!-- page footer -->'."\n"
		. '<a href="http://meerkat.oreillynet.com"><img align="right" src="'.$GLOBALS['phpgw']->common->image('meerkat','meerkat-powered.jpg').'" height="31" width="88" alt="Meerkat powered, yeah!" border="0" hspace="8" /></a>'."\n"
		. '<em>$Id: index.php,v 1.5.2.1 2002/08/12 21:59:01 skeeter Exp $</em></p>'."\n";
	$GLOBALS['phpgw']->common->phpgw_footer();
?>
