<?php
	/*******************************************************************\
	* phpGroupWare - Netsaint                                           *
	* http://www.phpgroupware.org                                       *
	*                                                                   *
	* Administration Tool for NetSaint Network Monitor                  *
	* http://www.netsaint.org                                           *
	* Ethan A. Galstad <netsaint@linuxbox.com>                          *
	*                                                                   *
	* Written by Bettina Gille [ceb@phpgroupware.org]                   *
	* -----------------------------------------------                   *
	* Copyright (C) 2001,2002 Bettina Gille                             *
	*                                                                   *
	* This program is free software; you can redistribute it and/or     *
	* modify it under the terms of the GNU General Public License as    *
	* published by the Free Software Foundation; either version 2 of    *
	* the License, or (at your option) any later version.               *
	*                                                                   *
	* This program is distributed in the hope that it will be useful,   *
	* but WITHOUT ANY WARRANTY; without even the implied warranty of    *
	* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  *
	* General Public License for more details.                          *
	*                                                                   *
	* You should have received a copy of the GNU General Public License *
	* along with this program; if not, write to the Free Software       *
	* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.         *
	\*******************************************************************/
	/* $Id: class.bonetsaint.inc.php,v 1.22.2.2 2002/02/01 23:25:56 ceb Exp $ */

	class bonetsaint
	{
		var $action;

		var $public_functions = array
		(
			'cached_accounts'		=> True,
			'check_perms'			=> True,
			'read_items'			=> True,
			'check_values'			=> True,
			'save_item'				=> True,
			'read_single_item'		=> True,
			'select_comand_list'	=> True,
			'select_service_list'	=> True,
			'check_config_status'	=> True,
			'set_config_status'		=> True,
			'create_config'			=> True
		);

		function bonetsaint($session=False, $action = '')
		{
			global $phpgw;

			$this->sonetsaint = CreateObject('netsaint.sonetsaint');

			if ($session)
			{
				$this->read_sessiondata($action);
				$this->use_session = True;
			}

			global $start, $query, $filter, $sort, $order, $cat_id;

			if(isset($start)) { $this->start = $start; }
			if(isset($query)) { $this->query = $query; }
			if(!empty($filter)) { $this->filter = $filter; }
			if(isset($sort)) { $this->sort = $sort; }
			if(isset($order)) { $this->order = $order; }
			if(isset($cat_id)) { $this->cat_id = $cat_id; }
		}

		function type($action)
		{
			switch ($action)
			{
				case 'service'	: $column = 'netsaint_service'; break;
				case 'serv'		: $column = 'netsaint_eserv'; break;
				case 'host'		: $column = 'netsaint_ehost'; break;
				case 'com_all'	: $column = 'netsaint_com'; break;
				case 'not_all'	: $column = 'netsaint_not'; break;
			}
			return $column;
		}

		function save_sessiondata($data, $action)
		{
			global $phpgw;

			if ($this->use_session)
			{
				$column = $this->type($action);
				$phpgw->session->appsession('session_data',$column,$data);
			}
		}

		function read_sessiondata($action)
		{
			global $phpgw;

			$column = $this->type($action);
			$data = $phpgw->session->appsession('session_data',$column);

			$this->start	= $data['start'];
			$this->query	= $data['query'];
			$this->filter	= $data['filter'];
			$this->sort 	= $data['sort'];
			$this->order	= $data['order'];
			$this->cat_id	= $data['cat_id'];
		}

		function check_config_status()
		{
			global $phpgw;

			$update = $phpgw->session->appsession('session_data','netsaint_update');

			if ($update == 'yes')
			{
				return True;
			}
			else
			{
				return False;
			}
		}

		function set_config_status($onoff)
		{
			global $phpgw;

			if ($onoff == 'on')
			{
				$phpgw->session->appsession('session_data','netsaint_update','yes');
			}
			else
			{
				$phpgw->session->appsession('session_data','netsaint_update','no');
			}
		}

		function read_items($action, $start, $limit, $query, $filter, $sort, $order, $cat_id)
		{
			if ($action == 'service')
			{
				$items = $this->sonetsaint->read_services($start, $limit, $query, $filter, $sort, $order, $cat_id);
			}
			elseif ($action == 'host' || $action == 'serv')
			{
				$items = $this->sonetsaint->read_escal($action, $start, $limit, $query, $filter, $sort, $order, $cat_id);
			}
			else
			{
				$items = $this->sonetsaint->read_comands($start, $limit, $query, $filter, $sort, $order, $cat_id);		
			}
			$this->total_records = $this->sonetsaint->total_records;
			return $items;
		}

		function read_single_item($action, $i_id)
		{
			if ($action == 'service')
			{
				$item = $this->sonetsaint->read_single_service($i_id);
			}
			elseif ($action == 'escal')
			{
				$item = $this->sonetsaint->read_single_escal($i_id);
			}
			else
			{
				$item = $this->sonetsaint->read_single_comand($i_id);
			}
			return $item;
		}

		function select_comand_list($type, $selected)
		{
			$co_list = $this->sonetsaint->select_comand_list($type, $selected);
			return $co_list;
		}

		function select_service_list($selected)
		{
			$se_list = $this->sonetsaint->select_service_list($selected);
			return $se_list;
		}

		function check_perms($has, $needed)
		{
			return (!!($has & $needed) == True);
		}

		function cached_accounts($account_id)
		{
			global $phpgw;

			$this->accounts = CreateObject('phpgwapi.accounts',$account_id);

			$this->accounts->read_repository();

			$cached_data[$this->accounts->data['account_id']]['account_lid'] = $this->accounts->data['account_lid'];
			$cached_data[$this->accounts->data['account_id']]['firstname']   = $this->accounts->data['firstname'];
			$cached_data[$this->accounts->data['account_id']]['lastname']    = $this->accounts->data['lastname'];

			return $cached_data;
		}

		function check_values($action, $values)
		{
			global $phpgw;

			if ($action == 'comand')
			{
				if (!$values['name'])
				{
					$error[] = lang('Please enter a name !');
				}
				else
				{
					if (strlen($values['name']) >= 25)
					{
						$error[] = lang('The short name can not exceed 25 characters in length !');
					}
					else
					{
						$exists = $this->sonetsaint->exists($action, $values['name'], $values['id']);
						if ($exists)
						{
							$error[] = lang('This name has been used already !');
						}
					}
				}

				if (!$values['line'])
				{
					$error[] = lang('Please enter a comand line !');
				}
			}

			if ($action == 'escal')
			{
				if (!$values['name'])
				{
					if ($values['type'] == 'host')
					{
						$error[] = lang('Please select the host group this escalation is valid for !');
					}
					else
					{
						$error[] = lang('Please select the host this escalation is valid for !');
					}
				}

				if ($values['type'] == 'serv' && !$values['descr'])
				{
					$error[] = lang('Please choose the service !');
				}

				if (!$values['first'])
				{
					$error[] = lang('Please enter the first notification that this escalation is valid for !');
				}

				if (!$values['cg'])
				{
					$error[] = lang('Please select the contact group !');
				}
			}

			if ($action == 'service')
			{
				if (!$values['descr'])
				{
					$error[] = lang('Please enter a description !');
				}

				if (strlen($values['descr']) >= 255)
				{
					$error[] = lang('The description can not exceed 255 characters in length !');
				}

				if ((!$values['s_period']) || (!$values['c_period']))
				{
					$error[] = lang('Please choose the time periods !');
				}

				if ((!$values['r_intval']) || (!$values['c_intval']) || (!$values['not_intval']))
				{
					$error[] = lang('Please specify the pause times !');
				}

				if (!$values['max'])
				{
					$error[] = lang('Please specify the maximal retries !');
				}

				if (!$values['comand'])
				{
					$error[] = lang('Please choose the command !');
				}

				if (!$values['cg'])
				{
					$error[] = lang('Please choose the contact group !');
				}

				if (!$values['host'])
				{
					$error[] = lang('Please choose the host !');
				} 
			}

			if (is_array($error))
			{
				return $error;
			}
		}

		function save_item($action, $values)
		{
			if ($values['access'])
			{
				$values['access'] = 'private';
			}
			else
			{
				$values['access'] = 'public';
			}

			if ($action == 'service')
			{
				if ($values['vol'])
				{
					$values['vol'] = '1';
				}
				else
				{
					$values['vol'] = '0';
				}

				if ($values['crit'])
				{
					$values['crit'] = '1';
				}
				else
				{
					$values['crit'] = '0';
				}

				if ($values['warn'])
				{
					$values['warn'] = '1';
				}
				else
				{
					$values['warn'] = '0';
				}

				if ($values['rec'])
				{
					$values['rec'] = 1;
				}
				else
				{
					$values['rec'] = 0;
				}

				$values['max'] = intval($values['max']);
				$values['c_intval'] = intval($values['c_intval']);
				$values['r_intval'] = intval($values['r_intval']);
				$values['not_intval'] = intval($values['not_intval']);

				if ($values['id'])
				{
					if ($values['id'] != 0)
					{
						$this->sonetsaint->edit_service($values);
					}
				}
				else
				{
					$this->sonetsaint->add_service($values);
				}
			}
			elseif ($action == 'escal')
			{
				$values['first'] = intval($values['first']);
				$values['last'] = intval($values['last']);

				if ($values['id'])
				{
					if ($values['id'] != 0)
					{
						$this->sonetsaint->edit_escal($values);
					}
				}
				else
				{
					$this->sonetsaint->add_escal($values);
				}
			}
			else
			{
				if (!$values['type'])
				{
					$values['type'] = 'com';
				}

				if ($values['enabled'])
				{
					$values['enabled'] = '1';
				}
				else
				{
					$values['enabled'] = '0';
				}

				if ($values['id'])
				{
					if ($values['id'] != 0)
					{
						$this->sonetsaint->edit_comand($values);
					}
				}
				else
				{
					$this->sonetsaint->add_comand($values);
				}
			}
			$this->set_config_status('on');
		}

		function delete_item($action,$i_id)
		{
			if ($action == 'service')
			{
				$this->sonetsaint->delete_service($i_id);
			}
			elseif ($action == 'host' || $action == 'serv')
			{
				$this->sonetsaint->delete_escal($i_id);
			}
			else
			{
				$this->sonetsaint->delete_comand($i_id);
			}
			$this->set_config_status('on');
		}

		function get_config()
		{
			global $phpgw;

			$phpgw->config = CreateObject('phpgwapi.config');
			$phpgw->config->read_repository();

			$co = $phpgw->config->config_data;

			$phpgw->config->save_repository(True);
			return $co;
		}

		function check_config()
		{
			$co = $this->get_config();

			$doc_root = $GLOBALS['HTTP_SERVER_VARS']['DOCUMENT_ROOT'] ? $GLOBALS['HTTP_SERVER_VARS']['DOCUMENT_ROOT'] : $GLOBALS['DOCUMENT_ROOT'];

			if (is_array($co))
			{
				if (isset($co['conf_dir']))
				{
					if (substr($co['conf_dir'],0,strlen($doc_root)) == $doc_root)
					{
						$msg[] = lang('The directory to store the configuration files must be outside of the webservers *DocumentRoot* !<br>Please contact the administrator to correct this setting !');
					}
				}

				if (! isset($co['ns_conf']) || ! isset($co['ns_log']) || ! isset($co['ns_group']) || ! isset($co['ns_user']) || ! isset($co['ns_extcom']) || ! isset($co['ns_lock']) || ! isset($co['conf_dir']))
				{
					$msg[] = lang('Please contact the administrator to configure netsaint !');
				}
			}
			else
			{
				$msg[] = lang('Please contact the administrator to configure netsaint !');
			}

			if (is_array($msg))
			{
				return $msg;
			}
		}

		function save_config($conf_file, $config)
		{
			$file = fopen($conf_file,'w+');
 //			ftruncate($file,0);
			fwrite($file,$config);
			fclose($file);
		}

		function create_config()
		{
			$this->t	= $GLOBALS['phpgw']->template;
			$co			= $this->get_config();

			if (!is_dir($co['conf_dir'] . '/netsaint'))
			{
				mkdir($co['conf_dir'] . '/netsaint',0700);
			}

			$co['conf_dir'] = $co['conf_dir'] . '/netsaint';

// --------------------------------- timeperiod -------------------------------

			$config = $this->t->set_file(array('config_time_t' => 'config_time.tpl'));
			$config .= $this->t->set_block('config_time_t','config_time','time');

			$this->sotimeperiod = CreateObject('netsaint.sotimeperiod');

			$time_list = $this->sotimeperiod->read_config_timeperiods();

			for ($i=0;$i<count($time_list);$i++)
			{
				$config .= $this->t->set_var(array
				(
					'tp_name'	=> stripslashes($time_list[$i]['name']),
					'tp_alias'	=> stripslashes($time_list[$i]['alias']),
					'tp_sun'	=> $time_list[$i]['sun'],
					'tp_mon'	=> $time_list[$i]['mon'],
					'tp_tue'	=> $time_list[$i]['tue'],
					'tp_wed'	=> $time_list[$i]['wed'],
					'tp_thu'	=> $time_list[$i]['thu'],
					'tp_fri'	=> $time_list[$i]['fri'],
					'tp_sat'	=> $time_list[$i]['sat']
				));

				$this->t->fp('time','config_time',True);
			}

			$config .= $this->t->fp('out','config_time_t',True);

// --------------------------------- end timeperiod ---------------------------

// --------------------------------- host group -------------------------------

			$config .= $this->t->set_file(array('config_hg_t' => 'config_hg.tpl'));
			$config .= $this->t->set_block('config_hg_t','config_hg','hg');

			$this->sonshost = CreateObject('netsaint.sonshost');
			$hg_list = $this->sonshost->read_config_hgs();

			for ($i=0;$i<count($hg_list);$i++)
			{
				$config .= $this->t->set_var(array
				(
					'hg_name'	=> stripslashes($hg_list[$i]['name']),
					'hg_alias'	=> stripslashes($hg_list[$i]['alias']),
					'hg_cg'		=> stripslashes($hg_list[$i]['cg']),
					'hg_hosts'	=> stripslashes($hg_list[$i]['hosts'])
				));

				$this->t->fp('hg','config_hg',True);
			}

			$config .= $this->t->fp('out','config_hg_t',True);

// --------------------------------- end host group -------------------------------

// --------------------------------- contact group -------------------------------

			$config .= $this->t->set_file(array('config_cg_t' => 'config_cg.tpl'));
			$config .= $this->t->set_block('config_cg_t','config_cg','cg');

			$this->sonscontact = CreateObject('netsaint.sonscontact');
			$cg_list = $this->sonscontact->read_config_cgs();

			for ($i=0;$i<count($cg_list);$i++)
			{
				$config .= $this->t->set_var(array
				(
					'cg_name'		=> stripslashes($cg_list[$i]['name']),
					'cg_alias'		=> stripslashes($cg_list[$i]['alias']),
					'cg_contacts'	=> stripslashes($cg_list[$i]['contacts'])
				));

				$this->t->fp('cg','config_cg',True);
			}

			$config .= $this->t->fp('out','config_cg_t',True);

// --------------------------------- end contact group -------------------------------

// --------------------------------- beginn not host group -------------------------------

			$config .= $this->t->set_file(array('config_ehost_t' => 'config_not_host.tpl'));
			$config .= $this->t->set_block('config_ehost_t','config_ehost','ehost');

			$eh_list = $this->sonetsaint->read_config_escal('host',$host_name = '');

			for ($i=0;$i<count($eh_list);$i++)
			{
				$config .= $this->t->set_var(array
				(
					'e_name'	=> stripslashes($eh_list[$i]['name']),
					'e_first'	=> $eh_list[$i]['first'],
					'e_last'	=> $eh_list[$i]['last'],
					'e_cg'		=> stripslashes($eh_list[$i]['cg'])
				));
				$this->t->fp('ehost','config_ehost',True);
			}

			$config .= $this->t->fp('out','config_ehost_t',True);

// --------------------------------- end not host group -------------------------------

			$conf_file = $co['conf_dir'] . '/hosts.cfg';
			$this->save_config($conf_file,$config);

// --------------------------------- end hosts.cfg ------------------------------------


// --------------------------------- commands -----------------------------------------

			$config = $this->t->set_file(array('config_command_t' => 'config_comands.tpl'));
			$config .= $this->t->set_block('config_command_t','config_command','command');

			$command_list = $this->sonetsaint->read_config_commands();

			for ($i=0;$i<count($command_list);$i++)
			{
				$config .= $this->t->set_var(array
				(
					'c_name'		=> stripslashes($command_list[$i]['name']),
					'c_line'		=> stripslashes($command_list[$i]['line'])
				));

				$this->t->fp('command','config_command',True);
			}

			$config .= $this->t->fp('out','config_command_t',True);

			$conf_file = $co['conf_dir'] . '/commands.cfg';
			$this->save_config($conf_file,$config);

// --------------------------------- end commands -------------------------------

// --------------------------------- contacts -----------------------------------

			$config = $this->t->set_file(array('config_contact_t' => 'config_contact.tpl'));
			$config .= $this->t->set_block('config_contact_t','config_contact','contact');

			$contact_list = $this->sonscontact->read_config_contacts();

			for ($i=0;$i<count($contact_list);$i++)
			{
				$config .= $this->t->set_var(array
				(
					'c_name'		=> stripslashes($contact_list[$i]['name']),
					'c_alias'		=> stripslashes($contact_list[$i]['alias']),
					'csv_period'	=> stripslashes($contact_list[$i]['csv_period']),
					'h_period'		=> stripslashes($contact_list[$i]['h_period']),
					's_rec'			=> $contact_list[$i]['s_rec'],
					's_crit'		=> $contact_list[$i]['s_crit'],
					's_warn'		=> $contact_list[$i]['s_warn'],
					'h_rec'			=> $contact_list[$i]['h_rec'],
					'h_down'		=> $contact_list[$i]['h_down'],
					'h_unreach'		=> $contact_list[$i]['h_unreach'],
					's_command'		=> stripslashes($contact_list[$i]['s_command']),
					'h_command'		=> stripslashes($contact_list[$i]['h_command']),
					'email'			=> stripslashes($contact_list[$i]['email']),
					'pager'			=> stripslashes($contact_list[$i]['pager'])
				));

				$this->t->fp('contact','config_contact',True);
			}

			$config .= $this->t->fp('out','config_contact_t',True);

			$conf_file = $co['conf_dir'] . '/contacts.cfg';
			$this->save_config($conf_file,$config);

			$netsaint_include[] = '/contacts.cfg'; 

// --------------------------------- end contacts -------------------------------

// --------------------------------- hosts --------------------------------------

			$host_list = $this->sonshost->read_config_hosts();

			for ($i=0;$i<count($host_list);$i++)
			{
				$config = $this->t->set_file(array('config_host'	=> 'config_host.tpl',
												'config_service'	=> 'config_service.tpl',
												'config_nservice'	=> 'config_not_service.tpl',
												'config_eservice'	=> 'config_e_service.tpl'));

				$config .= $this->t->set_var('h_name',stripslashes($host_list[$i]['name']));
				$config .= $this->t->set_var('h_alias',stripslashes($host_list[$i]['alias']));
				$config .= $this->t->set_var('h_address',stripslashes($host_list[$i]['address']));
				$config .= $this->t->set_var('h_parent',stripslashes($host_list[$i]['parent']));
				$config .= $this->t->set_var('h_command',stripslashes($host_list[$i]['command']));
				$config .= $this->t->set_var('h_max',$host_list[$i]['max']);
				$config .= $this->t->set_var('h_intval',$host_list[$i]['intval']);
				$config .= $this->t->set_var('h_period',stripslashes($host_list[$i]['period']));
				$config .= $this->t->set_var('h_rec',$host_list[$i]['recover']);
				$config .= $this->t->set_var('h_down',$host_list[$i]['down']);
				$config .= $this->t->set_var('h_unreach',$host_list[$i]['unreach']);
				$config .= $this->t->set_var('h_event',stripslashes($host_list[$i]['event']));

				$config .= $this->t->fp('out','config_host',True);

				$service_list = $this->sonetsaint->read_config_services($host_list[$i]['name']);
				for ($j=0;$j<count($service_list);$j++)
				{
					$config .= $this->t->set_var(array
					(
						's_host'		=> stripslashes($service_list[$j]['host']),
						's_descr'		=> stripslashes($service_list[$j]['descr']),
						's_vol'			=> $service_list[$j]['vol'],
						'check_period'	=> stripslashes($service_list[$j]['s_period']),
						's_max'			=> $service_list[$j]['max'],
						'check_intval'	=> $service_list[$j]['c_intval'],
						'retry_intval'	=> $service_list[$j]['r_intval'],
						'cg'			=> stripslashes($service_list[$j]['cg']),
						'not_intval'	=> $service_list[$j]['not_intval'],
						'not_period'	=> stripslashes($service_list[$j]['c_period']),
						'not_rec'		=> $service_list[$j]['rec'],
						'not_crit'		=> $service_list[$j]['crit'],
						'not_warn'		=> $service_list[$j]['warn'],
						's_event'		=> stripslashes($service_list[$j]['event']),
						's_command'		=> stripslashes($service_list[$j]['command'])
					));
					$config .= $this->t->fp('service','config_service',True);
				}

				$config .= $this->t->fp('out','config_nservice',True);

				$es_list = $this->sonetsaint->read_config_escal('serv',$host_list[$i]['name']);
				for ($k=0;$k<count($es_list);$k++)
				{
					$config .= $this->t->set_var(array
					(
						'es_name'	=> stripslashes($es_list[$k]['name']),
						'es_descr'	=> stripslashes($es_list[$k]['descr']),
						'es_first'	=> $es_list[$k]['first'],
						'es_last'	=> $es_list[$k]['last'],
						'es_cg'		=> stripslashes($es_list[$k]['cg'])
					));
					$config .= $this->t->fp('eservice','config_eservice',True);
				}

				$conf_file = $co['conf_dir'] . '/' . $host_list[$i]['name'] . '.cfg';
				$this->save_config($conf_file,$config);

				$netsaint_include[] = '/' . $host_list[$i]['name'] . '.cfg'; 
			}

// --------------------------------- end hosts -----------------------------------

// --------------------------------- ns ------------------------------------------

			$config = $this->t->set_file(array('config_ns_t' => 'config_netsaint.tpl'));
			$config .= $this->t->set_block('config_ns_t','config_ns','ns');

			$config .= $this->t->set_var('ns_conf',$co['ns_conf']);
			$config .= $this->t->set_var('ns_user',$co['ns_user']);
			$config .= $this->t->set_var('ns_group',$co['ns_group']);
			$config .= $this->t->set_var('ns_extcom',$co['ns_extcom']);
			$config .= $this->t->set_var('ns_lock',$co['ns_lock']);
			$config .= $this->t->set_var('ns_log',$co['ns_log']);

			for ($i=0;$i<count($netsaint_include);$i++)
			{
				$config .= $this->t->set_var(array
				(
					'include_files' => 'cfg_file=' . $co['ns_dir'] . $netsaint_include[$i]
				));	
				$this->t->fp('ns','config_ns',True);
			}

			$config .= $this->t->fp('out','config_ns_t',True);

			$conf_file = $co['conf_dir'] . '/netsaint.cfg';
			$this->save_config($conf_file,$config);

// --------------------------------- end ns --------------------------------------

		}
	}
?>
